/*
 * Decompiled with CFR 0.152.
 */
package lev.debug;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lev.Ln;

public class LDebug {
    public static boolean timeStamp = false;
    public static boolean timeElapsed = false;
    private static Boolean on = true;
    private static ArrayList<String> bannedHeaders = new ArrayList();
    private FileWriter writer;
    private int debugCounter = 0;
    private int spacing = 0;
    private long startTime;
    private String openFile;
    private long lastStamp = System.nanoTime();
    private static ArrayList<LDebug> debugs = new ArrayList();

    public LDebug(String path, int space) {
        this.openDebug(path, space);
        this.init();
    }

    public LDebug() {
        this.init();
    }

    private void init() {
        debugs.add(this);
    }

    public static void on(Boolean b) {
        on = b;
    }

    public static boolean on() {
        return on;
    }

    public final void openDebug(String path, int space) {
        try {
            File f;
            this.closeDebugFile();
            this.openFile = path;
            this.startTime = System.currentTimeMillis();
            this.debugCounter = 1;
            this.spacing = space;
            int index = path.lastIndexOf(92);
            int index2 = path.lastIndexOf(47);
            if (index2 > index) {
                index = index2;
            }
            if (!(f = new File(path.substring(0, index + 1))).exists()) {
                f.mkdirs();
            }
            this.writer = new FileWriter(path);
            this.w("OPEN DEBUG FILE", "Opening Debug File");
        }
        catch (Exception e) {
            System.err.println("Caught Exception: " + e.getMessage());
        }
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public void w(String header, String ... input) {
        if (on.booleanValue() && this.writer != null && input.length > 0) {
            if (bannedHeaders.contains(input[0])) {
                return;
            }
            try {
                long timestamp = System.nanoTime();
                StringBuilder times = new StringBuilder();
                if (timeElapsed) {
                    times.append(Ln.nanoTimeString(System.currentTimeMillis() - this.startTime));
                }
                if (timeElapsed && timeStamp) {
                    times.append("][");
                }
                if (timeStamp) {
                    times.append((timestamp - this.lastStamp) / 1000L);
                }
                this.lastStamp = timestamp;
                this.writer.write(LDebug.spaceLeft(true, this.spacing, ' ', this.debugCounter++, times.toString(), "[" + header + "]  "));
                for (String x : input) {
                    this.writer.write(x);
                }
                this.writer.write(13);
                this.writer.write(10);
            }
            catch (IOException e) {
                System.err.println("Caught Exception: " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("Caught Exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void writeException(String in) {
        if (in.length() > 0) {
            this.w("EXCEPTION", in);
        }
    }

    public void writeException(char in) throws IOException {
        this.writer.write(in);
    }

    public void flushDebug() {
        try {
            if (on.booleanValue() && this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeDebugFile() {
        if (this.writer != null) {
            this.w("DEBUG", "Closing Debug File.  Time was: " + (System.currentTimeMillis() - this.startTime));
            try {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void clearBannedHeaders() {
        bannedHeaders.clear();
    }

    public void addBannedHeader(String in) {
        bannedHeaders.add(in);
    }

    public void addBannedHeader(String[] input) {
        bannedHeaders.addAll(Arrays.asList(input));
    }

    private static String spaceLeft(Boolean concat, int spaces, char c, int counter, String time, String ... input) {
        StringBuilder counterStr = new StringBuilder().append('[').append(Integer.toString(counter)).append(']');
        if (!time.equals("")) {
            counterStr.append('[').append(time).append(']');
        }
        return counterStr.append(Ln.spaceLeft(concat, spaces - counterStr.length(), c, input)).toString();
    }

    public static void wrapUp() {
        on = true;
        for (LDebug d : debugs) {
            d.closeDebugFile();
        }
        on = false;
    }

    public static void wrapUpAndExit() {
        LDebug.on(false);
        LDebug.wrapUp();
        System.exit(0);
    }

    public String getOpenPath() {
        return this.openFile;
    }

    public int line() {
        return this.debugCounter;
    }
}

