/*
 * Decompiled with CFR 0.152.
 */
package lev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import lev.LImport;
import lev.LInChannel;
import lev.Ln;

public class LShrinkArray
extends LImport {
    private ByteBuffer buffer;

    public LShrinkArray(byte[] in) {
        this.buffer = ByteBuffer.wrap(in);
    }

    public LShrinkArray(ByteBuffer array_) {
        this.buffer = array_.duplicate();
    }

    public LShrinkArray(LImport rhs, int high) {
        if (rhs.getClass() == this.getClass()) {
            LShrinkArray rhss = (LShrinkArray)rhs;
            this.buffer = rhss.buffer.slice();
        } else {
            this.buffer = ByteBuffer.wrap(rhs.getBytes(0, high));
        }
        this.buffer.limit(high);
    }

    public LShrinkArray(LShrinkArray rhs) {
        this(rhs, rhs.available());
    }

    public LShrinkArray(File f) throws FileNotFoundException, IOException {
        LInChannel in = new LInChannel(f);
        this.buffer = ByteBuffer.wrap(in.extract(0, in.available()));
        in.close();
    }

    @Override
    public Boolean isDone() {
        return !this.buffer.hasRemaining();
    }

    @Override
    public final int available() {
        return this.buffer.remaining();
    }

    @Override
    public final void skip(int skip) {
        this.buffer.position(this.buffer.position() + skip);
    }

    @Override
    public void jumpBack(int amount) {
        this.skip(-amount);
    }

    @Override
    public byte[] extractUntil(int delimiter) {
        int counter = 1;
        byte[] array = this.buffer.array();
        for (int i = this.buffer.arrayOffset() + this.buffer.position(); i < this.buffer.limit() + this.buffer.arrayOffset(); ++i) {
            if (array[i] != delimiter) {
                ++counter;
                continue;
            }
            byte[] out = this.extract(counter - 1);
            this.skip(1);
            return out;
        }
        return new byte[0];
    }

    public byte[] extractUntil(String delimiter) {
        return this.extractUntil(new byte[][]{Ln.toByteArray(delimiter)});
    }

    @Override
    public byte[] extract(int amount) {
        byte[] bytes = new byte[amount];
        this.buffer.get(bytes);
        return bytes;
    }

    @Override
    public void pos(long pos) {
        this.buffer.position((int)pos);
    }

    @Override
    public long pos() {
        return this.buffer.position();
    }

    @Override
    public void close() {
        this.buffer.clear();
    }

    public String toString() {
        long pos = this.pos();
        this.buffer.position(0);
        int[] bytes = Ln.toIntArray(this.getAllBytes());
        this.buffer.position((int)pos);
        int count = 0;
        String out = "";
        for (int i = 0; i < bytes.length && i < 1000; ++i) {
            out = out + Ln.printHex(bytes[i]);
            out = (long)(i + 1) == pos ? out + ">" : ((long)i == pos ? out + "<" : out + " ");
            if (++count != 16) continue;
            count = 0;
            out = out + "\n";
        }
        return out;
    }
}

