/*
 * Decompiled with CFR 0.152.
 */
package lev;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LMergeMap<K, V>
implements Iterable<V> {
    Map<K, ArrayList<V>> map;
    boolean sorted;
    boolean unique;

    public LMergeMap(Boolean sorted) {
        this(sorted, true);
    }

    public LMergeMap(Boolean sorted, Boolean unique) {
        this.map = sorted != false ? new TreeMap<K, ArrayList<V>>() : new HashMap<K, ArrayList<V>>();
        this.sorted = sorted;
        this.unique = unique;
    }

    public void clear() {
        this.map.clear();
    }

    public void addAll(LMergeMap<K, V> in) {
        for (K k : in.keySet()) {
            this.map.put(k, in.get(k));
        }
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (ArrayList<V> vals : this.map.values()) {
            for (V v : vals) {
                if (!v.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Map.Entry<K, ArrayList<V>>> entrySet() {
        return this.map.entrySet();
    }

    public ArrayList<V> get(K key) {
        return this.map.get(key);
    }

    public int hashcode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void put(K key, V value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new ArrayList());
        }
        if (!this.unique || !this.map.get(key).contains(value)) {
            this.map.get(key).add(value);
        }
    }

    public void put(K key, ArrayList<V> value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            for (V v : value) {
                this.put(key, v);
            }
        }
    }

    public void remove(K key) {
        if (this.map.containsKey(key)) {
            this.map.get(key).clear();
            this.map.remove(key);
        }
    }

    public int size() {
        return this.map.size();
    }

    public int numVals() {
        int sum = 0;
        for (ArrayList<V> vals : this.map.values()) {
            sum += vals.size();
        }
        return sum;
    }

    public Collection<ArrayList<V>> values() {
        return this.map.values();
    }

    public ArrayList<V> valuesFlat() {
        ArrayList<V> out = new ArrayList<V>();
        for (ArrayList<V> vals : this.map.values()) {
            out.addAll(vals);
        }
        return out;
    }

    public Map<K, V> flatten() {
        AbstractMap out = this.sorted ? new TreeMap() : new HashMap();
        for (K key : this.map.keySet()) {
            ArrayList<V> val = this.map.get(key);
            if (val.size() <= 0) continue;
            out.put(key, val.get(0));
        }
        return out;
    }

    public LMergeMap<V, K> flip() {
        LMergeMap<V, K> flip = new LMergeMap<V, K>(this.sorted, this.unique);
        for (K key : this.map.keySet()) {
            for (V val : this.map.get(key)) {
                flip.put(val, key);
            }
        }
        return flip;
    }

    public ArrayList<String> print() {
        ArrayList<String> out = new ArrayList<String>();
        for (K key : this.map.keySet()) {
            out.add(key.toString());
            for (V vals : this.get(key)) {
                out.add("   " + vals.toString());
            }
        }
        return out;
    }

    @Override
    public Iterator<V> iterator() {
        return this.valuesFlat().iterator();
    }
}

