/*
 * Decompiled with CFR 0.152.
 */
package lev;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import lev.LImport;

public class LInChannel
extends LImport {
    protected FileInputStream iStream;
    protected FileChannel iChannel;
    protected long end;

    public LInChannel() {
    }

    public LInChannel(String path) {
        this.openFile(path);
    }

    public LInChannel(File f) {
        this.openFile(f);
    }

    public LInChannel(LInChannel rhs, long allocation) {
        this.slice(rhs, allocation);
    }

    protected void slice(LInChannel rhs, long allocation) {
        LInChannel fc = rhs;
        this.iStream = fc.iStream;
        this.iChannel = fc.iChannel;
        this.end = this.pos() + allocation;
    }

    public void openFile(String path) {
        try {
            this.iStream = new FileInputStream(path);
            this.iChannel = this.iStream.getChannel();
            this.end = this.iChannel.size();
        }
        catch (IOException ex) {
            Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void openFile(File f) {
        this.openFile(f.getPath());
    }

    @Override
    public int read() {
        try {
            return this.iStream.read();
        }
        catch (IOException ex) {
            Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public ByteBuffer extractByteBuffer(int skip, int read) {
        super.skip(skip);
        ByteBuffer buf = ByteBuffer.allocate(read);
        try {
            this.iChannel.read(buf);
        }
        catch (IOException ex) {
            Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
        }
        buf.flip();
        return buf;
    }

    @Override
    public void pos(long pos) {
        try {
            this.iChannel.position(pos);
        }
        catch (IOException ex) {
            Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public long pos() {
        try {
            return this.iChannel.position();
        }
        catch (IOException ex) {
            Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
            return -1L;
        }
    }

    @Override
    public final void close() {
        if (this.iStream != null) {
            try {
                this.iStream.close();
                this.iChannel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public final int available() {
        return (int)(this.end - this.pos());
    }

    @Override
    public Boolean isDone() {
        return this.pos() == this.end;
    }

    @Override
    public byte[] extract(int amount) {
        ByteBuffer allocate = ByteBuffer.allocate(amount);
        try {
            this.iChannel.read(allocate);
        }
        catch (IOException ex) {
            Logger.getLogger(LInChannel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return allocate.array();
    }

    @Override
    public byte[] extractUntil(int delimiter) {
        int counter = 1;
        while (!this.isDone().booleanValue()) {
            if (this.read() != delimiter) {
                ++counter;
                continue;
            }
            this.jumpBack(counter);
            byte[] out = this.extract(counter - 1);
            this.skip(1);
            return out;
        }
        return new byte[0];
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.iChannel.transferTo(position, count, target);
    }
}

