Scriptname BB_EquipmentRestriction_PlLvLCheck extends ReferenceAlias

;---PROPERTIES---
Keyword Property ArmorHeavy Auto
Keyword Property ArmorLight Auto
Keyword Property ArmorShield Auto
Keyword Property ArmorMaterialBearStormcloak Auto
Keyword Property ArmorMaterialBlades Auto
Keyword Property ArmorMaterialDaedric Auto
Keyword Property ArmorMaterialDragonplate Auto
Keyword Property ArmorMaterialDragonscale Auto
Keyword Property ArmorMaterialDwarven Auto
Keyword Property ArmorMaterialEbony Auto
Keyword Property ArmorMaterialElven Auto
Keyword Property ArmorMaterialElvenGilded Auto
Keyword Property ArmorMaterialFalmer Auto
Keyword Property ArmorMaterialForsworn Auto
Keyword Property ArmorMaterialMS02Forsworn Auto
Keyword Property ArmorMaterialGlass Auto
Keyword Property ArmorMaterialHide Auto
Keyword Property ArmorMaterialImperialLight Auto
Keyword Property ArmorMaterialImperialHeavy Auto
Keyword Property ArmorMaterialImperialStudded Auto
Keyword Property ArmorMaterialIron Auto
Keyword Property ArmorMaterialIronBanded Auto
Keyword Property ArmorMaterialLeather Auto
Keyword Property ArmorMaterialOrcish Auto
Keyword Property ArmorMaterialPenitus Auto
Keyword Property ArmorMaterialScaled Auto
Keyword Property ArmorMaterialSteel Auto
Keyword Property ArmorMaterialSteelPlate Auto
Keyword Property ArmorMaterialStormcloak Auto
Keyword Property ArmorMaterialStudded Auto
Keyword Property ArmorMaterialThievesGuild Auto
Keyword Property ArmorMaterialThievesGuildMaster Auto
Keyword Property DLC1ArmorMaterialDawnguard Auto
Keyword Property DLC1ArmorMaterialFalmerHardened Auto
Keyword Property DLC1LD_CraftingMaterialAetherium Auto
Keyword Property DLC1WeapMaterialDragonbone Auto
Keyword Property DLC2ArmorMaterialBonemoldHeavy Auto
Keyword Property DLC2ArmorMaterialBonemoldLight Auto
Keyword Property DLC2ArmorMaterialChitinHeavy Auto
Keyword Property DLC2ArmorMaterialChitinLight Auto
Keyword Property DLC2ArmorMaterialMoragTong Auto
Keyword Property DLC2ArmorMaterialNordicHeavy Auto
Keyword Property DLC2ArmorMaterialNordicBonemoldLight Auto
Keyword Property DLC2ArmorMaterialStalhrimHeavy Auto
Keyword Property DLC2ArmorMaterialStalhrimLight Auto
Keyword Property DLC2WeaponMaterialNordic Auto
Keyword Property DLC2WeaponMaterialStalhrim Auto
Keyword Property WeapMaterialDaedric Auto
Keyword Property WeapMaterialDwarven Auto
Keyword Property WeapMaterialDraugr Auto
Keyword Property WeapMaterialDraugrHoned Auto
Keyword Property WeapMaterialEbony Auto
Keyword Property WeapMaterialElven Auto
Keyword Property WeapMaterialFalmer Auto
Keyword Property WeapMaterialFalmerHoned Auto
Keyword Property WeapMaterialForsworn Auto
Keyword Property WeapMaterialGlass Auto
Keyword Property WeapMaterialImperial Auto
Keyword Property WeapMaterialIron Auto
Keyword Property WeapMaterialOrcish Auto
Keyword Property WeapMaterialSilver Auto
Keyword Property WeapMaterialSteel Auto
Keyword Property WeapMaterialWood Auto
Keyword Property WeapTypeBattleaxe Auto
Keyword Property WeapTypeBow Auto
Keyword Property WeapTypeCrossbow Auto
Keyword Property WeapTypeDagger Auto
Keyword Property WeapTypeGreatsword Auto
Keyword Property WeapTypeMace Auto
Keyword Property WeapTypeSword Auto
Keyword Property WeapTypeWaraxe Auto
Keyword Property WeapTypeWarhammer Auto

GlobalVariable Property AetheriumLevel Auto
GlobalVariable Property BonemoldLevel Auto
GlobalVariable Property BoundLevel Auto
GlobalVariable Property ChitinLevel Auto
GlobalVariable Property DaedricLevel Auto
GlobalVariable Property DragonLevel Auto
GlobalVariable Property DraugrLevel Auto
GlobalVariable Property DwarvenLevel Auto
GlobalVariable Property EbonyLevel Auto
GlobalVariable Property ElvenLevel Auto
GlobalVariable Property FalmerLevel Auto
GlobalVariable Property GlassLevel Auto
GlobalVariable Property HideLevel Auto
GlobalVariable Property ImperialLevel Auto
GlobalVariable Property IronLevel Auto
GlobalVariable Property LeatherLevel Auto
GlobalVariable Property NordicLevel Auto
GlobalVariable Property OrcishLevel Auto
GlobalVariable Property SilverLevel Auto
GlobalVariable Property StalhrimLevel Auto
GlobalVariable Property SteelLevel Auto
GlobalVariable Property StuddedLevel Auto
GlobalVariable Property WoodLevel Auto

GlobalVariable Property EquipmentAffected_HeavyArmor Auto
GlobalVariable Property EquipmentAffected_LightArmor Auto
GlobalVariable Property EquipmentAffected_Bow Auto
GlobalVariable Property EquipmentAffected_OneHanded Auto
GlobalVariable Property EquipmentAffected_TwoHanded Auto
GlobalVariable Property EquipmentAffected_Blocking Auto

Weapon Property AllowedBladeOfSacrifice Auto
Weapon Property AllowedNettlebane Auto
Weapon Property AllowedRustyMace Auto

Weapon Property DummyWeaponL Auto
Weapon Property DummyWeaponR Auto
Weapon Property DummyWeapon2H Auto

Formlist Property BoundWeaponList Auto

;---VARIABLES---
;int LevelRequired

;---EVENT---
Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)

int LevelRequired = 0
Actor Player = Game.GetPlayer()

   if akBaseObject as Weapon

      if akBaseObject.HasKeyword(WeapMaterialDaedric)
         if LevelRequired < (DaedricLevel.GetValue() as int)
            LevelRequired = (DaedricLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC1WeapMaterialDragonbone)
         if LevelRequired < (DragonLevel.GetValue() as int)
            LevelRequired = (DragonLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialDwarven)
         if LevelRequired < (DwarvenLevel.GetValue() as int)
            LevelRequired = (DwarvenLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialDraugr) || akBaseObject.HasKeyword(WeapMaterialDraugrHoned)
         if LevelRequired < (DraugrLevel.GetValue() as int)
            LevelRequired = (DraugrLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialEbony)
         if LevelRequired < (EbonyLevel.GetValue() as int)
            LevelRequired = (EbonyLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialElven)
         if LevelRequired < (ElvenLevel.GetValue() as int)
            LevelRequired = (ElvenLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialFalmer) || akBaseObject.HasKeyword(WeapMaterialFalmerHoned)
         if LevelRequired < (FalmerLevel.GetValue() as int)
            LevelRequired = (FalmerLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialGlass)
         if LevelRequired < (GlassLevel.GetValue() as int)
            LevelRequired = (GlassLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialImperial)
         if LevelRequired < (ImperialLevel.GetValue() as int)
            LevelRequired = (ImperialLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialIron)
         if LevelRequired < (IronLevel.GetValue() as int)
            LevelRequired = (IronLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialOrcish)
         if LevelRequired < (OrcishLevel.GetValue() as int)
            LevelRequired = (OrcishLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialSilver)
         if LevelRequired < (SilverLevel.GetValue() as int)
            LevelRequired = (SilverLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialSteel)
         if LevelRequired < (SteelLevel.GetValue() as int)
            LevelRequired = (SteelLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(WeapMaterialWood)
         if LevelRequired < (WoodLevel.GetValue() as int)
            LevelRequired = (WoodLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC1LD_CraftingMaterialAetherium)
         if LevelRequired < (AetheriumLevel.GetValue() as int)
            LevelRequired = (AetheriumLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC2WeaponMaterialNordic)
         if LevelRequired < (NordicLevel.GetValue() as int)
            LevelRequired = (NordicLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC2WeaponMaterialStalhrim)
         if LevelRequired < (StalhrimLevel.GetValue() as int)
            LevelRequired = (StalhrimLevel.GetValue() as int)
         endif
      endif

      if BoundWeaponList.HasForm(akBaseObject)
         ;if LevelRequired < (BoundLevel.GetValue() as int)
            LevelRequired = (BoundLevel.GetValue() as int)
         ;endif
      endif

   elseif akBaseObject as Armor

      if akBaseObject.HasKeyword(DLC1LD_CraftingMaterialAetherium)
         if LevelRequired < (AetheriumLevel.GetValue() as int)
            LevelRequired = (AetheriumLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialDaedric)
         if LevelRequired < (DaedricLevel.GetValue() as int)
            LevelRequired = (DaedricLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialDragonplate) || akBaseObject.HasKeyword(ArmorMaterialDragonscale)
         if LevelRequired < (DragonLevel.GetValue() as int)
            LevelRequired = (DragonLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialDwarven)
         if LevelRequired < (DwarvenLevel.GetValue() as int)
            LevelRequired = (DwarvenLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialEbony)
         if LevelRequired < (EbonyLevel.GetValue() as int)
            LevelRequired = (EbonyLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialElven) || akBaseObject.HasKeyword(ArmorMaterialElvenGilded)
         if LevelRequired < (ElvenLevel.GetValue() as int)
            LevelRequired = (ElvenLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialFalmer) || akBaseObject.HasKeyword(DLC1ArmorMaterialFalmerHardened)
         if LevelRequired < (FalmerLevel.GetValue() as int)
            LevelRequired = (FalmerLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialGlass)
         if LevelRequired < (GlassLevel.GetValue() as int)
            LevelRequired = (GlassLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialHide) || akBaseObject.HasKeyword(ArmorMaterialForsworn) || akBaseObject.HasKeyword(ArmorMaterialMS02Forsworn)
         if LevelRequired < (HideLevel.GetValue() as int)
            LevelRequired = (HideLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialImperialLight) || akBaseObject.HasKeyword(ArmorMaterialImperialHeavy) || akBaseObject.HasKeyword(ArmorMaterialImperialStudded) || akBaseObject.HasKeyword(ArmorMaterialStormcloak) || akBaseObject.HasKeyword(ArmorMaterialBearStormcloak)
         if LevelRequired < (ImperialLevel.GetValue() as int)
            LevelRequired = (ImperialLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialIron) || akBaseObject.HasKeyword(ArmorMaterialIronBanded)
         if LevelRequired < (IronLevel.GetValue() as int)
            LevelRequired = (IronLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialLeather) || akBaseObject.HasKeyword(ArmorMaterialThievesGuild) || akBaseObject.HasKeyword(ArmorMaterialThievesGuildMaster)
         if LevelRequired < (LeatherLevel.GetValue() as int)
            LevelRequired = (LeatherLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialOrcish)
         if LevelRequired < (OrcishLevel.GetValue() as int)
            LevelRequired = (OrcishLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialScaled) || akBaseObject.HasKeyword(ArmorMaterialSteel) || akBaseObject.HasKeyword(ArmorMaterialSteelPlate) || akBaseObject.HasKeyword(ArmorMaterialBlades) || akBaseObject.HasKeyword(ArmorMaterialPenitus) || akBaseObject.HasKeyword(DLC1ArmorMaterialDawnguard)
         if LevelRequired < (SteelLevel.GetValue() as int)
            LevelRequired = (SteelLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(ArmorMaterialStudded)
         if LevelRequired < (StuddedLevel.GetValue() as int)
            LevelRequired = (StuddedLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC2ArmorMaterialBonemoldHeavy) || akBaseObject.HasKeyword(DLC2ArmorMaterialBonemoldLight)
         if LevelRequired < (BonemoldLevel.GetValue() as int)
            LevelRequired = (BonemoldLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC2ArmorMaterialChitinHeavy) || akBaseObject.HasKeyword(DLC2ArmorMaterialChitinLight) || akBaseObject.HasKeyword(DLC2ArmorMaterialMoragTong)
         if LevelRequired < (ChitinLevel.GetValue() as int)
            LevelRequired = (ChitinLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC2ArmorMaterialNordicHeavy) || akBaseObject.HasKeyword(DLC2ArmorMaterialNordicBonemoldLight)
         if LevelRequired < (NordicLevel.GetValue() as int)
            LevelRequired = (NordicLevel.GetValue() as int)
         endif
      endif

      if akBaseObject.HasKeyword(DLC2ArmorMaterialStalhrimHeavy) || akBaseObject.HasKeyword(DLC2ArmorMaterialStalhrimLight)
         if LevelRequired < (StalhrimLevel.GetValue() as int)
            LevelRequired = (StalhrimLevel.GetValue() as int)
         endif
      endif

   endif

   if akBaseobject as Weapon
      if (EquipmentAffected_OneHanded.GetValue() as int == 1) && (akBaseobject.HasKeyword(WeapTypeDagger) || akBaseObject.HasKeyword(WeapTypeMace) || akBaseObject.HasKeyword(WeapTypeSword) ||  akBaseObject.HasKeyword(WeapTypeWaraxe)); && (akBaseObject as Weapon != AllowedBladeOfSacrifice) && (akBaseObject as Weapon != AllowedNettlebane) && (akBaseObject as Weapon != AllowedRustyMace)
	     if (akBaseobject.HasKeyword(WeapTypeDagger) && Player.GetAV("Sneak") >= LevelRequired)
            ; do nothing
         elseif (akBaseobject.HasKeyword(WeapTypeDagger)) && Player.GetAV("OneHanded") < LevelRequired && Player.GetAV("Sneak") < LevelRequired
	        if Player.GetEquippedWeapon(true) == (akBaseObject as Weapon)
               ;UnequipLeftWeaponWithDummy(Player)
            else
               ;UnequipWeaponWithDummy(Player)
            endif
            Debug.Notification("$You lack the required skill to effectively wield this weapon.")

         elseif !(akBaseobject.HasKeyword(WeapTypeDagger)) && Player.GetAV("OneHanded") < LevelRequired
            if Player.GetEquippedWeapon(true) == (akBaseObject as Weapon)
               ;UnequipLeftWeaponWithDummy(Player)
            else
               ;UnequipWeaponWithDummy(Player)
            endif
            Debug.Notification("$You lack the required skill to effectively wield this weapon.")
         endif

      elseif (EquipmentAffected_TwoHanded.GetValue() as int == 1) && (akBaseobject.HasKeyword(WeapTypeBattleaxe) || akBaseObject.HasKeyword(WeapTypeGreatsword) || akBaseObject.HasKeyword (WeapTypeWarhammer))
         if Player.GetAV("TwoHanded") < LevelRequired
            ;UnequipWeaponWithDummy(Player)
            Debug.Notification("$You lack the required skill to effectively wield this weapon.")
         endif

      elseif (EquipmentAffected_Bow.GetValue() as int == 1) && (akBaseobject.HasKeyword(WeapTypeBow) || akBaseObject.HasKeyword(WeapTypeCrossbow))
         if Player.GetAV("Marksman") < LevelRequired
            ;UnequipWeaponWithDummy(Player)
            Debug.Notification("$You lack the required skill to effectively wield this weapon.")
         endif

      endif

   elseif akBaseObject as Armor
      if (EquipmentAffected_HeavyArmor.GetValue() as int == 1) && (akBaseObject.HasKeyword(ArmorHeavy)) && (akBaseObject.HasKeyword(ArmorShield) == false)
         if Player.GetAV("HeavyArmor") < LevelRequired
            ;Player.UnequipItem(akBaseObject, false, true)
            Debug.Notification("$You lack the required skill to effectively wear this equipment.")
         endif

      elseif (EquipmentAffected_LightArmor.GetValue() as int == 1) && (akBaseObject.HasKeyword(ArmorLight)) && (akBaseObject.HasKeyword(ArmorShield) == false)
         if Player.GetAV("LightArmor") < LevelRequired
            ;Player.UnequipItem(akBaseObject, false, true)
            Debug.Notification("$You lack the required skill to effectively wear this equipment.")
         endif

      elseif (EquipmentAffected_Blocking.GetValue() as int == 1) && (akBaseObject.HasKeyword(ArmorShield))
         if Player.GetAV("Block") < LevelRequired
            ;Player.UnequipItem(akBaseObject, false, true)
            ;Debug.Notification("$You lack the required skill to effectively block with this equipment.")
         endif

      endif

   endif

   if (EquipmentAffected_Blocking.GetValue() as int == 1) && ((akBaseObject as Weapon) || (akBaseObject.HasKeyword(ArmorShield)))
      if (GetOwningQuest() as BB_EquipmentRestriction_BlockCheck).CheckBlocking(Player) == 1
         Debug.Notification("$You lack the required skill to effectively block with this equipment.")
      endif
   endif

endEvent

Event OnCellLoad()
   if (EquipmentAffected_Blocking.GetValue() as int == 1)
      (GetOwningQuest() as BB_EquipmentRestriction_BlockCheck).CheckBlocking(Game.GetPlayer())
   endif
endEvent

Event OnMenuClose(string MenuName)
   if (EquipmentAffected_Blocking.GetValue() as int == 1)
      Debug.Notification("OnMenuClose triggered.")
      (GetOwningQuest() as BB_EquipmentRestriction_BlockCheck).CheckBlocking(Game.GetPlayer()) == 1
   endif
endEvent

;---FUNCTIONS---

;Function CheckBlocking(Actor akActor)
;   CantBlockEffectively = 0
;   int CheckBlocking_LevelRequired = 0
;   Form LeftObject = akActor.GetEquippedObject(0)
;   if !LeftObject
;      CheckBlockingRight(Game.GetPlayer())
;   elseif LeftObject as Weapon
;      ;do nothing
;   elseif LeftObject as Armor
;      if LeftObject.HasKeyword(DLC1LD_CraftingMaterialAetherium)
;         if CheckBlocking_LevelRequired < (AetheriumLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (AetheriumLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialDaedric)
;         if CheckBlocking_LevelRequired < (DaedricLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (DaedricLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialDragonplate) || LeftObject.HasKeyword(ArmorMaterialDragonscale)
;         if CheckBlocking_LevelRequired < (DragonLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (DragonLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialDwarven)
;         if CheckBlocking_LevelRequired < (DwarvenLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (DwarvenLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialEbony)
;         if CheckBlocking_LevelRequired < (EbonyLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (EbonyLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialElven) || LeftObject.HasKeyword(ArmorMaterialElvenGilded)
;         if CheckBlocking_LevelRequired < (ElvenLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (ElvenLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialFalmer)
;         if CheckBlocking_LevelRequired < (FalmerLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (FalmerLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialGlass)
;         if CheckBlocking_LevelRequired < (GlassLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (GlassLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialHide) || LeftObject.HasKeyword(ArmorMaterialForsworn) || LeftObject.HasKeyword(ArmorMaterialMS02Forsworn)
;         if CheckBlocking_LevelRequired < (HideLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (HideLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialImperialLight) || LeftObject.HasKeyword(ArmorMaterialImperialHeavy) || LeftObject.HasKeyword(ArmorMaterialImperialStudded) || LeftObject.HasKeyword(ArmorMaterialStormcloak)
;         if CheckBlocking_LevelRequired < (ImperialLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (ImperialLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialIron) || LeftObject.HasKeyword(ArmorMaterialIronBanded)
;         if CheckBlocking_LevelRequired < (IronLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (IronLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialLeather) || LeftObject.HasKeyword(ArmorMaterialThievesGuild) || LeftObject.HasKeyword(ArmorMaterialThievesGuildMaster)
;         if CheckBlocking_LevelRequired < (LeatherLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (LeatherLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialOrcish)
;         if CheckBlocking_LevelRequired < (OrcishLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (OrcishLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialScaled) || LeftObject.HasKeyword(ArmorMaterialSteel) || LeftObject.HasKeyword(ArmorMaterialSteelPlate) || LeftObject.HasKeyword(ArmorMaterialBlades) || LeftObject.HasKeyword(ArmorMaterialPenitus)
;         if CheckBlocking_LevelRequired < (SteelLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (SteelLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(ArmorMaterialStudded)
;         if CheckBlocking_LevelRequired < (StuddedLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (StuddedLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(DLC2ArmorMaterialBonemoldHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialBonemoldLight)
;         if CheckBlocking_LevelRequired < (BonemoldLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (BonemoldLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(DLC2ArmorMaterialChitinHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialChitinLight) || LeftObject.HasKeyword(DLC2ArmorMaterialMoragTong)
;         if CheckBlocking_LevelRequired < (ChitinLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (ChitinLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(DLC2ArmorMaterialNordicHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialNordicBonemoldLight)
;         if CheckBlocking_LevelRequired < (NordicLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (NordicLevel.GetValue() as int)
;         endif
;      endif

;      if LeftObject.HasKeyword(DLC2ArmorMaterialStalhrimHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialStalhrimLight)
;         if CheckBlocking_LevelRequired < (StalhrimLevel.GetValue() as int)
;            CheckBlocking_LevelRequired = (StalhrimLevel.GetValue() as int)
;         endif
;      endif
;   endif

;   if Game.GetPlayer().GetAV("Block") < CheckBlocking_LevelRequired
;      CantBlockEffectively = 1
;      Debug.Notification("$You lack the required skill to effectively block with this equipment.")
;   endif

;endFunction

;Function CheckBlockingRight(Actor akActor)
;   Form RightObject = akActor.GetEquippedObject(1)
;   int CheckBlockingRight_LevelRequired = 0
;   if RightObject as Weapon
;      if RightObject.HasKeyword(WeapMaterialDaedric)
;         if CheckBlockingRight_LevelRequired < (DaedricLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (DaedricLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(DLC1WeapMaterialDragonbone)
;         if CheckBlockingRight_LevelRequired < (DragonLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (DragonLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialDwarven)
;         if CheckBlockingRight_LevelRequired < (DwarvenLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (DwarvenLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialDraugr) || RightObject.HasKeyword(WeapMaterialDraugrHoned)
;         if CheckBlockingRight_LevelRequired < (DraugrLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (DraugrLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialEbony)
;         if CheckBlockingRight_LevelRequired < (EbonyLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (EbonyLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialElven)
;         if CheckBlockingRight_LevelRequired < (ElvenLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (ElvenLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialFalmer) || RightObject.HasKeyword(WeapMaterialFalmerHoned)
;         if CheckBlockingRight_LevelRequired < (FalmerLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (FalmerLevel.GetValue() as int)
;        endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialGlass)
;         if CheckBlockingRight_LevelRequired < (GlassLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (GlassLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialImperial)
;         if CheckBlockingRight_LevelRequired < (ImperialLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (ImperialLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialIron)
;         if CheckBlockingRight_LevelRequired < (IronLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (IronLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialOrcish)
;         if CheckBlockingRight_LevelRequired < (OrcishLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (OrcishLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialSilver)
;         if CheckBlockingRight_LevelRequired < (SilverLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (SilverLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialSteel)
;         if CheckBlockingRight_LevelRequired < (SteelLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (SteelLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(WeapMaterialWood)
;         if CheckBlockingRight_LevelRequired < (WoodLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (WoodLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(DLC1LD_CraftingMaterialAetherium)
;         if CheckBlockingRight_LevelRequired < (AetheriumLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (AetheriumLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(DLC2WeaponMaterialNordic)
;         if CheckBlockingRight_LevelRequired < (NordicLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (NordicLevel.GetValue() as int)
;         endif
;      endif

;      if RightObject.HasKeyword(DLC2WeaponMaterialStalhrim)
;         if CheckBlockingRight_LevelRequired < (StalhrimLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (StalhrimLevel.GetValue() as int)
;         endif
;      endif

;      if BoundWeaponList.HasForm(RightObject)
;         if CheckBlockingRight_LevelRequired < (BoundLevel.GetValue() as int)
;            CheckBlockingRight_LevelRequired = (BoundLevel.GetValue() as int)
;         endif
;      endif
;   endif

;   if Game.GetPlayer().GetAV("Block") < CheckBlockingRight_LevelRequired
;      CantBlockEffectively = 1
;      Debug.Notification("$You lack the required skill to effectively block with this equipment.")
;   endif
;endFunction

;Function UnequipWeaponWithDummy(Actor akActor) ;thanks to Chesko for function that avoids enchantment charge bug
;   akActor.AddItem(DummyWeaponR, abSilent = true)
;   akActor.EquipItem(DummyWeaponR, abSilent = true)
;   akActor.UnEquipItem(DummyWeaponR, abSilent = true)
;   akActor.RemoveItem(DummyWeaponR, abSilent = true)
;endFunction

;Function UnequipLeftWeaponWithDummy(Actor akActor)
;   akActor.AddItem(DummyWeaponL, abSilent = true)
;   akActor.EquipItemEx(DummyWeaponL, 2, false, true)
;   akActor.UnEquipItem(DummyWeaponL, abSilent = true)
;   akActor.RemoveItem(DummyWeaponL, abSilent = true)
;endFunction