Scriptname BB_EquipmentRestriction_MCMScript extends SKI_ConfigBase

GlobalVariable Property EquipmentAffected_HeavyArmor Auto
GlobalVariable Property EquipmentAffected_LightArmor Auto
GlobalVariable Property EquipmentAffected_Bow Auto
GlobalVariable Property EquipmentAffected_OneHanded Auto
GlobalVariable Property EquipmentAffected_TwoHanded Auto
GlobalVariable Property EquipmentAffected_Magic Auto
GlobalVariable Property EquipmentAffected_Blocking Auto
GlobalVariable Property EquipmentAffected_zOptionalWeakAttackPerk Auto
GlobalVariable Property EquipmentAffected_zOptionalDisarmChance Auto
GlobalVariable Property AetheriumLevel Auto
GlobalVariable Property BonemoldLevel Auto
GlobalVariable Property BoundLevel Auto
GlobalVariable Property ChitinLevel Auto
GlobalVariable Property DaedricLevel Auto
GlobalVariable Property DragonLevel Auto
GlobalVariable Property DraugrLevel Auto
GlobalVariable Property DwarvenLevel Auto
GlobalVariable Property EbonyLevel Auto
GlobalVariable Property ElvenLevel Auto
GlobalVariable Property FalmerLevel Auto
GlobalVariable Property GlassLevel Auto
GlobalVariable Property HideLevel Auto
GlobalVariable Property ImperialLevel Auto
GlobalVariable Property IronLevel Auto
GlobalVariable Property LeatherLevel Auto
GlobalVariable Property NordicLevel Auto
GlobalVariable Property OrcishLevel Auto
GlobalVariable Property SilverLevel Auto
GlobalVariable Property StalhrimLevel Auto
GlobalVariable Property SteelLevel Auto
GlobalVariable Property StuddedLevel Auto
GlobalVariable Property WoodLevel Auto
GlobalVariable Property MagicNoviceLevel Auto
GlobalVariable Property MagicApprenticeLevel Auto
GlobalVariable Property MagicAdeptLevel Auto
GlobalVariable Property MagicExpertLevel Auto
GlobalVariable Property MagicMasterLevel Auto

Perk Property ModPerk1 Auto
Perk Property ModPerk2 Auto
Perk Property ModPerk3 Auto
Perk Property ModPerk4 Auto
Perk Property ModPerk5 Auto
Perk Property ModPerk6 Auto
Perk Property ModPerk7 Auto
Perk Property ModPerk8 Auto
Perk Property ModPerk9 Auto
Perk Property ModPerk10 Auto
Perk Property ModPerk11 Auto
Perk Property ModPerk12 Auto
Perk Property ModPerk99 Auto

int HeavyArmorAllowedOption
int LightArmorAllowedOption
int BowAllowedOption
int OneHandedAllowedOption
int TwoHandedAllowedOption
int MagicAllowedOption
int BlockingAllowedOption
int OptionalWeakAttackPerkOption
int OptionalDisarmChanceOption

bool HeavyArmorAllowedOptionbool = false
bool LightArmorAllowedOptionbool = false
bool BowAllowedOptionbool = false
bool OneHandedAllowedOptionbool = false
bool TwoHandedAllowedOptionbool = false
bool MagicAllowedOptionbool = false
bool BlockingAllowedOptionbool = false
bool OptionalWeakAttackPerkOptionbool = false

int AetheriumLevelOption
int BonemoldLevelOption
int BoundLevelOption
int ChitinLevelOption
int DaedricLevelOption
int DragonLevelOption
int DraugrLevelOption
int DwarvenLevelOption
int EbonyLevelOption
int ElvenLevelOption
int FalmerLevelOption
int GlassLevelOption
int HideLevelOption
int ImperialLevelOption
int IronLevelOption
int LeatherLevelOption
int NordicLevelOption
int OrcishLevelOption
int SilverLevelOption
int StalhrimLevelOption
int SteelLevelOption
int StuddedLevelOption
int WoodLevelOption
int MagicNoviceLevelOption
int MagicApprenticeLevelOption
int MagicAdeptLevelOption
int MagicExpertLevelOption
int MagicMasterLevelOption

int UninstallOption

int Function GetVersion()
	return 26700
endFunction

Event OnVersionUpdate(int a_version)
	if (a_version >= 26700 && CurrentVersion < 26700)
		Debug.Trace(self + ": Updating script to version 26700")
		Actor Player = Game.GetPlayer()
		if Player.HasPerk(ModPerk1) == false
			Player.AddPerk(ModPerk1)
		endif
		if Player.HasPerk(ModPerk2) == false
			Player.AddPerk(ModPerk2)
		endif
		if Player.HasPerk(ModPerk3) == false
			Player.AddPerk(ModPerk3)
		endif
		if Player.HasPerk(ModPerk4) == false
			Player.AddPerk(ModPerk4)
		endif
		if Player.HasPerk(ModPerk5) == false
			Player.AddPerk(ModPerk5)
		endif
		if Player.HasPerk(ModPerk6) == false
			Player.AddPerk(ModPerk6)
		endif
		if Player.HasPerk(ModPerk7) == false
			Player.AddPerk(ModPerk7)
		endif
		if Player.HasPerk(ModPerk8) == false
			Player.AddPerk(ModPerk8)
		endif
		if Player.HasPerk(ModPerk9) == false
			Player.AddPerk(ModPerk9)
		endif
		if Player.HasPerk(ModPerk10) == false
			Player.AddPerk(ModPerk10)
		endif
		if Player.HasPerk(ModPerk11) == false
			Player.AddPerk(ModPerk11)
		endif
		if Player.HasPerk(ModPerk12) == false
			Player.AddPerk(ModPerk12)
		endif
		if Player.HasPerk(ModPerk99) == false
			Player.AddPerk(ModPerk99)
		endif
	endif
endEvent

Event OnPageReset(string page)
	if (page == "$General Options")
		if EquipmentAffected_HeavyArmor.GetValue() as int == 1
			HeavyArmorAllowedOptionbool = true
		else
			HeavyArmorAllowedOptionbool = false
		endif
		if EquipmentAffected_LightArmor.GetValue() as int == 1
			LightArmorAllowedOptionbool = true
		else
			LightArmorAllowedOptionbool = false
		endif
		if EquipmentAffected_Bow.GetValue() as int == 1
			BowAllowedOptionbool = true
		else
			BowAllowedOptionbool = false
		endif
		if EquipmentAffected_OneHanded.GetValue() as int == 1
			OneHandedAllowedOptionbool = true
		else
			OneHandedAllowedOptionbool = false
		endif
		if EquipmentAffected_TwoHanded.GetValue() as int == 1
			TwoHandedAllowedOptionbool = true
		else
			TwoHandedAllowedOptionbool = false
		endif
		if EquipmentAffected_Magic.GetValue() as int == 1
			MagicAllowedOptionbool = true
		else
			MagicAllowedOptionbool = false
		endif
		if EquipmentAffected_Blocking.GetValue() as int == 1
			BlockingAllowedOptionbool = true
		else
			BlockingAllowedOptionbool = false
		endif
		if EquipmentAffected_zOptionalWeakAttackPerk.GetValue() as int == 1
			OptionalWeakAttackPerkOptionbool = true
		else
			OptionalWeakAttackPerkOptionbool = false
		endif

		SetCursorFillMode(LEFT_TO_RIGHT)

		AddHeaderOption("$Apply Level Restrictions To...")
		AddEmptyOption()
		HeavyArmorAllowedOption = AddToggleOption("$Heavy Armor", HeavyArmorAllowedOptionbool)
		LightArmorAllowedOption = AddToggleOption("$Light Armor", LightArmorAllowedOptionbool)
		BowAllowedOption = AddToggleOption("$Archery Weapons", BowAllowedOptionbool)
		OneHandedAllowedOption = AddToggleOption("$One-Handed Weapons", OneHandedAllowedOptionbool)
		TwoHandedAllowedOption = AddToggleOption("$Two-Handed Weapons", TwoHandedAllowedOptionbool)
		MagicAllowedOption = AddToggleOption("$Magic", MagicAllowedOptionbool)
		BlockingAllowedOption = AddToggleOption("$Blocking Items", BlockingAllowedOptionbool)
		AddEmptyOption()

		AddEmptyOption()
		AddEmptyOption()

		AddHeaderOption("$Additional Options")
		AddEmptyOption()
		OptionalWeakAttackPerkOption = AddToggleOption("$Attacks with 0 Stamina fail", OptionalWeakAttackPerkOptionbool)
		OptionalDisarmChanceOption = AddSliderOption("$Disarm Chance from failed attack", EquipmentAffected_zOptionalDisarmChance.GetValue(), "{0}%")

		AddEmptyOption()
		AddEmptyOption()

		AddHeaderOption("$Uninstallation")
		AddEmptyOption()
		UninstallOption = AddToggleOption("$Uninstall", false)

	elseif (page == "$Set Levels")
		SetCursorFillMode(LEFT_TO_RIGHT)

		AetheriumLevelOption = AddSliderOption("$Aetherium", AetheriumLevel.GetValue())
		BonemoldLevelOption = AddSliderOption("$Bonemold", BonemoldLevel.GetValue())
		BoundLevelOption = AddSliderOption("$Bound Weapons", BoundLevel.GetValue())
		ChitinLevelOption = AddSliderOption("$Chitin", ChitinLevel.GetValue())
		DaedricLevelOption = AddSliderOption("$Daedric", DaedricLevel.GetValue())
		DragonLevelOption = AddSliderOption("$Dragon", DragonLevel.GetValue())
		DraugrLevelOption = AddSliderOption("$Draugr", DraugrLevel.GetValue())
		DwarvenLevelOption = AddSliderOption("$Dwarven", DwarvenLevel.GetValue())
		EbonyLevelOption = AddSliderOption("$Ebony", EbonyLevel.GetValue())
		ElvenLevelOption = AddSliderOption("$Elven", ElvenLevel.GetValue())
		FalmerLevelOption = AddSliderOption("$Falmer", FalmerLevel.GetValue())
		GlassLevelOption = AddSliderOption("$Glass", GlassLevel.GetValue())
		HideLevelOption = AddSliderOption("$Hide", HideLevel.GetValue())
		ImperialLevelOption = AddSliderOption("$Imperial and Stormcloak", ImperialLevel.GetValue())
		IronLevelOption = AddSliderOption("$Iron", IronLevel.GetValue())
		LeatherLevelOption = AddSliderOption("$Leather", LeatherLevel.GetValue())
		NordicLevelOption = AddSliderOption("$Nordic", NordicLevel.GetValue())
		OrcishLevelOption = AddSliderOption("$Orcish", OrcishLevel.GetValue())
		SilverLevelOption = AddSliderOption("$Silver", SilverLevel.GetValue())
		StalhrimLevelOption = AddSliderOption("$Stalhrim", StalhrimLevel.GetValue())
		SteelLevelOption = AddSliderOption("$Steel", SteelLevel.GetValue())
		StuddedLevelOption = AddSliderOption("$Studded", StuddedLevel.GetValue())
		WoodLevelOption = AddSliderOption("$Wood", WoodLevel.GetValue())
		MagicNoviceLevelOption = AddSliderOption("$Novice Magic", MagicNoviceLevel.GetValue())
		MagicApprenticeLevelOption = AddSliderOption("$Apprentice Magic", MagicApprenticeLevel.GetValue())
		MagicAdeptLevelOption = AddSliderOption("$Adept Magic", MagicAdeptLevel.GetValue())
		MagicExpertLevelOption = AddSliderOption("$Expert Magic", MagicExpertLevel.GetValue())
		MagicMasterLevelOption = AddSliderOption("$Master Magic", MagicMasterLevel.GetValue())

	endif
endEvent

Event OnOptionSelect(int option)
	if option == HeavyArmorAllowedOption
		HeavyArmorAllowedOptionbool = !HeavyArmorAllowedOptionbool
		SetToggleOptionValue(HeavyArmorAllowedOption, HeavyArmorAllowedOptionbool)
		if EquipmentAffected_HeavyArmor.GetValue() as int == 1
			EquipmentAffected_HeavyArmor.SetValue(0)
		else
			EquipmentAffected_HeavyArmor.SetValue(1)
		endif

	elseif option == LightArmorAllowedOption
		LightArmorAllowedOptionbool = !LightArmorAllowedOptionbool
		SetToggleOptionValue(LightArmorAllowedOption, LightArmorAllowedOptionbool)
		if EquipmentAffected_LightArmor.GetValue() as int == 1
			EquipmentAffected_LightArmor.SetValue(0)
		else
			EquipmentAffected_LightArmor.SetValue(1)
		endif

	elseif option == BowAllowedOption
		BowAllowedOptionbool = !BowAllowedOptionbool
		SetToggleOptionValue(BowAllowedOption, BowAllowedOptionbool)
		if EquipmentAffected_Bow.GetValue() as int == 1
			EquipmentAffected_Bow.SetValue(0)
		else
			EquipmentAffected_Bow.SetValue(1)
		endif

	elseif option == OneHandedAllowedOption
		OneHandedAllowedOptionbool = !OneHandedAllowedOptionbool
		SetToggleOptionValue(OneHandedAllowedOption, OneHandedAllowedOptionbool)
		if EquipmentAffected_OneHanded.GetValue() as int == 1
			EquipmentAffected_OneHanded.SetValue(0)
		else
			EquipmentAffected_OneHanded.SetValue(1)
		endif

	elseif option == TwoHandedAllowedOption
		TwoHandedAllowedOptionbool = !TwoHandedAllowedOptionbool
		SetToggleOptionValue(TwoHandedAllowedOption, TwoHandedAllowedOptionbool)
		if EquipmentAffected_TwoHanded.GetValue() as int == 1
			EquipmentAffected_TwoHanded.SetValue(0)
		else
			EquipmentAffected_TwoHanded.SetValue(1)
		endif

	elseif option == MagicAllowedOption
		MagicAllowedOptionbool = !MagicAllowedOptionbool
		SetToggleOptionValue(MagicAllowedOption, MagicAllowedOptionbool)
		if EquipmentAffected_Magic.GetValue() as int == 1
			EquipmentAffected_Magic.SetValue(0)
		else
			EquipmentAffected_Magic.SetValue(1)
		endif

	elseif option == BlockingAllowedOption
		BlockingAllowedOptionbool = !BlockingAllowedOptionbool
		SetToggleOptionValue(BlockingAllowedOption, BlockingAllowedOptionbool)
		if EquipmentAffected_Blocking.GetValue() as int == 1
			EquipmentAffected_Blocking.SetValue(0)
		else
			EquipmentAffected_Blocking.SetValue(1)
		endif

	elseif option == OptionalWeakAttackPerkOption
		OptionalWeakAttackPerkOptionbool = !OptionalWeakAttackPerkOptionbool
		SetToggleOptionValue(OptionalWeakAttackPerkOption, OptionalWeakAttackPerkOptionbool)
		if EquipmentAffected_zOptionalWeakAttackPerk.GetValue() as int == 1
			EquipmentAffected_zOptionalWeakAttackPerk.SetValue(0)
		else
			EquipmentAffected_zOptionalWeakAttackPerk.SetValue(1)
		endif

	elseif option == UninstallOption
		SetToggleOptionValue(UninstallOption, true)
		SetOptionFlags(UninstallOption, OPTION_FLAG_DISABLED)
		Game.GetPlayer().RemovePerk(ModPerk1)
		Game.GetPlayer().RemovePerk(ModPerk2)
		Game.GetPlayer().RemovePerk(ModPerk3)
		Game.GetPlayer().RemovePerk(ModPerk4)
		Game.GetPlayer().RemovePerk(ModPerk5)
		Game.GetPlayer().RemovePerk(ModPerk6)
		Game.GetPlayer().RemovePerk(ModPerk7)
		Game.GetPlayer().RemovePerk(ModPerk8)
		Game.GetPlayer().RemovePerk(ModPerk9)
		Game.GetPlayer().RemovePerk(ModPerk10)
		Game.GetPlayer().RemovePerk(ModPerk11)
		Game.GetPlayer().RemovePerk(ModPerk12)
		Game.GetPlayer().RemovePerk(ModPerk99)
		Debug.Notification("$Save your game, quit, uninstall this plugin, reload, and save again.")

	endif
endEvent

Event OnOptionSliderOpen(int option)
	if (option == AetheriumLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(AetheriumLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == BonemoldLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(BonemoldLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == BoundLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(BoundLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == ChitinLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(ChitinLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == DaedricLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(DaedricLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == DragonLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(DragonLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == DraugrLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(DraugrLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == DwarvenLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(DwarvenLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == EbonyLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(EbonyLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == ElvenLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(ElvenLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == FalmerLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(FalmerLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == GlassLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(GlassLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == HideLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(HideLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == ImperialLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(ImperialLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == IronLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(IronLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == LeatherLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(LeatherLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == NordicLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(NordicLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == OrcishLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(OrcishLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == SilverLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(SilverLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == StalhrimLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(StalhrimLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == SteelLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(SteelLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == StuddedLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(StuddedLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == WoodLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(WoodLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == MagicNoviceLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(MagicNoviceLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == MagicApprenticeLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(MagicApprenticeLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == MagicAdeptLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(MagicAdeptLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == MagicExpertLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(MagicExpertLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == MagicMasterLevelOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(MagicMasterLevel.GetValue())
		SetSliderDialogInterval(1)

	elseif (option == OptionalDisarmChanceOption)
		SetSliderDialogRange(0, 100)
		SetSliderDialogStartValue(EquipmentAffected_zOptionalDisarmChance.GetValue())
		SetSliderDialogInterval(1)

	endif
endEvent

Event OnOptionSliderAccept(int option, float value)
	if (option == AetheriumLevelOption)
		AetheriumLevel.SetValue(value)
		SetSliderOptionValue(AetheriumLevelOption,AetheriumLevel.GetValue())

	elseif (option == BonemoldLevelOption)
		BonemoldLevel.SetValue(value)
		SetSliderOptionValue(BonemoldLevelOption,BonemoldLevel.GetValue())

	elseif (option == BoundLevelOption)
		BoundLevel.SetValue(value)
		SetSliderOptionValue(BoundLevelOption,BoundLevel.GetValue())

	elseif (option == ChitinLevelOption)
		ChitinLevel.SetValue(value)
		SetSliderOptionValue(ChitinLevelOption,ChitinLevel.GetValue())

	elseif (option == DaedricLevelOption)
		DaedricLevel.SetValue(value)
		SetSliderOptionValue(DaedricLevelOption,DaedricLevel.GetValue())

	elseif (option == DragonLevelOption)
		DragonLevel.SetValue(value)
		SetSliderOptionValue(DragonLevelOption,DragonLevel.GetValue())

	elseif (option == DraugrLevelOption)
		DraugrLevel.SetValue(value)
		SetSliderOptionValue(DraugrLevelOption,DraugrLevel.GetValue())

	elseif (option == DwarvenLevelOption)
		DwarvenLevel.SetValue(value)
		SetSliderOptionValue(DwarvenLevelOption,DwarvenLevel.GetValue())

	elseif (option == EbonyLevelOption)
		EbonyLevel.SetValue(value)
		SetSliderOptionValue(EbonyLevelOption,EbonyLevel.GetValue())

	elseif (option == ElvenLevelOption)
		ElvenLevel.SetValue(value)
		SetSliderOptionValue(ElvenLevelOption,ElvenLevel.GetValue())

	elseif (option == FalmerLevelOption)
		FalmerLevel.SetValue(value)
		SetSliderOptionValue(FalmerLevelOption,FalmerLevel.GetValue())

	elseif (option == GlassLevelOption)
		GlassLevel.SetValue(value)
		SetSliderOptionValue(GlassLevelOption,GlassLevel.GetValue())

	elseif (option == HideLevelOption)
		HideLevel.SetValue(value)
		SetSliderOptionValue(HideLevelOption,HideLevel.GetValue())

	elseif (option == ImperialLevelOption)
		ImperialLevel.SetValue(value)
		SetSliderOptionValue(ImperialLevelOption,ImperialLevel.GetValue())

	elseif (option == IronLevelOption)
		IronLevel.SetValue(value)
		SetSliderOptionValue(IronLevelOption,IronLevel.GetValue())

	elseif (option == LeatherLevelOption)
		LeatherLevel.SetValue(value)
		SetSliderOptionValue(LeatherLevelOption,LeatherLevel.GetValue())

	elseif (option == NordicLevelOption)
		NordicLevel.SetValue(value)
		SetSliderOptionValue(NordicLevelOption,NordicLevel.GetValue())

	elseif (option == OrcishLevelOption)
		OrcishLevel.SetValue(value)
		SetSliderOptionValue(OrcishLevelOption,OrcishLevel.GetValue())

	elseif (option == SilverLevelOption)
		SilverLevel.SetValue(value)
		SetSliderOptionValue(SilverLevelOption,SilverLevel.GetValue())

	elseif (option == StalhrimLevelOption)
		StalhrimLevel.SetValue(value)
		SetSliderOptionValue(StalhrimLevelOption,StalhrimLevel.GetValue())

	elseif (option == SteelLevelOption)
		SteelLevel.SetValue(value)
		SetSliderOptionValue(SteelLevelOption,SteelLevel.GetValue())

	elseif (option == StuddedLevelOption)
		StuddedLevel.SetValue(value)
		SetSliderOptionValue(StuddedLevelOption,StuddedLevel.GetValue())

	elseif (option == WoodLevelOption)
		WoodLevel.SetValue(value)
		SetSliderOptionValue(WoodLevelOption,WoodLevel.GetValue())

	elseif (option == MagicNoviceLevelOption)
		MagicNoviceLevel.SetValue(value)
		SetSliderOptionValue(MagicNoviceLevelOption,MagicNoviceLevel.GetValue())

	elseif (option == MagicApprenticeLevelOption)
		MagicApprenticeLevel.SetValue(value)
		SetSliderOptionValue(MagicApprenticeLevelOption,MagicApprenticeLevel.GetValue())

	elseif (option == MagicAdeptLevelOption)
		MagicAdeptLevel.SetValue(value)
		SetSliderOptionValue(MagicAdeptLevelOption,MagicAdeptLevel.GetValue())

	elseif (option == MagicExpertLevelOption)
		MagicExpertLevel.SetValue(value)
		SetSliderOptionValue(MagicExpertLevelOption,MagicExpertLevel.GetValue())

	elseif (option == MagicMasterLevelOption)
		MagicMasterLevel.SetValue(value)
		SetSliderOptionValue(MagicMasterLevelOption,MagicMasterLevel.GetValue())

	elseif (option == OptionalDisarmChanceOption)
		EquipmentAffected_zOptionalDisarmChance.SetValue(value)
		SetSliderOptionValue(OptionalDisarmChanceOption,EquipmentAffected_zOptionalDisarmChance.GetValue(),"{0}%")

	endif
endEvent