Scriptname BB_EquipmentRestriction_BlockCheck extends Quest Conditional

Keyword Property ArmorHeavy Auto
Keyword Property ArmorLight Auto
Keyword Property ArmorShield Auto
Keyword Property ArmorMaterialBearStormcloak Auto
Keyword Property ArmorMaterialBlades Auto
Keyword Property ArmorMaterialDaedric Auto
Keyword Property ArmorMaterialDragonplate Auto
Keyword Property ArmorMaterialDragonscale Auto
Keyword Property ArmorMaterialDwarven Auto
Keyword Property ArmorMaterialEbony Auto
Keyword Property ArmorMaterialElven Auto
Keyword Property ArmorMaterialElvenGilded Auto
Keyword Property ArmorMaterialFalmer Auto
Keyword Property ArmorMaterialForsworn Auto
Keyword Property ArmorMaterialMS02Forsworn Auto
Keyword Property ArmorMaterialGlass Auto
Keyword Property ArmorMaterialHide Auto
Keyword Property ArmorMaterialImperialLight Auto
Keyword Property ArmorMaterialImperialHeavy Auto
Keyword Property ArmorMaterialImperialStudded Auto
Keyword Property ArmorMaterialIron Auto
Keyword Property ArmorMaterialIronBanded Auto
Keyword Property ArmorMaterialLeather Auto
Keyword Property ArmorMaterialOrcish Auto
Keyword Property ArmorMaterialPenitus Auto
Keyword Property ArmorMaterialScaled Auto
Keyword Property ArmorMaterialSteel Auto
Keyword Property ArmorMaterialSteelPlate Auto
Keyword Property ArmorMaterialStormcloak Auto
Keyword Property ArmorMaterialStudded Auto
Keyword Property ArmorMaterialThievesGuild Auto
Keyword Property ArmorMaterialThievesGuildMaster Auto
Keyword Property DLC1ArmorMaterialFalmerHardened Auto
Keyword Property DLC1ArmorMaterialDawnguard Auto
Keyword Property DLC1LD_CraftingMaterialAetherium Auto
Keyword Property DLC1WeapMaterialDragonbone Auto
Keyword Property DLC2ArmorMaterialBonemoldHeavy Auto
Keyword Property DLC2ArmorMaterialBonemoldLight Auto
Keyword Property DLC2ArmorMaterialChitinHeavy Auto
Keyword Property DLC2ArmorMaterialChitinLight Auto
Keyword Property DLC2ArmorMaterialMoragTong Auto
Keyword Property DLC2ArmorMaterialNordicHeavy Auto
Keyword Property DLC2ArmorMaterialNordicBonemoldLight Auto
Keyword Property DLC2ArmorMaterialStalhrimHeavy Auto
Keyword Property DLC2ArmorMaterialStalhrimLight Auto
Keyword Property DLC2WeaponMaterialNordic Auto
Keyword Property DLC2WeaponMaterialStalhrim Auto
Keyword Property WeapMaterialDaedric Auto
Keyword Property WeapMaterialDwarven Auto
Keyword Property WeapMaterialDraugr Auto
Keyword Property WeapMaterialDraugrHoned Auto
Keyword Property WeapMaterialEbony Auto
Keyword Property WeapMaterialElven Auto
Keyword Property WeapMaterialFalmer Auto
Keyword Property WeapMaterialFalmerHoned Auto
Keyword Property WeapMaterialForsworn Auto
Keyword Property WeapMaterialGlass Auto
Keyword Property WeapMaterialImperial Auto
Keyword Property WeapMaterialIron Auto
Keyword Property WeapMaterialOrcish Auto
Keyword Property WeapMaterialSilver Auto
Keyword Property WeapMaterialSteel Auto
Keyword Property WeapMaterialWood Auto
Keyword Property WeapTypeBattleaxe Auto
Keyword Property WeapTypeBow Auto
Keyword Property WeapTypeCrossbow Auto
Keyword Property WeapTypeDagger Auto
Keyword Property WeapTypeGreatsword Auto
Keyword Property WeapTypeMace Auto
Keyword Property WeapTypeSword Auto
Keyword Property WeapTypeWaraxe Auto
Keyword Property WeapTypeWarhammer Auto

GlobalVariable Property AetheriumLevel Auto
GlobalVariable Property BonemoldLevel Auto
GlobalVariable Property BoundLevel Auto
GlobalVariable Property ChitinLevel Auto
GlobalVariable Property DaedricLevel Auto
GlobalVariable Property DragonLevel Auto
GlobalVariable Property DraugrLevel Auto
GlobalVariable Property DwarvenLevel Auto
GlobalVariable Property EbonyLevel Auto
GlobalVariable Property ElvenLevel Auto
GlobalVariable Property FalmerLevel Auto
GlobalVariable Property GlassLevel Auto
GlobalVariable Property HideLevel Auto
GlobalVariable Property ImperialLevel Auto
GlobalVariable Property IronLevel Auto
GlobalVariable Property LeatherLevel Auto
GlobalVariable Property NordicLevel Auto
GlobalVariable Property OrcishLevel Auto
GlobalVariable Property SilverLevel Auto
GlobalVariable Property StalhrimLevel Auto
GlobalVariable Property SteelLevel Auto
GlobalVariable Property StuddedLevel Auto
GlobalVariable Property WoodLevel Auto

Formlist Property BoundWeaponList Auto

int CantBlockEffectively Conditional


int Function CheckBlocking(Actor akActor)
   ;Debug.Notification("Check Block Function called.")
   CantBlockEffectively = 0
   int CheckBlocking_LevelRequired = 0
   Form LeftObject = akActor.GetEquippedObject(0)
   if (!LeftObject) || ((LeftObject as Weapon).IsBattleaxe()) || ((LeftObject as Weapon).IsGreatsword()) || ((LeftObject as Weapon).IsWarhammer())
      if CheckBlockingRight(Game.GetPlayer(), (((LeftObject as Weapon).IsBattleaxe()) || ((LeftObject as Weapon).IsGreatsword()) || ((LeftObject as Weapon).IsWarhammer()))) == 1
         return 1
      else
         return 0
      endif
   elseif LeftObject as Weapon
      ;do nothing
   elseif LeftObject as Armor
      if LeftObject.HasKeyword(DLC1LD_CraftingMaterialAetherium)
         if CheckBlocking_LevelRequired < (AetheriumLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (AetheriumLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialDaedric)
         if CheckBlocking_LevelRequired < (DaedricLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (DaedricLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialDragonplate) || LeftObject.HasKeyword(ArmorMaterialDragonscale)
         if CheckBlocking_LevelRequired < (DragonLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (DragonLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialDwarven)
         if CheckBlocking_LevelRequired < (DwarvenLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (DwarvenLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialEbony)
         if CheckBlocking_LevelRequired < (EbonyLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (EbonyLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialElven) || LeftObject.HasKeyword(ArmorMaterialElvenGilded)
         if CheckBlocking_LevelRequired < (ElvenLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (ElvenLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialFalmer) || LeftObject.HasKeyword(DLC1ArmorMaterialFalmerHardened)
         if CheckBlocking_LevelRequired < (FalmerLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (FalmerLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialGlass)
         if CheckBlocking_LevelRequired < (GlassLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (GlassLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialHide) || LeftObject.HasKeyword(ArmorMaterialForsworn) || LeftObject.HasKeyword(ArmorMaterialMS02Forsworn)
         if CheckBlocking_LevelRequired < (HideLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (HideLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialImperialLight) || LeftObject.HasKeyword(ArmorMaterialImperialHeavy) || LeftObject.HasKeyword(ArmorMaterialImperialStudded) || LeftObject.HasKeyword(ArmorMaterialStormcloak) || LeftObject.HasKeyword(ArmorMaterialBearStormcloak)
         if CheckBlocking_LevelRequired < (ImperialLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (ImperialLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialIron) || LeftObject.HasKeyword(ArmorMaterialIronBanded)
         if CheckBlocking_LevelRequired < (IronLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (IronLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialLeather) || LeftObject.HasKeyword(ArmorMaterialThievesGuild) || LeftObject.HasKeyword(ArmorMaterialThievesGuildMaster)
         if CheckBlocking_LevelRequired < (LeatherLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (LeatherLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialOrcish)
         if CheckBlocking_LevelRequired < (OrcishLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (OrcishLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialScaled) || LeftObject.HasKeyword(ArmorMaterialSteel) || LeftObject.HasKeyword(ArmorMaterialSteelPlate) || LeftObject.HasKeyword(ArmorMaterialBlades) || LeftObject.HasKeyword(ArmorMaterialPenitus) || LeftObject.HasKeyword(DLC1ArmorMaterialDawnguard)
         if CheckBlocking_LevelRequired < (SteelLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (SteelLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(ArmorMaterialStudded)
         if CheckBlocking_LevelRequired < (StuddedLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (StuddedLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(DLC2ArmorMaterialBonemoldHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialBonemoldLight)
         if CheckBlocking_LevelRequired < (BonemoldLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (BonemoldLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(DLC2ArmorMaterialChitinHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialChitinLight) || LeftObject.HasKeyword(DLC2ArmorMaterialMoragTong)
         if CheckBlocking_LevelRequired < (ChitinLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (ChitinLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(DLC2ArmorMaterialNordicHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialNordicBonemoldLight)
         if CheckBlocking_LevelRequired < (NordicLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (NordicLevel.GetValue() as int)
         endif
      endif

      if LeftObject.HasKeyword(DLC2ArmorMaterialStalhrimHeavy) || LeftObject.HasKeyword(DLC2ArmorMaterialStalhrimLight)
         if CheckBlocking_LevelRequired < (StalhrimLevel.GetValue() as int)
            CheckBlocking_LevelRequired = (StalhrimLevel.GetValue() as int)
         endif
      endif
   endif

   if Game.GetPlayer().GetAV("Block") < CheckBlocking_LevelRequired
      CantBlockEffectively = 1
      ;Debug.Notification("Variable set to 1")
      ;Debug.Notification("$You lack the required skill to effectively block with this equipment.")
      ;Utility.Wait(3)
      ;Debug.Notification("Variable is now " + CantBlockEffectively)
   endif

   return CantBlockEffectively

endFunction

int Function CheckBlockingRight(Actor akActor, bool is2H)
   Form RightObject = akActor.GetEquippedObject(1)
   int CheckBlockingRight_LevelRequired = 0
   if RightObject as Weapon
      if RightObject.HasKeyword(WeapMaterialDaedric)
         if CheckBlockingRight_LevelRequired < (DaedricLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (DaedricLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(DLC1WeapMaterialDragonbone)
         if CheckBlockingRight_LevelRequired < (DragonLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (DragonLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialDwarven)
         if CheckBlockingRight_LevelRequired < (DwarvenLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (DwarvenLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialDraugr) || RightObject.HasKeyword(WeapMaterialDraugrHoned)
         if CheckBlockingRight_LevelRequired < (DraugrLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (DraugrLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialEbony)
         if CheckBlockingRight_LevelRequired < (EbonyLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (EbonyLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialElven)
         if CheckBlockingRight_LevelRequired < (ElvenLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (ElvenLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialFalmer) || RightObject.HasKeyword(WeapMaterialFalmerHoned)
         if CheckBlockingRight_LevelRequired < (FalmerLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (FalmerLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialGlass)
         if CheckBlockingRight_LevelRequired < (GlassLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (GlassLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialImperial)
         if CheckBlockingRight_LevelRequired < (ImperialLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (ImperialLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialIron)
         if CheckBlockingRight_LevelRequired < (IronLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (IronLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialOrcish)
         if CheckBlockingRight_LevelRequired < (OrcishLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (OrcishLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialSilver)
         if CheckBlockingRight_LevelRequired < (SilverLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (SilverLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialSteel)
         if CheckBlockingRight_LevelRequired < (SteelLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (SteelLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(WeapMaterialWood)
         if CheckBlockingRight_LevelRequired < (WoodLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (WoodLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(DLC1LD_CraftingMaterialAetherium)
         if CheckBlockingRight_LevelRequired < (AetheriumLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (AetheriumLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(DLC2WeaponMaterialNordic)
         if CheckBlockingRight_LevelRequired < (NordicLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (NordicLevel.GetValue() as int)
         endif
      endif

      if RightObject.HasKeyword(DLC2WeaponMaterialStalhrim)
         if CheckBlockingRight_LevelRequired < (StalhrimLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (StalhrimLevel.GetValue() as int)
         endif
      endif

      if BoundWeaponList.HasForm(RightObject)
         ;if CheckBlockingRight_LevelRequired < (BoundLevel.GetValue() as int)
            CheckBlockingRight_LevelRequired = (BoundLevel.GetValue() as int)
         ;endif
      endif
   endif

   if !is2H && Game.GetPlayer().GetAV("OneHanded") < CheckBlockingRight_LevelRequired
      CantBlockEffectively = 1
      ;Debug.Notification("Variable set to 1")
      ;Debug.Notification("$You lack the required skill to effectively block with this equipment.")
      ;Utility.Wait(3)
      ;Debug.Notification("Variable is now " + CantBlockEffectively)
   elseif is2H && Game.GetPlayer().GetAV("TwoHanded") < CheckBlockingRight_LevelRequired
      CantBlockEffectively = 1
   endif

   return CantBlockEffectively
endFunction