﻿ScriptName LZDPMA_collisionEnabler extends Quest

ObjectReference Property PlayerCollisionObj Auto
Perk Property PlayerCollisionTrackerPerk Auto

bool isPlayerStandingStill
bool playerRequestedCollision
int manualRequestKey
Actor mainPlayerRef

;;; Initializes all variables and adds the tracking perk to the player.
Event OnInit()
    isPlayerStandingStill = false
    playerRequestedCollision = false

    mainPlayerRef = Game.GetPlayer()
    mainPlayerRef.AddPerk(PlayerCollisionTrackerPerk)

    manualRequestKey = Input.GetMappedKey("Sprint")
    RegisterForKey(manualRequestKey)
    RegisterForMenu("Dialogue Menu")
EndEvent

;;; When the player enters dialogue, a collision marker is enabled to prevent nearby NPCs from
;;; bumping into and "nudging" the player. However, this does not catch scenes i.e. when NPCs talk
;;; to the player without entering formal dialogue.
Event OnMenuOpen(String MenuName)
	If MenuName == "Dialogue Menu"
		PlayerCollisionObj.MoveTo(mainPlayerRef)
	EndIf
EndEvent

;;; Some NPCs talk to the player without opening up the dialogue menu itself (e.g. in Dragonsreach,
;;; when the Jarl talks to the player, Proventus, and Irileth together). In this case, there is no
;;; way for to Papyrus to know if dialogue is occurring. As a workaround, if the player has been
;;; standing still for ~1 second and presses Sprint, a collision marker will be placed manually,
;;; and will not be removed until the player moves again (or enters combat).
Event OnKeyUp(Int KeyCode, Float HoldTime)
    If !Utility.IsInMenuMode() && isPlayerStandingStill && KeyCode == manualRequestKey && HoldTime < 0.5
        PlayerCollisionObj.MoveTo(mainPlayerRef)
        playerRequestedCollision = true
    EndIf
EndEvent

;;; When the player exits dialogue, the collision marker is disabled to allow NPCs to approach the
;;; player again. If the player requested collision within a scene, the marker is not disabled
;;; until the player moves again or enters combat. This means the player won't have to press the
;;; sprint button repeatedly within complex scenes (e.g. the Dragonsreach discussion with Jarl has
;;; multiple sections of dialogue menu + nonmenu scenes, and pressing the button each time to keep
;;; followers away would be very annoying!).
Event OnMenuClose(String MenuName)
	If MenuName == "Dialogue Menu" && playerRequestedCollision == false
        DisableCollisions()
	EndIf
EndEvent

;;; EXTERNAL FUNCTION: indicates that the player is not moving and is not in battle. After this
;;; function is called, the player can press the sprint key to prevent NPCs from bumping into and
;;; "nudging" the player. This allows the user to disable collision in a scene, when the dialogue
;;; menu is not actually open.
Function EnableCollisionRequest()
    isPlayerStandingStill = true
EndFunction

;;; EXTERNAL FUNCTION: indicates that the player has moved, entered combat, or that the dialogue
;;; menu has been closed. The current collision marker (if any) will be removed, allowing NPCs to
;;; approach the player again.
Function DisableCollisions()
    isPlayerStandingStill = false
    playerRequestedCollision = false
    PlayerCollisionObj.MoveToMyEditorLocation()
EndFunction
