Scriptname LZSBW_summonBoundItem extends ActiveMagicEffect

Quest Property BoundItemsQuest Auto
ObjectReference Property Storage Auto
String[] Property AliasesToEquip Auto
Form Property AddExtra Auto
int Property AddExtraQuantity Auto

Event OnEffectStart(Actor Target, Actor Caster)
    ObjectReference oRef = None

    int index = AliasesToEquip.Length - 1
    While (index >= 0)
        oRef = (BoundItemsQuest.GetAliasByName(AliasesToEquip[index]) as ReferenceAlias).GetRef()
        Caster.AddItem(oRef, 1, true)
        Caster.EquipItem(oRef.GetBaseObject(), false, true)
        index -= 1
    EndWhile

    If AddExtra != None
        Caster.AddItem(AddExtra, AddExtraQuantity, true)
        Caster.EquipItem(AddExtra, true, true)
    EndIf
EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)
    ObjectReference oRef = None

    int index = AliasesToEquip.Length - 1
    While (index >= 0)
        oRef = (BoundItemsQuest.GetAliasByName(AliasesToEquip[index]) as ReferenceAlias).GetRef()
        Caster.RemoveItem(oRef.GetBaseObject(), 1, true, Storage)
        index -= 1
    EndWhile

    If AddExtra != None
        Caster.RemoveItem(AddExtra, Caster.GetItemCount(AddExtra), true)
    EndIf
EndEvent
