﻿Scriptname JaxonzEnhGrabNoDriftMarkerScript extends ObjectReference
{Attempts to correct sinking object syndrome.
Move associated object to marker location on cell load.}

Import Debug

ObjectReference Property objPositioned Auto

;int iSuperFast = 1000000

Event OnCellLoad()
;	;wait until associated object is loaded
;	While !objPositioned.Is3DLoaded()
;		Utility.Wait(0.1)
;	EndWhile

	;make sure objPositioned exists in this cell
	if !objPositioned || (GetParentCell() != objPositioned.GetParentCell())
		Trace("JaxonzEnhGrabNoDriftMarkerScript: No objPositioned set or in a different cell. Deleting this marker instance.")
        DeletePairedDriftController()
	Else
		if X != objPositioned.X || Y != objPositioned.Y || Z != objPositioned.Z
			Trace ("JaxonzEnhGrabNoDriftMarkerScript: Associated object has moved" + \
				" X:" + X + "|" + objPositioned.X + \
				" Y:" + Y + "|" + objPositioned.Y + \
				" Z:" + Z + "|" + objPositioned.Z)
			objPositioned.TranslateToRef(Self, 1000000, 0.0)
		EndIf
	EndIf
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SALCJE FUNCTIONS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Deletes this no-drift controller object.                                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function DeletePairedDriftController()
    Cell currObjRefCell = GetParentCell()
    string currCellObjKey = GetCellObjKey(currObjRefCell)

    If StorageUtil.HasStringValue(none, currCellObjKey)
        StorageUtil.UnsetStringValue(none, currCellObjKey)
    EndIf

    DisableNoWait()
    Delete()
EndFunction


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Generates a unique key to represent this object within its cell.                            ;;;
;;; The resulting key will be independent of any changes to load order.                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
string Function GetCellObjKey(Cell currObjRefCell)
    Return "SALCJE__" \
            + LZStringUtil.GetLoadIndependentFormDecAllowCustom(currObjRefCell.GetFormID()) \
            + "::" + LZStringUtil.GetLoadIndependentFormDecAllowCustom(GetFormID())
EndFunction
