﻿ScriptName SALCJEMainScriptMCM extends SKI_ConfigBase



Activator Property actNoDriftMarker Auto
Activator Property grabMarker Auto
MiscObject Property grabStatic Auto
Static Property grabUndoMarker Auto
Light Property grabLightMarker Auto

GlobalVariable Property SALCJE_LegacySelection Auto
ObjectReference Property currObjRef Auto
int Property currObjRefID Auto
int Property currObjBaseID Auto
string Property currObjType Auto
bool Property currObjCustom Auto
bool Property currObjDisabled Auto
bool Property currObjDeleted Auto
float Property currObjX Auto
float Property currObjY Auto
float Property currObjZ Auto
float Property currObjAngX Auto
float Property currObjAngY Auto
float Property currObjAngZ Auto
float Property currObjScale Auto


int TYPE_ARMA = 102
int TYPE_ACTIVATOR = 24
int TYPE_AMMO = 42
int TYPE_ARMOR = 26
int TYPE_BOOK = 27
int TYPE_CONTAINER = 28
int TYPE_DEBRIS = 88
int TYPE_DOOR = 29
int TYPE_FLORA = 39
int TYPE_FURNITURE = 40
int TYPE_GRASS = 37
int TYPE_INGREDIENT = 30
int TYPE_KEY = 45
int TYPE_LAND = 72
int TYPE_LIGHT = 31
int TYPE_MISC = 32
int TYPE_MOVABLESTATIC = 36
int TYPE_NOTE = 48
int TYPE_POTION = 46
int TYPE_SCROLLITEM = 23
int TYPE_SOULGEM = 52
int TYPE_STATIC = 34
int TYPE_STATICCOLLECTION = 35
int TYPE_TALKINGACTIVATOR = 25
int TYPE_TREE = 38
int TYPE_WATER = 84
int TYPE_WEAPON = 41

int TYPE_BUTTON = 0
int TYPE_TOGGLE = 1
int TYPE_OBJ_TOGGLE = 2

int MAX_REF_ITERS
int BUFFER_SIZE
int PROGRESS_TICK
string ROOT_DIR

int MOTION_STATIC
int TRANSLATE_FAST

int ACT_NO_DRIFT_ID
int ACT_GRAB_ID
int MISC_GRAB_ID
int STAT_UNDO_ID
int LIGHT_ID


int[] mcmTypes
string[] mcmTooltips
string[] mcmEvents
string[] mcmConfirm
bool[] mcmToggleValues
int[] mcmToggleObjIndexes
bool[] mcmAllowedObjTypes

int mcmOptSave
int mcmOptLoad
int mcmOptDebugUndo
int mcmOptClearMarkers
int mcmOptLegacySelect

string objToLine
Form currObjBase
Cell currPlayerCell



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MCM CORE ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Initializes the MCM configuration.                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnConfigInit()
    MAX_REF_ITERS = 4
    BUFFER_SIZE = 100
    PROGRESS_TICK = 25
    ROOT_DIR = "saveAndLoadCellsJaxonzExtension/"

    MOTION_STATIC = 4
    TRANSLATE_FAST = 10000

    ACT_NO_DRIFT_ID = actNoDriftMarker.GetFormID()
    ACT_GRAB_ID = grabMarker.GetFormID()
    MISC_GRAB_ID = grabStatic.GetFormID()
    STAT_UNDO_ID = grabUndoMarker.GetFormID()
    LIGHT_ID = grabLightMarker.GetFormID()

    mcmTypes = new int[128]
    mcmTooltips = new string[128]
    mcmEvents = new string[128]
    mcmConfirm = new string[128]
    mcmToggleValues = new bool[128]
    mcmToggleObjIndexes = new int[128]
    InitObjTypes()

    Pages = new string[3]
    Pages[0] = "Save Cell"
    Pages[1] = "Load Cell"
    Pages[2] = "Advanced Options"
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Initializes the allowable object types (for saving or loading).\                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function InitObjTypes()
    mcmAllowedObjTypes = new bool[128]

    int index = 0
    While index < 128
        mcmAllowedObjTypes[index] = False
        index += 1
    EndWhile

    mcmAllowedObjTypes[TYPE_ARMA] = True
    mcmAllowedObjTypes[TYPE_ACTIVATOR] = True
    mcmAllowedObjTypes[TYPE_AMMO] = True
    mcmAllowedObjTypes[TYPE_ARMOR] = True
    mcmAllowedObjTypes[TYPE_BOOK] = True
    mcmAllowedObjTypes[TYPE_CONTAINER] = True
    mcmAllowedObjTypes[TYPE_DEBRIS] = True
    mcmAllowedObjTypes[TYPE_DOOR] = True
    mcmAllowedObjTypes[TYPE_FLORA] = True
    mcmAllowedObjTypes[TYPE_FURNITURE] = True
    mcmAllowedObjTypes[TYPE_GRASS] = True
    mcmAllowedObjTypes[TYPE_INGREDIENT] = True
    mcmAllowedObjTypes[TYPE_KEY] = True
    mcmAllowedObjTypes[TYPE_LAND] = True
    mcmAllowedObjTypes[TYPE_LIGHT] = True
    mcmAllowedObjTypes[TYPE_MISC] = True
    mcmAllowedObjTypes[TYPE_MOVABLESTATIC] = True
    mcmAllowedObjTypes[TYPE_NOTE] = True
    mcmAllowedObjTypes[TYPE_POTION] = True
    mcmAllowedObjTypes[TYPE_SCROLLITEM] = True
    mcmAllowedObjTypes[TYPE_SOULGEM] = True
    mcmAllowedObjTypes[TYPE_STATIC] = True
    mcmAllowedObjTypes[TYPE_STATICCOLLECTION] = True
    mcmAllowedObjTypes[TYPE_TALKINGACTIVATOR] = True
    mcmAllowedObjTypes[TYPE_TREE] = True
    mcmAllowedObjTypes[TYPE_WATER] = True
    mcmAllowedObjTypes[TYPE_WEAPON] = True
EndFunction



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MCM PAGES ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates the MCM layout for the save-cell page.                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function MCMCreatePageSaveCell()
    SetCursorFillMode(TOP_TO_BOTTOM)

    AddHeaderOption("Instructions")
    MCMDefineParagraph("Click 'Save to File' to save all objects in the current location. " \
            + "DO NOT CLOSE THIS MENU while objects are being saved! " \
            + "You will see a message when saving is complete.")
    AddTextOption(" ", "", 0x1)
    MCMDefineParagraph("This process can take a VERY LONG TIME to complete, " \
            + "especially for Hearthfire homes. " \
            + "You may need to wait between 10-30 minutes.")
    AddTextOption(" ", "", 0x1)
    MCMDefineParagraph("Use the 'Advanced Options' page to choose which object types are saved.")

    SetCursorPosition(1)
    AddHeaderOption("Save Cell to File")
    MCMDefineParagraph("Progress will be logged below. " \
            + "If a file was previously saved, it will be OVERWRITTEN.")
    AddTextOption(" ", "", 0x1)

    mcmOptClearMarkers = MCMDefineToggle("Clear Undo Markers", False, \
            "If you installed this mod on an existing save, " \
            + "enabling this option will clear out orphaned Jaxonz data, " \
            + "making the NEXT save operation for this cell much faster. " \
            + "You can also clear data manually in 'Advanced Options'.")

    RegisterForModEvent("saveEventMCM", "OnMCMSave")
    mcmOptSave = MCMDefineButton("Current Cell", "Save to File", \
            "Saves the current cell to a file, overwriting any existing file with the same name.", \
            "Make sure you are NOT selecting or moving any objects before proceeding. " \
            + "It may take a VERY LONG TIME to save this cell, " \
            + "during which you MUST NOT CLOSE THIS MENU." \
            + "\n\nAre you sure you want to save a file now?", \
            "saveEventMCM")
    AddTextOption(" ", "", 0x1)
    AddTextOption("Your current location is:", "", 0x1)
    AddTextOption(GetCellFileSimple(), "", 0x1)
    AddTextOption(" ", "", 0x1)
    AddTextOption("All files are saved to:", "", 0x1)
    AddTextOption("[SkyrimDir]/" + ROOT_DIR, "", 0x1)
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates the MCM layout for the save-cell page.                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function MCMCreatePageLoadCell()
    SetCursorFillMode(TOP_TO_BOTTOM)

    AddHeaderOption("Instructions")
    MCMDefineParagraph("Click 'Load File' to load objects here. " \
            + "DO NOT CLOSE THIS MENU while objects are loaded! " \
            + "You will see a message when loading is complete.")
    AddTextOption(" ", "", 0x1)
    MCMDefineParagraph("This process can take a LONG TIME, often between 5 and 15 minutes. " \
            + "You must make a 'full save' after loading is complete. " \
            + "Please quit and restart the game afterward.")
    AddTextOption(" ", "", 0x1)
    MCMDefineParagraph("Use the 'Advanced Options' page to choose which object types are loaded.")

    SetCursorPosition(1)
    AddHeaderOption("Load Cell from File")
    MCMDefineParagraph("Progress will be logged below. " \
            + "NEVER attempt to load the same cell twice!")
    AddTextOption(" ", "", 0x1)

    RegisterForModEvent("loadEventMCM", "OnMCMLoad")
    mcmOptLoad = MCMDefineButton("Current Cell", "Load File", \
            "Loads objects into the current cell from a file. " \
            + "NEVER do this more than once in the same game!", \
            "Make sure you are NOT selecting or moving any objects before proceeding. " \
            + "It may take a LONG TIME to load this cell, " \
            + "during which you MUST NOT CLOSE THIS MENU. " \
            + "Further, you must NEVER LOAD A CELL MORE THAN ONCE in the same save game, " \
            + "as duplicate objects will be created." \
            + "\n\nAre you sure you want to load objects now?", \
            "loadEventMCM")
    AddTextOption(" ", "", 0x1)
    AddTextOption("Your current location is:", "", 0x1)
    AddTextOption(GetCellFileSimple(), "", 0x1)
    AddTextOption(" ", "", 0x1)
    AddTextOption("All files are loaded from:", "", 0x1)
    AddTextOption("[SkyrimDir]/" + ROOT_DIR, "", 0x1)
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates the MCM layout for the debug page.                                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function MCMCreatePageDebug()
    SetCursorFillMode(TOP_TO_BOTTOM)

    AddHeaderOption("Clear Jaxonz Undo Markers")
    MCMDefineParagraph("Click 'Clear Undo Markers' to remove Jaxonz data from the current cell. " \
            + "Should only be used if you installed this mod on an existing save " \
            + "and cell saving is abnormally slow.")
    AddTextOption(" ", "", 0x1)
    MCMDefineParagraph("DO NOT CLOSE THIS MENU while clearing data. " \
            + "You will see a message when clearing is complete. " \
            + "This operation should only be performed once per cell.")
    AddTextOption(" ", "", 0x1)

    RegisterForModEvent("debugUndoEventMCM", "OnMCMDebugUndo")
    mcmOptDebugUndo = MCMDefineButton("Current Cell", "Clear Undo Markers", \
            "Clears orphaned Jaxonz data from this cell. " \
            + "Can also be done on-demand in 'Save Cell'.", \
           "Make sure you are NOT selecting or moving any objects before proceeding. " \
            + "It may take a LONG TIME to clear orphaned data, " \
            + "during which you MUST NOT CLOSE THIS MENU. " \
            + "You should only perform this operation once per cell at most."\
            + "\n\nAre you sure you want to clear orphaned data?", \
            "debugUndoEventMCM")

    AddTextOption(" ", "", 0x1)
    AddHeaderOption("Legacy Support")
    mcmOptLegacySelect = MCMDefineToggle("Use fallback selection", \
            SALCJE_LegacySelection.GetValue(), \
            "If you installed this mod mid-playthrough, you should generally " \
            + "leave this option enabled EXCEPT when selecting newly-placed objects. " \
            + "Otherwise, disable this option to greatly increase object selection speed.")

    SetCursorPosition(1)
    AddHeaderOption("Toggles")

    MCMDefineParagraph("Use the boxes below to control which objects can be saved to a file " \
            + "and which objects can be loaded from a file. " \
            + "Some types are not used by Skyrim, but might be used by a mod.")
    AddTextOption(" ", "", 0x1)

    string tooltip = "Disabling this option will prevent this object type " \
            + "from being saved or loaded from a file."
    MCMDefineToggleObj("Armor Addon", tooltip, TYPE_ARMA)
    MCMDefineToggleObj("Activator", tooltip, TYPE_ACTIVATOR)
    MCMDefineToggleObj("Ammo", tooltip, TYPE_AMMO)
    MCMDefineToggleObj("Armor", tooltip, TYPE_ARMOR)
    MCMDefineToggleObj("Book", tooltip, TYPE_BOOK)
    MCMDefineToggleObj("Container", tooltip, TYPE_CONTAINER)
    MCMDefineToggleObj("Debris", tooltip, TYPE_DEBRIS)
    MCMDefineToggleObj("Door", tooltip, TYPE_DOOR)
    MCMDefineToggleObj("Flora", tooltip, TYPE_FLORA)
    MCMDefineToggleObj("Furniture", tooltip, TYPE_FURNITURE)
    MCMDefineToggleObj("Grass", tooltip, TYPE_GRASS)
    MCMDefineToggleObj("Ingredient", tooltip, TYPE_INGREDIENT)
    MCMDefineToggleObj("Key", tooltip, TYPE_KEY)
    MCMDefineToggleObj("Land", tooltip, TYPE_LAND)
    MCMDefineToggleObj("Light", tooltip, TYPE_LIGHT)
    MCMDefineToggleObj("Misc", tooltip, TYPE_MISC)
    MCMDefineToggleObj("Movable Static", tooltip, TYPE_MOVABLESTATIC)
    MCMDefineToggleObj("Note", tooltip, TYPE_NOTE)
    MCMDefineToggleObj("Potion", tooltip, TYPE_POTION)
    MCMDefineToggleObj("Scroll", tooltip, TYPE_SCROLLITEM)
    MCMDefineToggleObj("Soul Gem", tooltip, TYPE_SOULGEM)
    MCMDefineToggleObj("Static", tooltip, TYPE_STATIC)
    MCMDefineToggleObj("Static Collection", tooltip, TYPE_STATICCOLLECTION)
    MCMDefineToggleObj("Talking Activator", tooltip, TYPE_TALKINGACTIVATOR)
    MCMDefineToggleObj("Tree", tooltip, TYPE_TREE)
    MCMDefineToggleObj("Water", tooltip, TYPE_WATER)
    MCMDefineToggleObj("Weapon", tooltip, TYPE_WEAPON)
EndFunction



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MCM WIDGETS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates a paragraph in MCM by repeatedly breaking the given string over multiple lines.     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function MCMDefineParagraph(string s)
    int maxLength = 46
    int i = 0
    int iFound

    While StringUtil.GetLength(s) > maxLength
        iFound = StringUtil.Find(s, "\n")

        If iFound >= maxLength || iFound == -1
            iFound = maxLength
            While StringUtil.GetNthChar(s, iFound) != " " || iFound < 0
                iFound -= 1
            EndWhile

            If iFound < 0
                iFound = maxLength
            EndIf
        EndIf

        AddTextOption(StringUtil.Substring(s, 0, iFound), "", 0x1)
        s = StringUtil.Substring(s, iFound + 1)
    EndWhile

    iFound = StringUtil.Find(s, "\n")
    While iFound != -1 && StringUtil.GetLength(s) > 0
        AddTextOption(StringUtil.Substring(s, 0, iFound), "", 0x1)
        s = StringUtil.Substring(s, iFound + 1)

        iFound = StringUtil.Find(s, "\n")
    EndWhile

    If StringUtil.GetLength(s) > 0
        AddTextOption(s, "", 0x1)
    EndIf
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates a button in MCM that triggers a specific event when clicked.                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
int Function MCMDefineButton(string left, string right, string help, string confirm, \
        string attachedEvent)
    int buttonIndex = AddTextOption(left, right, 0) % 128
    mcmTypes[buttonIndex] = TYPE_BUTTON
    mcmTooltips[buttonIndex] = help
    mcmEvents[buttonIndex] = attachedEvent
    mcmConfirm[buttonIndex] = confirm
    Return buttonIndex
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates a toggleable switch in MCM.                                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
int Function MCMDefineToggle(string left, bool initialState, string help)
    int toggleIndex = AddToggleOption(left, initialState, 0) % 128
    mcmTypes[toggleIndex] = TYPE_TOGGLE
    mcmToggleValues[toggleIndex] = initialState
    mcmTooltips[toggleIndex] = help
    Return toggleIndex
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Creates a toggleable object type switch in MCM.                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
int Function MCMDefineToggleObj(string left, string help, int objType)
    int toggleIndex = AddToggleOption(left, mcmAllowedObjTypes[objType], 0) % 128
    mcmTypes[toggleIndex] = TYPE_OBJ_TOGGLE
    mcmToggleValues[toggleIndex] = mcmAllowedObjTypes[objType]
    mcmToggleObjIndexes[toggleIndex] = objType
    mcmTooltips[toggleIndex] = help
    Return toggleIndex
EndFunction


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MCM EVENTS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; MCM event for handling page changes.                                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnPageReset(string page)
    If (page == "Save Cell")
        MCMCreatePageSaveCell()
    ElseIf (page == "Load Cell")
        MCMCreatePageLoadCell()
    ElseIf (page == "Advanced Options")
        MCMCreatePageDebug()
    EndIf
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; MCM event for displaying tooltips.                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnOptionHighlight(int opIndex)
    SetInfoText(mcmTooltips[opIndex % 128])
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; MCM event for responding to option selection.                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnOptionSelect(int opIndex)
    opIndex = opIndex % 128

    If mcmTypes[opIndex] == TYPE_TOGGLE
        mcmToggleValues[opIndex] = !mcmToggleValues[opIndex]
        SetToggleOptionValue(opIndex, mcmToggleValues[opIndex])
        If opIndex == mcmOptLegacySelect
            SALCJE_LegacySelection.SetValue(mcmToggleValues[opIndex] as int)
        EndIf

    ElseIf mcmTypes[opIndex] == TYPE_OBJ_TOGGLE
        mcmToggleValues[opIndex] = !mcmToggleValues[opIndex]
        mcmAllowedObjTypes[mcmToggleObjIndexes[opIndex]] = mcmToggleValues[opIndex]
        SetToggleOptionValue(opIndex, mcmToggleValues[opIndex])

    ElseIf mcmTypes[opIndex] == TYPE_BUTTON && mcmEvents[opIndex] != ""
        If ShowMessage(mcmConfirm[opIndex])
            If opIndex == mcmOptSave
                string currFileName = GetCellFile(Game.GetPlayer().GetParentCell())
                If !LZIOUtil.ExistsFile(currFileName)
                    SendModEvent(mcmEvents[opIndex])
                ElseIf ShowMessage("'" + currFileName + "' already exists. " \
                        + "If you proceed, this file will be overwritten and CANNOT be restored." \
                        + "\n\nAre you sure you want to erase this file and create a new one?")
                    SendModEvent(mcmEvents[opIndex])
                EndIf
            Else
                SendModEvent(mcmEvents[opIndex])
            EndIf
        EndIf
    EndIf
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Logs a notification indicating the current save progress.                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function LogSaveProgress(int numDone, int max)
    float percent = numDone * 100.0 / max
    SetTextOptionValue(mcmOptSave, "Progress: " + percent + "%");
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Logs a notification indicating the current load progress.                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function LogLoadProgress(int numDone)
    SetTextOptionValue(mcmOptLoad, "Objects Processed: " + numDone);
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Logs a notification indicating the current debug clear-undo progress.                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function LogDebugUndoProgress(int numDone, int max)
    float percent = numDone * 100.0 / max
    SetTextOptionValue(mcmOptDebugUndo, "Progress: " + percent + "%");
EndFunction



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; CUSTOM EVENTS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Processes a MCM save event.                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnMCMSave(string eventName, string strArg, float numArg, Form sender)
    SaveCell()
    SetTextOptionValue(mcmOptSave, "Save to File")
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Processes a MCM load event.                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnMCMLoad(string eventName, string strArg, float numArg, Form sender)
    LoadCell()
    SetTextOptionValue(mcmOptLoad, "Load File")
EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Processes a MCM clear-undo debug event.                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Event OnMCMDebugUndo(string eventName, string strArg, float numArg, Form sender)
    ClearUndoMarkers()
    SetTextOptionValue(mcmOptDebugUndo, "Clear Undo Markers")
EndEvent



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SALCJE FUNCTIONS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Saves the contents of the current cell.                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function SaveCell()
    currPlayerCell = Game.GetPlayer().GetParentCell()
    string cellFile = GetCellFile(currPlayerCell)

    If !LZIOUtil.LoadFile(cellFile, false, false, BUFFER_SIZE)
        Debug.MessageBox("Could not load or create '" + cellFile + "'." \
                + "\n\nPlease make sure that the file (if it exists) is not open or locked, " \
                + "and also that you are allowed to save files to this location.")
        Return
    EndIf

    int maxNumRefs = currPlayerCell.GetNumRefs()
    int refIndex = maxNumRefs - 1
    int inverseIndex = 0

    While refIndex >= 0
        If inverseIndex % PROGRESS_TICK == 0
            LogSaveProgress(inverseIndex, maxNumRefs)
        EndIf

        currObjRef = currPlayerCell.GetNthRef(refIndex)
        SaveRef(cellFile)

        refIndex -= 1
        inverseIndex += 1
    EndWhile

    currPlayerCell = None
    currObjBase = None
    currObjRef = None

    If !LZIOUtil.CloseFile(cellFile)
        Debug.MessageBox("Something went wrong when closing this file." \
                + "\n\nThere is a very good chance that NOT all objects were saved. " \
                + "Please make sure that no applications are locking or have opened this file, " \
                + "then try again.")
        Return
    EndIf
    Debug.MessageBox("All objects in this cell were successfully saved to '" + cellFile + "'!" \
            + "\n\nYou can test this file by starting a new game and loading it from there. " \
            + "If you want to edit or remove specific objects from the file, " \
            + "please see this mod's README for instructions.")
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Loads the contents of the current cell.                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function LoadCell()
    currPlayerCell = Game.GetPlayer().GetParentCell()
    string cellFile = GetCellFile(currPlayerCell)

    If !LZIOUtil.ExistsFile(cellFile)
        Debug.MessageBox("The file '" + cellFile + "' does not appear to exist." \
                + "\n\nPlease make sure the file exists, is named correctly, " \
                + "and that you are allowed to read files from this location." \
                + "\n\nThe current cell was NOT modified.")
    EndIf

    If !LZIOUtil.LoadFile(cellFile, true, false, BUFFER_SIZE)
        Debug.MessageBox("Could not load '" + cellFile + "'." \
                + "\n\nPlease make sure the file exists, is named correctly, " \
                + "and that you are allowed to read files from this location." \
                + "\n\nThe current cell was NOT modified.")
        Return
    EndIf

    string line = ""
    int numObjectsAdded = 0
    int numObjectsMoved = 0
    int totalObjects = 0;

    While LZIOUtil.HasNextLine(cellFile)
        If totalObjects % PROGRESS_TICK == 0
            LogLoadProgress(totalObjects)
        EndIf

        line = LZIOUtil.NextLine(cellFile)
        If StringUtil.GetLength(line) > 0
            string[] tokens = LZStringUtil.Split(line, "`")

            If tokens.Length == 13
                If tokens[3] == 1
                    numObjectsAdded += PlaceNewObj(tokens[2], tokens[1], tokens[6], tokens[7], \
                            tokens[8], tokens[9], tokens[10], tokens[11], tokens[12], 0)
                Else
                    numObjectsMoved += AssertObjState(tokens[2], tokens[1], tokens[4], tokens[5], \
                            tokens[6], tokens[7], tokens[8], tokens[9], tokens[10], tokens[11], \
                            tokens[12])
                EndIf
            EndIf
        EndIf

        totalObjects += 1
    EndWhile

    currPlayerCell = None
    currObjBase = None
    currObjRef = None

    LZIOUtil.CloseFile(cellFile)
    Debug.MessageBox("Loading complete! " \
            + "A total of " + numObjectsAdded + " objects were newly created " \
            + "and up to " + numObjectsMoved + " objects were enabled, disabled, or moved." \
            + "\n\nPlease MAKE A FULL SAVE, then QUIT AND RESTART your game. " \
            + "This step is NECESSARY to ensure that the loaded objects are properly saved!")
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Removes all Jaxonz undo markers from the current cell.                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Function ClearUndoMarkers()
    currPlayerCell = Game.GetPlayer().GetParentCell()
    int maxNumRefs = currPlayerCell.GetNumRefs(34)
    int refIndex = maxNumRefs - 1
    int inverseIndex = 0
    int numDeleted = 0

    While refIndex >= 0
        If inverseIndex % PROGRESS_TICK == 0
            LogDebugUndoProgress(inverseIndex, maxNumRefs)
        EndIf

        currObjRef = currPlayerCell.GetNthRef(refIndex, 34)
        currObjBase = currObjRef.GetBaseObject()
        currObjBaseID = currObjBase.GetFormID()
        If currObjBaseID == STAT_UNDO_ID
            currObjRef.Delete()
            numDeleted += 1
        EndIf

        refIndex -= 1
        inverseIndex += 1
    EndWhile

    currPlayerCell = None
    currObjBase = None
    currObjRef = None

    If numDeleted > 0
        Debug.MessageBox(numDeleted + " orphaned Jaxonz object(s) were deleted from this cell. " \
                + "Saving this cell will be slightly faster in the future as a result. " \
                + "Also, your save file size should now be a bit smaller." \
                + "\n\nPlease MAKE A FULL SAVE, then QUIT AND RESTART your game. " \
                + "This step is NECESSARY to ensure that the objects are properly removed!")
    Else
        Debug.MessageBox("No orphaned objects were detected in this cell, " \
                + "so nothing had to be removed. This can occur if you try to clear a cell " \
                + "multiple times or if Jaxonz was never used in this cell." \
                + "\n\nYou can continue playing the game normally.")
    EndIf
EndFunction



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SALCJE UTILITY FUNCTIONS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Saves the given cell reference, if possible.                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
bool Function SaveRef(string cellFile)
    currObjBase = currObjRef.GetBaseObject()

    int objType = currObjBase.GetType()
    If objType >= 0 && objType < 128
        If !mcmAllowedObjTypes[objType]
            Return False
        EndIf
    EndIf

    currObjType = LZStringUtil.GetPlaceableTypeTag(objType)
    If StringUtil.GetLength(currObjType) == 0
        Return False
    EndIf

    currObjBaseID = currObjBase.GetFormID()
    If currObjBaseID == ACT_NO_DRIFT_ID || currObjBaseID == ACT_GRAB_ID \
            || currObjBaseID == MISC_GRAB_ID || currObjBaseID == STAT_UNDO_ID \
            || currObjBaseID == LIGHT_ID
        If currObjBaseID == STAT_UNDO_ID && mcmToggleValues[mcmOptClearMarkers]
            currObjRef.Delete()
        EndIf
        Return False
    EndIf

    currObjRefID = currObjRef.GetFormID()
    currObjCustom = LZStringUtil.IsCustomObjectDec(currObjRefID)
    If currObjCustom
        currObjDeleted = currObjRef.IsDeleted()
        If currObjDeleted
            Return False
        EndIf

        currObjDisabled = currObjRef.IsDisabled()
        If currObjDisabled
            Return False
        EndIf
    Else
        currObjDeleted = currObjRef.IsDeleted()
        currObjDisabled = currObjRef.IsDisabled()
    EndIf

    If currObjCustom
        currObjRefID = currObjBaseID
    EndIf

    objToLine = currObjType + "`" \
            + objType + "`" \
            + LZStringUtil.GetLoadIndependentFormDec(currObjRefID) + "`" \
            + (currObjCustom as int) + "`" \
            + (currObjDeleted as int) + "`" \
            + (currObjDisabled as int) + "`" \
            + currObjRef.X + "`" \
            + currObjRef.Y + "`" \
            + currObjRef.Z + "`" \
            + currObjRef.GetAngleX() + "`" \
            + currObjRef.GetAngleY() + "`" \
            + currObjRef.GetAngleZ() + "`" \
            + currObjRef.GetScale()

    Return LZIOUtil.WriteLine(cellFile, objToLine)
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Places a new object in the current cell.                                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
int Function PlaceNewObj(string baseID, string type, string x, string y, string z, \
        string angX, string angY, string angZ, string scale, int baseIDOverride)
    If !mcmAllowedObjTypes[type as int]
        Return 0
    EndIf

    If baseIDOverride != 0
        currObjBaseID = baseIDOverride
    Else
        currObjBaseID = LZStringUtil.ResolveLoadIndependentForm(baseID)
    EndIf

    If currObjBaseID == 0
        Return 0
    EndIf

    currObjX = x as float
    currObjY = y as float
    currObjZ = z as float
    currObjAngX = angX as float
    currObjAngY = angY as float
    currObjAngZ = angZ as float
    currObjScale = scale as float

    currObjRef = Game.GetPlayer().PlaceAtMe(Game.GetFormEx(currObjBaseID), 1, True, False)
    If currObjRef == None
        Return 0
    EndIf

    JaxonzEnhGrabNoDriftMarkerScript objNoDriftMarker = currObjRef.PlaceAtMe(actNoDriftMarker, \
            1, true, false) as JaxonzEnhGrabNoDriftMarkerScript

    currObjRef.SetMotionType(MOTION_STATIC)
    While !currObjRef.Is3dLoaded()
    EndWhile

    currObjRef.SetMotionType(MOTION_STATIC)
    Utility.WaitMenuMode(0.1) ; necessary because motion type is latent
    currObjRef.SetScale(currObjScale)
    currObjRef.TranslateTo(currObjX, currObjY, currObjZ, currObjAngX, currObjAngY, currObjAngZ, \
            TRANSLATE_FAST)
    Utility.WaitMenuMode(0.1) ; prevent crash from ultra-fast simulation

    objNoDriftMarker.objPositioned = currObjRef
    objNoDriftMarker.TranslateTo(currObjX, currObjY, currObjZ, 0, 0, 0, 10000)

    Return 1
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Enables, disables, deletes, or otherwise alters an object already in the current cell.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
int Function AssertObjState(string refID, string type, string isDeleted, string isDisabled, \
        string x, string y, string z, string angX, string angY, string angZ, string scale)
    If !mcmAllowedObjTypes[type as int]
        Return 0
    EndIf

    currObjRefID = LZStringUtil.ResolveLoadIndependentForm(refID)
    If currObjRefID == 0
        Return 0
    EndIf

    Form f = Game.GetFormEx(currObjRefID)
    If f == None
        Return 0
    EndIf

    currObjRef = f as ObjectReference
    bool currObjExists = (currObjRef.GetParentCell() == currPlayerCell)

    If isDeleted == "1"
        If currObjExists
            currObjRef.Delete()
            Return 1
        Else
            Return 0
        EndIf
    EndIf

    If isDisabled == "1"
        If currObjExists
            currObjRef.Disable()
            Return 1
        Else
            Return 0
        EndIf
    EndIf

    If !currObjExists
        Return PlaceNewObj(refID, type, x, y, z, angX, angY, angZ, scale, \
                currObjRef.GetBaseObject().GetFormID())
    EndIf

    currObjX = x as float
    currObjY = y as float
    currObjZ = z as float
    currObjAngX = angX as float
    currObjAngY = angY as float
    currObjAngZ = angZ as float
    currObjScale = scale as float


    currObjRef.SetMotionType(MOTION_STATIC)
    JaxonzEnhGrabNoDriftMarkerScript objNoDriftMarker = currObjRef.PlaceAtMe(actNoDriftMarker, \
            1, true, false) as JaxonzEnhGrabNoDriftMarkerScript

    If currObjRef.IsDisabled()
        currObjRef.Enable()

        int numIters = 0
        While !currObjRef.Is3dLoaded() && numIters < MAX_REF_ITERS
            Utility.WaitMenuMode(0.25)
            numIters += 1
        EndWhile

        If !currObjRef.Is3dLoaded()
            Return 0
        EndIf

        currObjRef.SetMotionType(MOTION_STATIC)
    EndIf

    Utility.WaitMenuMode(0.1) ; necessary because motion type is latent
    currObjRef.SetScale(currObjScale)
    currObjRef.TranslateTo(currObjX, currObjY, currObjZ, currObjAngX, currObjAngY, currObjAngZ, \
            TRANSLATE_FAST)

    objNoDriftMarker.objPositioned = currObjRef
    objNoDriftMarker.TranslateTo(currObjX, currObjY, currObjZ, 0, 0, 0, TRANSLATE_FAST)

    Return 1
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Obtains the save file location for the given cell.                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
string Function GetCellFile(Cell currCell)
    Return ROOT_DIR + LZStringUtil.GetLoadIndependentFormDec(currCell.GetFormID()) + ".txt"
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Gets a simple name representation for the player's current cell, for display in MCM.        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
string Function GetCellFileSimple()
    Return LZStringUtil.GetLoadIndependentFormDec(Game.GetPlayer().GetParentCell().GetFormID())
EndFunction
