Scriptname MakeReanimatedPlayerHated extends ActiveMagicEffect

{Scripted effect for on death ash pile}

import debug
import FormList

;======================================================================================;
;  PROPERTIES  /
;=============/

Faction Property NecromancyHateFaction Auto
;float property fDelay = 0.75 auto
									{time to wait before Spawning Ash Pile}
float property fDelayEnd = 1.65 auto
									{time to wait before Removing Base Actor}

Faction Property NecromancyHateFactionSecondCreature Auto

Faction Property NecromancyHateFactionThirdCreature Auto

Activator property AshPileObject auto
									{The object we use as a pile.}
;EffectShader property MagicEffectShader auto

Faction Property VampirePCFaction Auto

Bool property bSetAlphaZero = True auto
									{The Effect Shader we want.}
FormList Property HateFactionsList auto
									{If the target is in this list, they will not be disintegrated.}
Bool property bSetAlphaToZeroEarly = False Auto
									{Use this if we want to set the acro to invisible somewhere before the effect shader is done.}
Keyword Property ActorTypeDaedra  Auto

Keyword Property ActorTypeFamiliar  Auto

bool Property AshPileCreated  Auto


;======================================================================================;
;  VARIABLES   /
;=============/


actor Victim
race VictimRace
bool TargetIsImmune = False

;=============
;   FUNCTIONS /
;=============

bool function IsSummoned()
	if Victim.HasKeyword(ActorTypeFamiliar) || Victim.HasKeyword(ActorTypeDaedra)
		return true
	else
		return false
	endIf
endFunction

bool function TurnToAsh()
endFunction

;======================================================================================;
;   EVENTS     /
;=============/

Event OnEffectStart(Actor Target, Actor Caster)
	victim = target

	if Victim.IsCommandedActor() == True && IsSummoned() == False
		TargetIsImmune = False

        if Game.GetPlayer().GetFactionRank(NecromancyHateFaction) < 0
            victim.SetFactionRank(NecromancyHateFaction, 1)
            Game.GetPlayer().SetFactionRank(NecromancyHateFaction, 1)
        elseif Game.GetPlayer().GetFactionRank(NecromancyHateFactionSecondCreature) < 0
            victim.SetFactionRank(NecromancyHateFactionSecondCreature, 1)
            Game.GetPlayer().SetFactionRank(NecromancyHateFactionSecondCreature, 1)
        elseif Game.GetPlayer().GetFactionRank(NecromancyHateFactionThirdCreature) < 0
            victim.SetFactionRank(NecromancyHateFactionThirdCreature, 1)
            Game.GetPlayer().SetFactionRank(NecromancyHateFactionThirdCreature, 1)
        endif
        victim.SetAttackActorOnSight()
        Game.GetPlayer().SetAttackActorOnSight()

        int cfIndex = 0
        while (cfIndex < HateFactionsList.GetSize())
            (HateFactionsList.GetAt(cfIndex) as Faction).SetPlayerEnemy()
            cfIndex += 1
        endwhile
	else
		TargetIsImmune = True
	endIf
EndEvent


Event OnDying(Actor Killer)
	if TargetIsImmune == False
        if Game.GetPlayer().GetFactionRank(NecromancyHateFaction) >= 0
            Victim.RemoveFromFaction(NecromancyHateFaction)
            Game.GetPlayer().RemoveFromFaction(NecromancyHateFaction)
        elseif Game.GetPlayer().GetFactionRank(NecromancyHateFactionSecondCreature) >= 0
            Victim.RemoveFromFaction(NecromancyHateFactionSecondCreature)
            Game.GetPlayer().RemoveFromFaction(NecromancyHateFactionSecondCreature)
        elseif Game.GetPlayer().GetFactionRank(NecromancyHateFactionThirdCreature) >= 0
            Victim.RemoveFromFaction(NecromancyHateFactionThirdCreature)
            Game.GetPlayer().RemoveFromFaction(NecromancyHateFactionThirdCreature)
        endif

        Victim.SetAttackActorOnSight(false)
        if Game.GetPlayer().GetFactionRank(VampirePCFaction) < 0 && Game.GetPlayer().GetFactionRank(NecromancyHateFaction) < 0 && Game.GetPlayer().GetFactionRank(NecromancyHateFactionSecondCreature) < 0 && Game.GetPlayer().GetFactionRank(NecromancyHateFactionThirdCreature) < 0
            Game.GetPlayer().SetAttackActorOnSight(false)

            int cfIndex = 0
            while (cfIndex < HateFactionsList.GetSize())
                (HateFactionsList.GetAt(cfIndex) as Faction).SetPlayerEnemy(false)
                cfIndex += 1
            endwhile
        endif
	endif
EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)
	if TargetIsImmune == False
        if Game.GetPlayer().GetFactionRank(NecromancyHateFaction) >= 0
            Victim.RemoveFromFaction(NecromancyHateFaction)
            Game.GetPlayer().RemoveFromFaction(NecromancyHateFaction)
        elseif Game.GetPlayer().GetFactionRank(NecromancyHateFactionSecondCreature) >= 0
            Victim.RemoveFromFaction(NecromancyHateFactionSecondCreature)
            Game.GetPlayer().RemoveFromFaction(NecromancyHateFactionSecondCreature)
        elseif Game.GetPlayer().GetFactionRank(NecromancyHateFactionThirdCreature) >= 0
            Victim.RemoveFromFaction(NecromancyHateFactionThirdCreature)
            Game.GetPlayer().RemoveFromFaction(NecromancyHateFactionThirdCreature)
        endif

        Victim.SetAttackActorOnSight(false)
        if Game.GetPlayer().GetFactionRank(VampirePCFaction) < 0 && Game.GetPlayer().GetFactionRank(NecromancyHateFaction) < 0 && Game.GetPlayer().GetFactionRank(NecromancyHateFactionSecondCreature) < 0 && Game.GetPlayer().GetFactionRank(NecromancyHateFactionThirdCreature) < 0
            Game.GetPlayer().SetAttackActorOnSight(false)

            int cfIndex = 0
            while (cfIndex < HateFactionsList.GetSize())
                (HateFactionsList.GetAt(cfIndex) as Faction).SetPlayerEnemy(false)
                cfIndex += 1
            endwhile
        endif
	endif
EndEvent

