;BEGIN FRAGMENT CODE - Do not edit anything between this and the end comment
;NEXT FRAGMENT INDEX 8
Scriptname LZTB_addBooksNoRead Extends Perk Hidden

;BEGIN FRAGMENT Fragment_7
Function Fragment_7(ObjectReference akTargetRef, Actor akActor)
;BEGIN CODE

    Book theBook = (akTargetRef.GetBaseObject() as Book)

    If theBook != None && EnablePickup.GetValue() == 1
        If theBook.IsTakeable()
            If !(DisableIfRead.GetValue() == 1 && theBook.IsRead())
                ;;; LZ: the below is only necessary if AddItem is called with True
                ;;; i.e. if you don't want the notification in top-left when the book is added
                ;;;
                ;;; bool playedSound = false
                ;;; int index = PickupSounds.GetSize()
                ;;; While index
                ;;;     index -=1
                ;;;     Sound aSound = (PickupSounds.GetAt(index) As Sound)
                ;;;     If aSound.GetDescriptor() == LZPapyrusFunc.GetBookSoundUp(theBook)
                ;;;         aSound.Play(akTargetRef)
                ;;;         index = 0
                ;;;         playedSound = true
                ;;;     EndIf
                ;;; EndWhile
                ;;; If !playedSound
                ;;;     (PickupSounds.GetAt(0) as Sound).Play(akTargetRef)
                ;;; EndIf

                bool requiresSteal = akTargetRef.IsOffLimits()
                If !requiresSteal || akActor.IsSneaking() || AllowStealingWithoutSneak.GetValue() == 1

                    ;;; LZ: important for bookshelves to ensure nearby book physics are recalculated
                    akTargetRef.ApplyHavokImpulse(0.100000, 0 as Float, 0 as Float, 0.100000)

                    PlayerRef.AddItem(akTargetRef as Form, 1, false)
                    If requiresSteal
                        akTargetRef.SendStealAlarm(PlayerRef)
                        Game.IncrementStat("Items Stolen", 1)
                    EndIf

                    Return
                EndIf
            EndIf
        EndIf
    EndIf

    akTargetRef.Activate(akActor as ObjectReference, true)

;END CODE
EndFunction
;END FRAGMENT

;END FRAGMENT CODE - Do not edit anything between this and the begin comment

Actor Property PlayerRef Auto
;;;FormList Property PickupSounds Auto
GlobalVariable Property AllowStealingWithoutSneak Auto
GlobalVariable Property EnablePickup Auto
GlobalVariable Property DisableIfRead Auto
