﻿ScriptName LZDOCEffectUninstall extends ActiveMagicEffect

Armor Property ArmorOfForcibleOutfitChanges Auto
Spell Property splChangeOutfit Auto
Spell Property splChangeOutfitNonPermanent Auto
Spell Property splExportOutfits Auto
Spell Property splImportOutfits Auto
Spell Property splResetOutfit Auto
Spell Property splResetAllOutfits Auto
Spell Property splResetOutfitConsole Auto
Spell Property splUninstall Auto

;;; Completely uninstalls the mod. ;;;
Event OnEffectStart(Actor akTarget, Actor akCaster)
    Game.GetPlayer().RemoveSpell(splChangeOutfit)
    ;Game.GetPlayer().RemoveSpell(splChangeOutfitNonPermanent)
    Game.GetPlayer().RemoveSpell(splExportOutfits)
    Game.GetPlayer().RemoveSpell(splImportOutfits)
    Game.GetPlayer().RemoveSpell(splResetOutfit)
    Game.GetPlayer().RemoveSpell(splResetAllOutfits)
    Game.GetPlayer().RemoveSpell(splResetOutfitConsole)
    Game.GetPlayer().RemoveSpell(splUninstall)
    ResetAllOutfits()

    StorageUtil.StringListClear(None, "LZDOC_ActorRegistrations")
    StorageUtil.StringListClear(None, "LZDOC_NextOutfitStack")

    Debug.Notification("LZDOC uninstalled; you may now deactivate/remove the mod.")
EndEvent

;;; Resets all outfits in preparation for loading. ;;;
Function ResetAllOutfits()
    int numOutfits = StorageUtil.StringListCount(None, "LZDOC_ActorRegistrations")
    If numOutfits == 0
        Return
    EndIf


    int index = numOutfits
    While index
        index -= 1
        string formID = StorageUtil.StringListGet(None, "LZDOC_ActorRegistrations", index)
        Outfit currOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Custom") as Outfit)
        Outfit destOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Default") as Outfit)

        If currOutfit != None
            LeveledItem currOutfitList = (currOutfit.GetNthPart(0) as LeveledItem)
            currOutfitList.Revert()
            StorageUtil.FormListAdd(None, "LZDOC_NextOutfitStack", currOutfit) ; allow reuse of slot
        EndIf
        StorageUtil.UnsetFormValue(None, "LZDOC`" + formID + "`Custom")
        StorageUtil.UnsetFormValue(None, "LZDOC`" + formID + "`Default")

        Actor toReset = Game.GetFormEx(LZStringUtil.ResolveLoadIndependentForm(formID)) as Actor
        toReset.SetOutfit(destOutfit)
        toReset.AddItem(ArmorOfForcibleOutfitChanges, 1, True)
        Utility.Wait(0.1)
        toReset.RemoveItem(ArmorOfForcibleOutfitChanges, 1, True)

        If index % 15 == 0
            Debug.Notification("Uninstall Progress: " \
                    + ((numOutfits - index) * 100.0 / numOutfits) + "%")
        EndIf
    EndWhile


    StorageUtil.StringListClear(None, "LZDOC_ActorRegistrations")
    Debug.Notification("All existing custom outfits have been removed.")

    ;;; For regular NPCs, changing outfits and adding "0" of an arbitrary item are enough to force
    ;;; an outfit re-evaluation. However, many followers in particular will only recognize outfit
    ;;; changes when new items are *added* to the outfit (but not when existing items are removed).
    ;;; By adding an armor piece with overwhelming value and armor rating, followers are tricked
    ;;; into equipping that item, and then will revert back to their (new) outfit when the item has
    ;;; been removed.
EndFunction
