﻿ScriptName LZDOCEffectResetOutfit extends ActiveMagicEffect

Keyword Property ActorTypeNPC Auto
Armor Property ArmorOfForcibleOutfitChanges Auto

;;; Resets the outfit of the target to its default settings. ;;;
Event OnEffectStart(Actor akTarget, Actor akCaster)
    If !akTarget.GetRace().HasKeyword(ActorTypeNPC)
        Debug.Notification("That NPC does not have a changeable outfit.")
        Return
    EndIf

    string formID = LZStringUtil.GetLoadIndependentFormDec(akTarget.GetFormID())
    If !StorageUtil.StringListHas(None, "LZDOC_ActorRegistrations", formID)
        Debug.Notification("There is no custom outfit assigned to that NPC.")
        Return
    EndIf


    Outfit currOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Custom") as Outfit)
    Outfit destOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Default") as Outfit)

    If currOutfit != None
        LeveledItem currOutfitList = (currOutfit.GetNthPart(0) as LeveledItem)
        currOutfitList.Revert()
        StorageUtil.FormListAdd(None, "LZDOC_NextOutfitStack", currOutfit) ; allow reuse of slot
    EndIf
    StorageUtil.UnsetFormValue(None, "LZDOC`" + formID + "`Custom")
    StorageUtil.UnsetFormValue(None, "LZDOC`" + formID + "`Default")
    StorageUtil.StringListRemove(None, "LZDOC_ActorRegistrations", formID)


    akTarget.SetOutfit(destOutfit)
    akTarget.AddItem(ArmorOfForcibleOutfitChanges, 1, True)
    Utility.Wait(0.1)
    akTarget.RemoveItem(ArmorOfForcibleOutfitChanges, 1, True)

    ;;; For regular NPCs, changing outfits and adding "0" of an arbitrary item are enough to force
    ;;; an outfit re-evaluation. However, many followers in particular will only recognize outfit
    ;;; changes when new items are *added* to the outfit (but not when existing items are removed).
    ;;; By adding an armor piece with overwhelming value and armor rating, followers are tricked
    ;;; into equipping that item, and then will revert back to their (new) outfit when the item has
    ;;; been removed.
EndEvent
