﻿ScriptName LZDOCEffectExportCustomOutfits extends ActiveMagicEffect

;;;
;;; EXPORTED STRUCTURE (each item on a separate line)
;;; Do not add unneeded whitespace within any line, or whitespace between lines.
;;; All forms must follow the structure XXXXXX_PluginName.esm or XXXXXX_PluginName.esp,
;;;     where XXXXXX is the form ID of that NPC/item, excluding load order.
;;; The plugin name must correspond to the ESP/ESM in which the form was originally defined,
;;;     and must match case/spelling exactly.
;;; Load order of plugins does NOT matter!
;;;
;;;     <number of customized NPCs>
;;;     <npc form ID #1>
;;;         <npc #1 custom outfit ID>
;;;         <npc #1 default (vanilla) outfit ID>
;;;         <number of items in custom outfit>
;;;             <item form ID #1>
;;;             <item form ID #2>
;;;             ...
;;;             <item form ID #N>
;;;
;;;     <npc form ID #2>
;;;         <npc #2 custom outfit ID>
;;;         ...
;;;
;;;     ...
;;;
;;;     <npc form ID #N>
;;;         ...
;;;

;;; Exports all outfits to an external file. ;;;
Event OnEffectStart(Actor akTarget, Actor akCaster)
    int numOutfits = StorageUtil.StringListCount(None, "LZDOC_ActorRegistrations")
    If numOutfits == 0
        Debug.Notification("There are no custom outfits that can be exported.")
        Return
    EndIf

    string outputFile = "lzDefaultOutfitChanger/customOutfits.txt"
    If !LZIOUtil.LoadFile(outputFile, false, false, 100)
        Debug.Notification("Could not open export file.")
        Return
    EndIf


    LZIOUtil.WriteLine(outputFile, numOutfits)
    int index = numOutfits
    While index
        index -= 1
        ExportOutfit(outputFile, index)

        If index % 15 == 0
            Debug.Notification("Progress: " + ((numOutfits - index) * 100.0 / numOutfits) + "%")
        EndIf
    EndWhile


    If !LZIOUtil.CloseFile(outputFile)
        Debug.Notification("Could not close export file.")
    Else
        Debug.Notification("Custom outfits exported successfully!")
    EndIf
EndEvent

;;; Exports a single custom outfit. ;;;
Function ExportOutfit(string outputFile, int index)
    string formID = StorageUtil.StringListGet(None, "LZDOC_ActorRegistrations", index)
    Outfit currOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Custom") as Outfit)
    Outfit oldOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Default") as Outfit)

    LeveledItem currOutfitList = (currOutfit.GetNthPart(0) as LeveledItem)
    int numItems = currOutfitList.GetNumForms()

    LZIOUtil.WriteLine(outputFile, formID)
    LZIOUtil.WriteLine(outputFile, LZStringUtil.GetLoadIndependentFormDec(currOutfit.GetFormID()))
    LZIOUtil.WriteLine(outputFile, LZStringUtil.GetLoadIndependentFormDec(oldOutfit.GetFormID()))
    LZIOUtil.WriteLine(outputFile, numItems)

    int itemIndex = numItems
    While itemIndex
        itemIndex -= 1

        Form outfitItem = currOutfitList.GetNthForm(itemIndex)
        LZIOUtil.WriteLine(outputFile, \
                LZStringUtil.GetLoadIndependentFormDec(outfitItem.GetFormID()))
    EndWhile
EndFunction
