﻿ScriptName LZDOCEffectChangeOutfit extends ActiveMagicEffect

Keyword Property ActorTypeNPC Auto
GlobalVariable Property AllowNonUniqueNPC Auto
Armor Property ArmorOfForcibleOutfitChanges Auto
FormList Property ContainerItemList Auto
ObjectReference Property OutfitContainer Auto
Outfit Property TempOutfit Auto

;;; Allows the player to customize the target's outfit, backing up the default outfit first. ;;;
Event OnEffectStart(Actor akTarget, Actor akCaster)
    If !akTarget.GetRace().HasKeyword(ActorTypeNPC)
        Debug.Notification("That NPC does not have a changeable outfit.")
        Return
    EndIf

    ActorBase akBase = akTarget.GetActorBase()
    If !akBase.IsUnique() && AllowNonUniqueNPC.GetValue() == 0
        Debug.Notification("You cannot change the outfits of non-unique NPCs.")
        Return
    EndIf


    string formID = LZStringUtil.GetLoadIndependentFormDec(akTarget.GetFormID())
    Outfit currOutfit = None
    Outfit destOutfit = None
    LeveledItem outfitList = None
    bool isNewOutfit = False

    ;;; CASE 1: actor was previously customized; use stored outfit values ;;;
    If StorageUtil.StringListHas(None, "LZDOC_ActorRegistrations", formID)
        currOutfit = (StorageUtil.GetFormValue(None, "LZDOC`" + formID + "`Custom") as Outfit)
        destOutfit = currOutfit
        outfitList = (currOutfit.GetNthPart(0) as LeveledItem)
        isNewOutfit = False

    ;;; CASE 2: no outfit slots available ;;;
    ElseIf StorageUtil.FormListCount(None, "LZDOC_NextOutfitStack") == 0
        Debug.Notification("No free outfit slots available; " \
                + "you must remove at least one outfit first.")
        Return

    ;;; CASE 3: obtain next outfit slot and store outfit values ;;;
    Else
        currOutfit = akBase.GetOutfit()
        destOutfit = (StorageUtil.FormListPop(None, "LZDOC_NextOutfitStack") as Outfit)
        outfitList = (destOutfit.GetNthPart(0) as LeveledItem)

        StorageUtil.SetFormValue(None, "LZDOC`" + formID + "`Default", currOutfit)
        StorageUtil.SetFormValue(None, "LZDOC`" + formID + "`Custom", destOutfit)
        StorageUtil.StringListAdd(None, "LZDOC_ActorRegistrations", formID)
        isNewOutfit = True
    EndIf


    OutfitContainer.RemoveAllItems()
    If isNewOutfit
        AddContainerFromOutfit(currOutfit)
    Else
        AddContainerFromLeveledItem(outfitList)
    EndIf
    OutfitContainer.Activate(Game.GetPlayer()) ; allows player to add/remove outfit items
    Utility.Wait(0.1)


    CreateOutfit(akTarget, outfitList, destOutfit)
EndEvent

;;; Populates the custom outfit container with the target's current outfit, if possible. ;;;
Function AddContainerFromOutfit(Outfit outfitToAdd)
    int numParts = outfitToAdd.GetNumParts()

    While numParts
        numParts -= 1

        Form currItem = outfitToAdd.GetNthPart(numParts)
        If currItem as Armor != None ; leveled items cannot be added
            OutfitContainer.AddItem(currItem, 1, True)
        EndIf
    EndWhile
EndFunction

;;; Populates the custom outfit container with the target's current custom outfit. ;;;
Function AddContainerFromLeveledItem(LeveledItem outfitList)
    int size = outfitList.GetNumForms()

    While size
        size -= 1

        Form currItem = outfitList.GetNthForm(size)
        If currItem as Armor != None
            OutfitContainer.AddItem(currItem, 1, True)
        EndIf
    EndWhile
EndFunction

;;; Populates the given outfit and assigns it to the provided actor. ;;;
Function CreateOutfit(Actor dest, LeveledItem outfitList, Outfit destOutfit)
    dest.SetOutfit(TempOutfit) ; temporary naked outfit
    outfitList.Revert()

    int numItems = ContainerItemList.GetSize()
    While numItems
        numItems -=1

        Form currItem = ContainerItemList.GetAt(numItems)
        outfitList.AddForm(currItem, 1, 1)
    EndWhile

    dest.SetOutfit(destOutfit)
    dest.AddItem(ArmorOfForcibleOutfitChanges, 1, True)
    Utility.Wait(0.1)
    dest.RemoveItem(ArmorOfForcibleOutfitChanges, 1, True)

    ;;; For regular NPCs, changing outfits and adding "0" of an arbitrary item are enough to force
    ;;; an outfit re-evaluation. However, many followers in particular will only recognize outfit
    ;;; changes when new items are *added* to the outfit (but not when existing items are removed).
    ;;; By adding an armor piece with overwhelming value and armor rating, followers are tricked
    ;;; into equipping that item, and then will revert back to their (new) outfit when the item has
    ;;; been removed.
EndFunction
