﻿ScriptName LZDOCContainerScript extends ObjectReference

FormList Property ContainerItemList  Auto

;;; Ensures that only armor, clothing, jewelry, and accessories can be added to an outfit. ;;;
Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, \
        ObjectReference akSourceContainer)
	If akBaseItem as Armor != None
		ContainerItemList.AddForm(akBaseItem)
	Else
		RemoveItem(akBaseItem, aiItemCount, True, akSourceContainer)
		Debug.Notification("You cannot place that in an outfit.")
	EndIf
EndEvent

;;; Removing an item from the container removes it from the destination outfit as well. ;;;
Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, \
        ObjectReference akDestContainer)
	If self.GetItemCount(akBaseItem) == 0
		ContainerItemList.RemoveAddedForm(akBaseItem)
	EndIf
EndEvent
