;BEGIN FRAGMENT CODE - Do not edit anything between this and the end comment
;NEXT FRAGMENT INDEX 10
Scriptname QF_MGR20B_000BC096 Extends Quest Hidden

;BEGIN ALIAS PROPERTY HoldingChest
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_HoldingChest Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY Book
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_Book Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY QuestGiver
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_QuestGiver Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY Note
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_Note Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY BookLocation
;ALIAS PROPERTY TYPE LocationAlias
LocationAlias Property Alias_BookLocation Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY BookContainer
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_BookContainer Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY LocationMapMarker
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_LocationMapMarker Auto
;END ALIAS PROPERTY

;BEGIN FRAGMENT Fragment_4
Function Fragment_4()
;BEGIN CODE
SetObjectiveCompleted(20,1)
Alias_Questgiver.GetActorReference().ModFavorPoints(FavorRewardSmall.GetValueInt())
Game.GetPlayer().Removeitem(Alias_Note.GetReference(),1)
Game.GetPlayer().Removeitem(MGR20Book,1)
Game.GetPlayer().AddItem(Gold001, ((Alias_Book.GetReference().GetGoldValue() * 1.2) as int))
(MGRShell as MGRShellScript).StartUragQuest()
(MGRShell as MGRShellScript).pMGR20Done = 1
pMGRMasterTotal.Value += 1
Game.IncrementStat("College of Winterhold Quests Completed", 1)

int currQuests = -1
float skillDivisor = 1.0
String rankID = ""
if (!Quest.GetQuest("MG03").IsCompleted())
	currQuests = 5
	if (Quest.GetQuest("C04").IsCompleted() || Quest.GetQuest("TG07").IsCompleted())
		currQuests = 30
	elseif (Quest.GetQuest("C03").IsCompleted() || Quest.GetQuest("TG05").IsCompleted())
		currQuests = 20
	elseif (Quest.GetQuest("C01").IsCompleted() || Quest.GetQuest("TG03").IsCompleted())
		currQuests = 10
	endif
	skillDivisor = 35.0
	rankID = "I"
elseif (!Quest.GetQuest("MG04").IsCompleted())
	currQuests = 15
	if (Quest.GetQuest("C04").IsCompleted() || Quest.GetQuest("TG07").IsCompleted())
		currQuests = 70
	elseif (Quest.GetQuest("C03").IsCompleted() || Quest.GetQuest("TG05").IsCompleted())
		currQuests = 40
	elseif (Quest.GetQuest("C01").IsCompleted() || Quest.GetQuest("TG03").IsCompleted())
		currQuests = 30
	endif
	skillDivisor = 60.0
	rankID = "II"
elseif (!Quest.GetQuest("mg06").IsCompleted())
	currQuests = 40
	if (Quest.GetQuest("C04").IsCompleted() || Quest.GetQuest("TG07").IsCompleted())
		currQuests = 145
	elseif (Quest.GetQuest("C03").IsCompleted() || Quest.GetQuest("TG05").IsCompleted())
		currQuests = 90
	elseif (Quest.GetQuest("C01").IsCompleted() || Quest.GetQuest("TG03").IsCompleted())
		currQuests = 80
	endif
	skillDivisor = 90.0
	rankID = "III"
endif

if (currQuests > 0)
	int loyaltyProgress = (100.0 * (pMGRMasterTotal.Value as float) / (currQuests as float)) as int
	float skill1 = Game.GetPlayer().GetBaseActorValue("Destruction") as float
	float skill2 = Game.GetPlayer().GetBaseActorValue("Illusion") as float
	float skill3 = Game.GetPlayer().GetBaseActorValue("Conjuration") as float
	float skill4 = Game.GetPlayer().GetBaseActorValue("Alteration") as float
	float skill5 = Game.GetPlayer().GetBaseActorValue("Restoration") as float
	float maxSkill12 = (skill1 + skill2 + math.abs(skill1 - skill2)) / 2
	float maxSkill23 = (skill3 + maxSkill12 + math.abs(skill3 - maxSkill12)) / 2
	float maxSkill34 = (skill4 + maxSkill23 + math.abs(skill4 - maxSkill23)) / 2
	float maxSkill = (skill5 + maxSkill34 + math.abs(skill5 - maxSkill34)) / 2
	int skillProgress = (100.0 * maxSkill / skillDivisor) as int
	if (loyaltyProgress >= 100 && skillProgress >= 100)
		Debug.Notification("College Rank " + rankID + " Achieved!")
	else
		Debug.Notification("Quests to Next Rank: " + loyaltyProgress + "%")
		Debug.Notification("Skill to Next Rank: " + skillProgress + "%")
	endif
endif

Stop()
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_6
Function Fragment_6()
;BEGIN CODE
MGR20Book = Alias_Book.GetReference().GetBaseObject() as book
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_2
Function Fragment_2()
;BEGIN CODE
SetObjectiveCompleted(10,1)
SetObjectiveDisplayed(20,1)
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_0
Function Fragment_0()
;BEGIN CODE
; Updated by USKP so player can turn in book if already has it
SetObjectiveDisplayed(10,1)
if (Game.GetPlayer().GetItemCount(MGR20Book) == 0)
	Game.GetPlayer().Additem(Alias_Note.GetReference(),1)
	Alias_LocationMapMarker.GetReference().AddtoMap()
    Alias_BookContainer.GetReference().AddItem(Alias_Book.GetReference())
else
	SetStage(20)
endif
;END CODE
EndFunction
;END FRAGMENT

;END FRAGMENT CODE - Do not edit anything between this and the begin comment

Quest Property MGRShell  Auto

Book Property MGR20Book  Auto

ReferenceAlias Property pMGR20Note  Auto

GlobalVariable Property FavorRewardSmall  Auto

int Property GoldReward  Auto

miscobject Property Gold001  Auto

GlobalVariable Property pMGRMasterTotal  Auto
