;BEGIN FRAGMENT CODE - Do not edit anything between this and the end comment
;NEXT FRAGMENT INDEX 10
Scriptname QF_TGRNT_00060990 Extends Quest Hidden

;BEGIN ALIAS PROPERTY Player
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_Player Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY City
;ALIAS PROPERTY TYPE locationalias
locationalias Property Alias_City Auto
;END ALIAS PROPERTY

;BEGIN ALIAS PROPERTY Delvin
;ALIAS PROPERTY TYPE ReferenceAlias
ReferenceAlias Property Alias_Delvin Auto
;END ALIAS PROPERTY

;BEGIN FRAGMENT Fragment_2
Function Fragment_2()
;BEGIN AUTOCAST TYPE TGRNTQuestScript
Quest __temp = self as Quest
TGRNTQuestScript kmyQuest = __temp as TGRNTQuestScript
;END AUTOCAST
;BEGIN CODE
;Quest Target Done - Return to Delvin
SetObjectiveCompleted (10,1)
SetObjectiveDisplayed(20,1)
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_4
Function Fragment_4()
;BEGIN AUTOCAST TYPE TGRNTQuestScript
Quest __temp = self as Quest
TGRNTQuestScript kmyQuest = __temp as TGRNTQuestScript
;END AUTOCAST
;BEGIN CODE
;Finished Quest Without Fail Condition
CompleteAllObjectives()
Game.GetPlayer().AddItem(pReward,1)
pTGRMasterTotal.Value += 1
pTGREHQS.CheckCount()
pTGRShellScript.TGRadiantCount(Alias_City.GetLocation())

pQuestTrackerTGRNT.SetValue(1) ; indicate that this quest has been completed at least once

int currQuests = -1
float skillDivisor = 1.0
String rankID = ""
if (!Quest.GetQuest("TG03").IsCompleted())
	currQuests = 5
	if (Quest.GetQuest("C04").IsCompleted() || Quest.GetQuest("mg06").IsCompleted())
		currQuests = 30
	elseif (Quest.GetQuest("C03").IsCompleted() || Quest.GetQuest("MG04").IsCompleted())
		currQuests = 20
	elseif (Quest.GetQuest("C01").IsCompleted() || Quest.GetQuest("MG03").IsCompleted())
		currQuests = 10
	endif
	skillDivisor = 35.0
	rankID = "I"
elseif (!Quest.GetQuest("TG05").IsCompleted())
	currQuests = 15
	if (Quest.GetQuest("C04").IsCompleted() || Quest.GetQuest("mg06").IsCompleted())
		currQuests = 70
	elseif (Quest.GetQuest("C03").IsCompleted() || Quest.GetQuest("MG04").IsCompleted())
		currQuests = 40
	elseif (Quest.GetQuest("C01").IsCompleted() || Quest.GetQuest("MG03").IsCompleted())
		currQuests = 30
	endif
	skillDivisor = 60.0
	rankID = "II"
elseif (!Quest.GetQuest("TG07").IsCompleted())
	currQuests = 40
	if (Quest.GetQuest("C04").IsCompleted() || Quest.GetQuest("mg06").IsCompleted())
		currQuests = 145
	elseif (Quest.GetQuest("C03").IsCompleted() || Quest.GetQuest("MG04").IsCompleted())
		currQuests = 90
	elseif (Quest.GetQuest("C01").IsCompleted() || Quest.GetQuest("MG03").IsCompleted())
		currQuests = 80
	endif
	skillDivisor = 85.0
	rankID = "III"
endif

if (currQuests > 0)
	int loyaltyProgress = (100.0 * (pTGRMasterTotal.Value as float) / (currQuests as float)) as int
	float skill1 = Game.GetPlayer().GetBaseActorValue("Sneak") as float
	float skill2 = Game.GetPlayer().GetBaseActorValue("Lockpicking") as float
	float skill3 = Game.GetPlayer().GetBaseActorValue("Pickpocket") as float
	float maxSkill12 = (skill1 + skill2 + math.abs(skill1 - skill2)) / 2
	float maxSkill = (skill3 + maxSkill12 + math.abs(skill3 - maxSkill12)) / 2
	int skillProgress = (100.0 * maxSkill / skillDivisor) as int
	if (loyaltyProgress >= 100 && skillProgress >= 100)
		Debug.Notification("Thieves Guild Rank " + rankID + " Achieved!")
	else
		Debug.Notification("Quests to Next Rank: " + loyaltyProgress + "%")
		Debug.Notification("Skill to Next Rank: " + skillProgress + "%")
	endif
endif

Stop()
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_0
Function Fragment_0()
;BEGIN AUTOCAST TYPE TGRNTQuestScript
Quest __temp = self as Quest
TGRNTQuestScript kmyQuest = __temp as TGRNTQuestScript
;END AUTOCAST
;BEGIN CODE
;Quest Given by Delvin
pTGRShellScript.pTGRDelvinRunning = 1
pTGRShellScript.pTGRNTRun = 1
pTGRNTQS.SetupGlobals()
SetObjectiveDisplayed (10,1)

if (pQuestTrackerTGRNT.GetValue() == 1)
	Game.IncrementStat("Thieves' Guild Quests Completed", 1) ;If the quest has previously been taken and completed/failed, stat is getting decremented here; correct by adding 1 to the stat
	Game.IncrementStat("Quests Completed", 1)
endif

;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_9
Function Fragment_9()
;BEGIN CODE
;Finished Quest With Fail Condition
FailAllObjectives()

pQuestTrackerTGRNT.SetValue(1) ; indicate that this quest has been failed at least once

Stop()
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_8
Function Fragment_8()
;BEGIN CODE
;Finished Quest With Fail Condition
FailAllObjectives()

pQuestTrackerTGRNT.SetValue(1) ; indicate that this quest has been failed at least once

Stop()
;END CODE
EndFunction
;END FRAGMENT

;END FRAGMENT CODE - Do not edit anything between this and the begin comment

TGRShellScript Property pTGRShellScript  Auto

TGRNTQuestScript Property pTGRNTQS  Auto

GlobalVariable Property pQuestTrackerTGRNT  Auto

LeveledItem Property pReward  Auto

GlobalVariable Property pTGRMasterTotal  Auto
TGREnablerHandlerQuestScript Property pTGREHQS  Auto
