ScriptName zzzSXPWorkerKillActor Extends Quest
;=============================================================;
;Basic Properties
;=============================================================;
zzzSXPController Property XPC Auto
Faction[] Property FactionArray Auto
Keyword[] Property KeywordArray Auto
Faction Property zzzSXPExcludeFaction Auto
Keyword Property ImmuneParalysis Auto
Keyword Property ActorTypeUndead Auto
GlobalVariable Property UndeadBaseAdd Auto
GlobalVariable Property UndeadBaseMult Auto
MiscObject Property MISC_HitToken Auto
float[] Property SXPActor Auto Hidden
;=============================================================;
;Basic Variables
;=============================================================;
Actor[] Victims
float[] ExtraBonus

Function GameInit()
	GarbageCollection()
EndFunction

Function GameReloaded()
	GarbageCollection()
EndFunction

Function GarbageCollection()
	Victims = new Actor[10]
EndFunction

Function PostVictim(Actor pVictim)
	int Index = Victims.Find(None)
	Victims[Index] = pVictim

	Actor pActor = Victims[Index]
	Victims[Index] = None

	XPC.GainXPMessage(55, CalcXP(pActor))
EndFunction

float Function CalcXP(Actor pActor)
	int iHitCount = pActor.GetItemCount(MISC_HitToken)
	pActor.RemoveItem(MISC_HitToken, iHitCount, False)

	if pActor.IsInFaction(zzzSXPExcludeFaction)
		return 0.0
	endif

	Race pRace = pActor.GetRace()

	float fLevel = pActor.GetLevel()
	int nDiv5 = (fLevel as Int) / 5
	int nDiv10 = (fLevel as Int) / 10

	float fBase = SXPActor[0] ;FUND_BASE
	float fMult = SXPActor[1] ;FUND_MULT

	if fBase == 0.0 || fMult == 0.0
		return 0.0
	endif

	float fValue = fLevel * SXPActor[2] ;FUND_ONE
	fValue += nDiv5 * SXPActor[3] ;FUND_TWO
	fValue += nDiv10 * SXPActor[4] ;FUND_THREE

	float fArmorRating = (pActor.GetBaseActorValue("DamageResist") / 667.0) * SXPActor[8]
	fMult += fArmorRating

	If pRace != None
	int Index = 0
	int iElementFaction = FactionArray.Length
	int iElementKeyword = KeywordArray.Length
	int iElement = iElementFaction + iElementKeyword
	int StartNumber = 9
		While Index < iElement
			bool Update = False
			if Index < iElementFaction
				if pActor.IsInFaction(FactionArray[Index])
					Update = True
				endif
			else
				if pRace.HasKeyword(KeywordArray[Index - iElementFaction])
					Update = True
				endif
			endif
			if Update
				float fBaseAdd = SXPActor[StartNumber]
				float fMultAdd = SXPActor[StartNumber + 1]
				if fBaseAdd == 0.0 || fMultAdd == 0.0
					return 0.0
				else
					fBase += fBaseAdd
					fMult += fMultAdd
				endif
			endif
			Index += 1
			StartNumber += 2
		EndWhile

		if pRace.IsPlayable()
			if pRace.HasKeyword(ImmuneParalysis)
				fBase += SXPActor[29]
				fMult += SXPActor[30]
			endif
			if !pRace.NoKnockdowns()
				fBase += SXPActor[31]
				fMult += SXPActor[32]
			endif
			if pRace.IsNotPushable()
				fBase += SXPActor[33]
				fMult += SXPActor[34]
			endif
		endif
	Endif

    if pRace.HasKeyword(ActorTypeUndead)
        fBase += UndeadBaseAdd.GetValue()
        fMult += UndeadBaseMult.GetValue()
    endif

	float ExtraBonus0 = ((pActor.GetBaseActorValue( "Health" ) as Int) / 100 ) * SXPActor[5]
	float ExtraBonus1 = pActor.GetSpellCount() * SXPActor[6]
	float ExtraBonus2 = iHitCount * SXPActor[7]

	fMult = fMult + ExtraBonus0 + ExtraBonus1 + ExtraBonus2

	float ret = ( fBase + fValue ) * fMult

	return ret
EndFunction