ScriptName zzzSXPGainExpKillActor Extends Quest

zzzSXPWorkerKillActor Property XPWorker Auto

MiscObject Property zzzSXPTokenHit Auto
Keyword Property MagicInfluenceFrenzy Auto
Faction Property FollowerFaction Auto
Faction Property PlayerFollowerFaction Auto
MagicEffect Property IndirectDeathEffect Auto
Spell Property IndirectDeathTracker Auto

Event OnStoryKillActor( ObjectReference pVictim, ObjectReference pKiller, Location pLoc, int nCrime, int nRelation )
	Actor VictimActor = pVictim as Actor
	Actor KillerActor = pKiller as Actor

	if ( VictimActor == None )
		Stop()
		return
	endif

	if ( KillerActor == None )
        if (VictimActor.HasMagicEffect(IndirectDeathEffect))
            VictimActor.DispelSpell(IndirectDeathTracker)
            XPWorker.PostVictim( VictimActor )
            Stop()
            return
        endif

		ClearToken( VictimActor )
		Stop()
		return
	endif

	if ( KillerActor != Game.GetPlayer() )
		if ( KillerActor.IsPlayerTeammate() == False && KillerActor.IsInFaction(FollowerFaction) == False && KillerActor.IsInFaction(PlayerFollowerFaction) == False)
			if (KillerActor.HasMagicEffectWithKeyword(MagicInfluenceFrenzy) || VictimActor.HasMagicEffect(IndirectDeathEffect))
                if (VictimActor.HasMagicEffect(IndirectDeathEffect))
                    VictimActor.DispelSpell(IndirectDeathTracker)
                endif
				XPWorker.PostVictim( VictimActor )
				Stop()
				return
			endif

			ClearToken( VictimActor )
			Stop()
			return
		endif
	endif

    if (VictimActor.HasMagicEffect(IndirectDeathEffect))
        VictimActor.DispelSpell(IndirectDeathTracker)
    endif
	XPWorker.PostVictim( VictimActor )
	Stop()
EndEvent

Function ClearToken( Actor pActor )
	if ( pActor == None )
		return
	endif
	pActor.RemoveItem(zzzSXPTokenHit, 9999, False )
EndFunction
