ScriptName MacDIHOSoulShardTrigger extends ObjectReference
{Script to return the player's gold/items when they reintegrate their soul shard.}

import StorageUtil

Actor Property PlayerRef auto
ObjectReference Property pDeathStorage auto
ObjectReference Property pDeathMarkFX auto
Explosion Property pTouchFX auto
MacDIHOCommonFunctions Property Common auto

Event OnTriggerEnter(ObjectReference akActionRef)
    ; If the player enters the soul shard trigger and is not bleeding out/invulnerable, return their gold/items
    If (akActionRef == PlayerRef && !PlayerRef.IsBleedingOut() && !PlayerRef.GetActorBase().IsInvulnerable() && pDeathStorage.GetParentCell() != Self.GetParentCell())
        pDeathMarkFX.PlaceAtMe(pTouchFX)
        pDeathStorage.RemoveAllItems(PlayerRef, true)
        pDeathMarkFX.MoveToMyEditorLocation()
        Self.MoveToMyEditorLocation()
		int toReturnXP = StorageUtil.GetIntValue(none, "volatileSkillXPdarkSouls", 0)
		If toReturnXP > 0
			StorageUtil.SetIntValue(none, "volatileSkillXPdarkSouls", 0)
			If StorageUtil.HasIntValue(none, "volatileSkillXP")
				StorageUtil.AdjustIntValue(none, "volatileSkillXP", toReturnXP)
			Else
				StorageUtil.SetIntValue(none, "volatileSkillXP", toReturnXP)
			EndIf
		EndIf
		Common.RestoreXPPoints(StorageUtil.GetIntValue(none, "volatileUsableXPdarkSouls", 0))
		StorageUtil.SetIntValue(none, "volatileUsableXPdarkSouls", 0)
        Debug.Notification("My lost power has been returned to me.")
	EndIf
EndEvent
