ScriptName MacDIHOPrayerOfSacrifice extends ActiveMagicEffect
{Script to bind the player's soul to whatever place they were in when they used their "Prayer of Sacrifice" power.}

Actor Property PlayerRef auto
Armor Property pAmuletOfArkay auto
ObjectReference Property pSpawnPoint auto
Explosion Property SuccessFX auto
Sound Property pSuccessSFX auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
    If (PlayerRef.GetItemCount(pAmuletOfArkay) > 0)
        pSpawnPoint.MoveTo(PlayerRef)
        pSpawnPoint.PlaceAtMe(SuccessFX)
        Utility.Wait(0.3)

        pSuccessSFX.Play(pSpawnPoint)
		Debug.MessageBox("The Amulet of Arkay shatters in holy light, leaving only dust behind. My soul has been imprinted on this location.")
        PlayerRef.RemoveItem(pAmuletOfArkay, 1, true)
    Else
        Debug.Notification("I need an Amulet of Arkay to channel this prayer.")
    EndIf
EndEvent
