ScriptName MacDIHOCommonFunctions extends Quest
{Library of common functions.}

GlobalVariable Property DIHOState auto
GlobalVariable Property DIHOBehavior auto
GlobalVariable Property DIHODelayedStart auto
GlobalVariable Property DIHOPollingInterval auto
GlobalVariable Property DIHOAttributeDamage auto
GlobalVariable Property DIHOAttributeDamageTotal auto
GlobalVariable Property DIHODebugMode auto
GlobalVariable Property XPPoint auto

float Function ValidatePollingInterval()
{Verifies that polling interval global is within tolerated limits; resets it to closest acceptable value if it is out of bounds.}
    float fPollingInterval = DIHOPollingInterval.GetValue()

    If (fPollingInterval < 1)
        fPollingInterval = 1.0
        DIHOPollingInterval.SetValue(fPollingInterval)
    EndIf

    If (fPollingInterval > 5)
        fPollingInterval = 5.0
        DIHOPollingInterval.SetValue(fPollingInterval)
    EndIf

    return fPollingInterval
EndFunction

int Function ValidateAttributeDamage()
{Verifies that attribute damage global is within tolerated limits; resets it to closest acceptable value if it is out of bounds.}
    int nAttributeDamage = DIHOAttributeDamage.GetValueInt()

    If (nAttributeDamage < 0)
        nAttributeDamage = 0
        DIHOAttributeDamage.SetValue(nAttributeDamage)
    EndIf

    If (nAttributeDamage > 10)
        nAttributeDamage = 10
        DIHOAttributeDamage.SetValue(nAttributeDamage)
    EndIf

    return nAttributeDamage
EndFunction

Function RestoreXPPoints(int pointsToRestore)
	If pointsToRestore > 0
		XPPoint.SetValue(XPPoint.GetValue() + pointsToRestore)
	EndIf
EndFunction

int Function RemoveXPPoints()
	int toReturn = XPPoint.GetValue() as int
	XPPoint.SetValue(0)
	return toReturn
EndFunction

Function DebugPrint(string msg)
{Prints the passed-in debug string as a notification if debug mode is enabled.}
    If (DIHODebugMode.GetValue() > 0)
        Debug.Notification(msg)
    EndIf
EndFunction

int Function GetDIHOState()
{Returns the value of the DIHOState global variable.}
    return DIHOState.GetValueInt()
EndFunction

Function SetDIHOState(int val)
{Sets the value of the DIHOState global variable.}
    DIHOState.SetValue(val)
EndFunction

int Function GetDIHOBehavior()
{Returns the value of the DIHOBehavior global variable.}
    return DIHOBehavior.GetValueInt()
EndFunction

Function SetDIHOBehavior(int val)
{Sets the value of the DIHOBehavior global variable.}
    DIHOBehavior.SetValue(val)
EndFunction

int Function GetDIHODelayedStart()
{Returns the value of the DIHODelayedStart global variable.}
    return DIHODelayedStart.GetValueInt()
EndFunction

Function SetDIHODelayedStart(int val)
{Sets the value of the DIHODelayedStart global variable.}
    DIHODelayedStart.SetValue(val)
EndFunction

float Function GetDIHOPollingInterval()
{Returns the value of the DIHOPollingInterval global variable.}
    return DIHOPollingInterval.GetValue()
EndFunction

Function SetDIHOPollingInterval(float val)
{Sets the value of the DIHOPollingInterval global variable.}
    DIHOPollingInterval.SetValue(val)
EndFunction

int Function GetDIHOAttributeDamage()
{Returns the value of the DIHOAttributeDamage global variable.}
    return DIHOAttributeDamage.GetValueInt()
EndFunction

Function SetDIHOAttributeDamage(int val)
{Sets the value of the DIHOAttributeDamage global variable.}
    DIHOAttributeDamage.SetValue(val)
EndFunction

int Function GetDIHOAttributeDamageTotal()
{Returns the value of the DIHOAttributeDamageTotal global variable.}
    return DIHOAttributeDamageTotal.GetValueInt()
EndFunction

Function SetDIHOAttributeDamageTotal(int val)
{Sets the value of the DIHOAttributeDamageTotal global variable.}
    DIHOAttributeDamageTotal.SetValue(val)
EndFunction

Function IncrementDIHOAttributeDamageTotal(int val)
{Increments the value of the DIHOAttributeDamageTotal global variable by the passed in value.}
    DIHOAttributeDamageTotal.SetValue(DIHOAttributeDamageTotal.GetValueInt() + val)
EndFunction
