ScriptName _sycMainQuestScript extends Quest Conditional

Import Game
Import Actor
Import ActorBase
Import ObjectReference
Import Utility
Import Sound
Import Debug

Import StorageUtil

;---------------------------------------------------------------------------------------------------
;### DECLARED VARIABLES/PROPERTIES ###
;---------------------------------------------------------------------------------------------------

;## Hidden Properties ##
; Version
Float fLatestVersion
Float Property fVersion Auto	; Must keep as a property or value will be lost if redeclared as a local variable.
; Hidden Properties
Bool bShowEnableCCOPrompt
Bool bCCODisabledOnCharacter
Bool bPlayOpenCCOMenuSound
Bool bToggleModuleNotificationsOn
; Module States
Bool bDiverseRaceAndGendersApplied
Bool bDynamicSkillProgressionApplied
Bool bOblivionCarryWeightsApplied
Bool bPermanentBirthsignsApplied

;## Menu Choices ##
Int iBirthsign
Int iSpecialization
Int iAttribute
Int Property iMajorSkill1 Auto Conditional	; Must first use integers than assign to an array, otherwise we cannot conditionalize the Menu options
Int Property iMajorSkill2 Auto Conditional
Int Property iMajorSkill3 Auto Conditional
Int Property iMajorSkill4 Auto Conditional
Int Property iMajorSkill5 Auto Conditional
Int Property iMajorSkill6 Auto Conditional

;## Sound FX ##
Sound Property _sycSFXOpenMenu Auto	; Open Main Menu Sound
Sound Property MAGMysticismSoulTrapCapture Auto	; Close Main Menu Sound

;## Attributes ##
Float fHealthModifier
Float fMagickaModifier
Float fStaminaModifier
Float fCarryWeightModifier
; For Display in Race Menu
Float fHealth
Float fMagicka
Float fStamina
Float fCarryWeight

;## Skills ##
Float fAlchemySkillModifier
Float fAlterationSkillModifier
Float fBlockSkillModifier
Float fConjurationSkillModifier
Float fDestructionSkillModifier
Float fEnchantingSkillModifier
Float fHeavyArmorSkillModifier
Float fIllusionSkillModifier
Float fLightArmorSkillModifier
Float fLockpickingSkillModifier
Float fMarksmanSkillModifier
Float fOneHandedSkillModifier
Float fPickpocketSkillModifier
Float fRestorationSkillModifier
Float fSmithingSkillModifier
Float fSneakSkillModifier
Float fSpeechcraftSkillModifier
Float fTwoHandedSkillModifier

;## Skill Rates ##
Int fAlchemySkillRate
Int fAlterationSkillRate
Int fBlockSkillRate
Int fConjurationSkillRate
Int fDestructionSkillRate
Int fEnchantingSkillRate
Int fHeavyArmorSkillRate
Int fIllusionSkillRate
Int fLightArmorSkillRate
Int fLockpickingSkillRate
Int fMarksmanSkillRate
Int fOneHandedSkillRate
Int fPickpocketSkillRate
Int fRestorationSkillRate
Int fSmithingSkillRate
Int fSneakSkillRate
Int fSpeechcraftSkillRate
Int fTwoHandedSkillRate

;## References ##
Quest Property MQ101 Auto
Actor Property PlayerRef Auto
; Races
Race Property HighElfRace Auto
Race Property ArgonianRace Auto
Race Property WoodElfRace Auto
Race Property BretonRace Auto
Race Property DarkElfRace Auto
Race Property ImperialRace Auto
Race Property KhajiitRace Auto
Race Property NordRace Auto
Race Property OrcRace Auto
Race Property RedguardRace Auto
Race Property HighElfRaceVampire Auto
Race Property ArgonianRaceVampire Auto
Race Property WoodElfRaceVampire Auto
Race Property BretonRaceVampire Auto
Race Property DarkElfRaceVampire Auto
Race Property ImperialRaceVampire Auto
Race Property KhajiitRaceVampire Auto
Race Property NordRaceVampire Auto
Race Property OrcRaceVampire Auto
Race Property RedguardRaceVampire Auto
; Books
Book Property _sycCCOBook Auto

;## Skill Rate Perks ##
; +5%
Perk Property _sycSkillRateAlchemy105Perk Auto
Perk Property _sycSkillRateAlteration105Perk Auto
Perk Property _sycSkillRateBlock105Perk Auto
Perk Property _sycSkillRateConjuration105Perk Auto
Perk Property _sycSkillRateDestruction105Perk Auto
Perk Property _sycSkillRateEnchanting105Perk Auto
Perk Property _sycSkillRateHeavyArmor105Perk Auto
Perk Property _sycSkillRateIllusion105Perk Auto
Perk Property _sycSkillRateLightArmor105Perk Auto
Perk Property _sycSkillRateLockpicking105Perk Auto
Perk Property _sycSkillRateMarksman105Perk Auto
Perk Property _sycSkillRateOneHanded105Perk Auto
Perk Property _sycSkillRatePickpocket105Perk Auto
Perk Property _sycSkillRateRestoration105Perk Auto
Perk Property _sycSkillRateSmithing105Perk Auto
Perk Property _sycSkillRateSneak105Perk Auto
Perk Property _sycSkillRateSpeechcraft105Perk Auto
Perk Property _sycSkillRateTwoHanded105Perk Auto
; +10%
Perk Property _sycSkillRateAlchemy110Perk Auto
Perk Property _sycSkillRateAlteration110Perk Auto
Perk Property _sycSkillRateBlock110Perk Auto
Perk Property _sycSkillRateConjuration110Perk Auto
Perk Property _sycSkillRateDestruction110Perk Auto
Perk Property _sycSkillRateEnchanting110Perk Auto
Perk Property _sycSkillRateHeavyArmor110Perk Auto
Perk Property _sycSkillRateIllusion110Perk Auto
Perk Property _sycSkillRateLightArmor110Perk Auto
Perk Property _sycSkillRateLockpicking110Perk Auto
Perk Property _sycSkillRateMarksman110Perk Auto
Perk Property _sycSkillRateOneHanded110Perk Auto
Perk Property _sycSkillRatePickpocket110Perk Auto
Perk Property _sycSkillRateRestoration110Perk Auto
Perk Property _sycSkillRateSmithing110Perk Auto
Perk Property _sycSkillRateSneak110Perk Auto
Perk Property _sycSkillRateSpeechcraft110Perk Auto
Perk Property _sycSkillRateTwoHanded110Perk Auto
; +15%
Perk Property _sycSkillRateAlchemy115Perk Auto
Perk Property _sycSkillRateAlteration115Perk Auto
Perk Property _sycSkillRateBlock115Perk Auto
Perk Property _sycSkillRateConjuration115Perk Auto
Perk Property _sycSkillRateDestruction115Perk Auto
Perk Property _sycSkillRateEnchanting115Perk Auto
Perk Property _sycSkillRateHeavyArmor115Perk Auto
Perk Property _sycSkillRateIllusion115Perk Auto
Perk Property _sycSkillRateLightArmor115Perk Auto
Perk Property _sycSkillRateLockpicking115Perk Auto
Perk Property _sycSkillRateMarksman115Perk Auto
Perk Property _sycSkillRateOneHanded115Perk Auto
Perk Property _sycSkillRatePickpocket115Perk Auto
Perk Property _sycSkillRateRestoration115Perk Auto
Perk Property _sycSkillRateSmithing115Perk Auto
Perk Property _sycSkillRateSneak115Perk Auto
Perk Property _sycSkillRateSpeechcraft115Perk Auto
Perk Property _sycSkillRateTwoHanded115Perk Auto
; +20%
Perk Property _sycSkillRateAlchemy120Perk Auto
Perk Property _sycSkillRateAlteration120Perk Auto
Perk Property _sycSkillRateBlock120Perk Auto
Perk Property _sycSkillRateConjuration120Perk Auto
Perk Property _sycSkillRateDestruction120Perk Auto
Perk Property _sycSkillRateEnchanting120Perk Auto
Perk Property _sycSkillRateHeavyArmor120Perk Auto
Perk Property _sycSkillRateIllusion120Perk Auto
Perk Property _sycSkillRateLightArmor120Perk Auto
Perk Property _sycSkillRateLockpicking120Perk Auto
Perk Property _sycSkillRateMarksman120Perk Auto
Perk Property _sycSkillRateOneHanded120Perk Auto
Perk Property _sycSkillRatePickpocket120Perk Auto
Perk Property _sycSkillRateRestoration120Perk Auto
Perk Property _sycSkillRateSmithing120Perk Auto
Perk Property _sycSkillRateSneak120Perk Auto
Perk Property _sycSkillRateSpeechcraft120Perk Auto
Perk Property _sycSkillRateTwoHanded120Perk Auto
; +25%
Perk Property _sycSkillRateAlchemy125Perk Auto
Perk Property _sycSkillRateAlteration125Perk Auto
Perk Property _sycSkillRateBlock125Perk Auto
Perk Property _sycSkillRateConjuration125Perk Auto
Perk Property _sycSkillRateDestruction125Perk Auto
Perk Property _sycSkillRateEnchanting125Perk Auto
Perk Property _sycSkillRateHeavyArmor125Perk Auto
Perk Property _sycSkillRateIllusion125Perk Auto
Perk Property _sycSkillRateLightArmor125Perk Auto
Perk Property _sycSkillRateLockpicking125Perk Auto
Perk Property _sycSkillRateMarksman125Perk Auto
Perk Property _sycSkillRateOneHanded125Perk Auto
Perk Property _sycSkillRatePickpocket125Perk Auto
Perk Property _sycSkillRateRestoration125Perk Auto
Perk Property _sycSkillRateSmithing125Perk Auto
Perk Property _sycSkillRateSneak125Perk Auto
Perk Property _sycSkillRateSpeechcraft125Perk Auto
Perk Property _sycSkillRateTwoHanded125Perk Auto
; 5%
Perk Property _sycSkillRateAlchemy005Perk Auto
Perk Property _sycSkillRateAlteration005Perk Auto
Perk Property _sycSkillRateBlock005Perk Auto
Perk Property _sycSkillRateConjuration005Perk Auto
Perk Property _sycSkillRateDestruction005Perk Auto
Perk Property _sycSkillRateEnchanting005Perk Auto
Perk Property _sycSkillRateHeavyArmor005Perk Auto
Perk Property _sycSkillRateIllusion005Perk Auto
Perk Property _sycSkillRateLightArmor005Perk Auto
Perk Property _sycSkillRateLockpicking005Perk Auto
Perk Property _sycSkillRateMarksman005Perk Auto
Perk Property _sycSkillRateOneHanded005Perk Auto
Perk Property _sycSkillRatePickpocket005Perk Auto
Perk Property _sycSkillRateRestoration005Perk Auto
Perk Property _sycSkillRateSmithing005Perk Auto
Perk Property _sycSkillRateSneak005Perk Auto
Perk Property _sycSkillRateSpeechcraft005Perk Auto
Perk Property _sycSkillRateTwoHanded005Perk Auto
; 10%
Perk Property _sycSkillRateAlchemy010Perk Auto
Perk Property _sycSkillRateAlteration010Perk Auto
Perk Property _sycSkillRateBlock010Perk Auto
Perk Property _sycSkillRateConjuration010Perk Auto
Perk Property _sycSkillRateDestruction010Perk Auto
Perk Property _sycSkillRateEnchanting010Perk Auto
Perk Property _sycSkillRateHeavyArmor010Perk Auto
Perk Property _sycSkillRateIllusion010Perk Auto
Perk Property _sycSkillRateLightArmor010Perk Auto
Perk Property _sycSkillRateLockpicking010Perk Auto
Perk Property _sycSkillRateMarksman010Perk Auto
Perk Property _sycSkillRateOneHanded010Perk Auto
Perk Property _sycSkillRatePickpocket010Perk Auto
Perk Property _sycSkillRateRestoration010Perk Auto
Perk Property _sycSkillRateSmithing010Perk Auto
Perk Property _sycSkillRateSneak010Perk Auto
Perk Property _sycSkillRateSpeechcraft010Perk Auto
Perk Property _sycSkillRateTwoHanded010Perk Auto
; 15%
Perk Property _sycSkillRateAlchemy015Perk Auto
Perk Property _sycSkillRateAlteration015Perk Auto
Perk Property _sycSkillRateBlock015Perk Auto
Perk Property _sycSkillRateConjuration015Perk Auto
Perk Property _sycSkillRateDestruction015Perk Auto
Perk Property _sycSkillRateEnchanting015Perk Auto
Perk Property _sycSkillRateHeavyArmor015Perk Auto
Perk Property _sycSkillRateIllusion015Perk Auto
Perk Property _sycSkillRateLightArmor015Perk Auto
Perk Property _sycSkillRateLockpicking015Perk Auto
Perk Property _sycSkillRateMarksman015Perk Auto
Perk Property _sycSkillRateOneHanded015Perk Auto
Perk Property _sycSkillRatePickpocket015Perk Auto
Perk Property _sycSkillRateRestoration015Perk Auto
Perk Property _sycSkillRateSmithing015Perk Auto
Perk Property _sycSkillRateSneak015Perk Auto
Perk Property _sycSkillRateSpeechcraft015Perk Auto
Perk Property _sycSkillRateTwoHanded015Perk Auto
; 20%
Perk Property _sycSkillRateAlchemy020Perk Auto
Perk Property _sycSkillRateAlteration020Perk Auto
Perk Property _sycSkillRateBlock020Perk Auto
Perk Property _sycSkillRateConjuration020Perk Auto
Perk Property _sycSkillRateDestruction020Perk Auto
Perk Property _sycSkillRateEnchanting020Perk Auto
Perk Property _sycSkillRateHeavyArmor020Perk Auto
Perk Property _sycSkillRateIllusion020Perk Auto
Perk Property _sycSkillRateLightArmor020Perk Auto
Perk Property _sycSkillRateLockpicking020Perk Auto
Perk Property _sycSkillRateMarksman020Perk Auto
Perk Property _sycSkillRateOneHanded020Perk Auto
Perk Property _sycSkillRatePickpocket020Perk Auto
Perk Property _sycSkillRateRestoration020Perk Auto
Perk Property _sycSkillRateSmithing020Perk Auto
Perk Property _sycSkillRateSneak020Perk Auto
Perk Property _sycSkillRateSpeechcraft020Perk Auto
Perk Property _sycSkillRateTwoHanded020Perk Auto
; 25%
Perk Property _sycSkillRateAlchemy025Perk Auto
Perk Property _sycSkillRateAlteration025Perk Auto
Perk Property _sycSkillRateBlock025Perk Auto
Perk Property _sycSkillRateConjuration025Perk Auto
Perk Property _sycSkillRateDestruction025Perk Auto
Perk Property _sycSkillRateEnchanting025Perk Auto
Perk Property _sycSkillRateHeavyArmor025Perk Auto
Perk Property _sycSkillRateIllusion025Perk Auto
Perk Property _sycSkillRateLightArmor025Perk Auto
Perk Property _sycSkillRateLockpicking025Perk Auto
Perk Property _sycSkillRateMarksman025Perk Auto
Perk Property _sycSkillRateOneHanded025Perk Auto
Perk Property _sycSkillRatePickpocket025Perk Auto
Perk Property _sycSkillRateRestoration025Perk Auto
Perk Property _sycSkillRateSmithing025Perk Auto
Perk Property _sycSkillRateSneak025Perk Auto
Perk Property _sycSkillRateSpeechcraft025Perk Auto
Perk Property _sycSkillRateTwoHanded025Perk Auto
; 30%
Perk Property _sycSkillRateAlchemy030Perk Auto
Perk Property _sycSkillRateAlteration030Perk Auto
Perk Property _sycSkillRateBlock030Perk Auto
Perk Property _sycSkillRateConjuration030Perk Auto
Perk Property _sycSkillRateDestruction030Perk Auto
Perk Property _sycSkillRateEnchanting030Perk Auto
Perk Property _sycSkillRateHeavyArmor030Perk Auto
Perk Property _sycSkillRateIllusion030Perk Auto
Perk Property _sycSkillRateLightArmor030Perk Auto
Perk Property _sycSkillRateLockpicking030Perk Auto
Perk Property _sycSkillRateMarksman030Perk Auto
Perk Property _sycSkillRateOneHanded030Perk Auto
Perk Property _sycSkillRatePickpocket030Perk Auto
Perk Property _sycSkillRateRestoration030Perk Auto
Perk Property _sycSkillRateSmithing030Perk Auto
Perk Property _sycSkillRateSneak030Perk Auto
Perk Property _sycSkillRateSpeechcraft030Perk Auto
Perk Property _sycSkillRateTwoHanded030Perk Auto
; 100%
Perk Property _sycSkillRateAlchemy100Perk Auto
Perk Property _sycSkillRateAlteration100Perk Auto
Perk Property _sycSkillRateBlock100Perk Auto
Perk Property _sycSkillRateConjuration100Perk Auto
Perk Property _sycSkillRateDestruction100Perk Auto
Perk Property _sycSkillRateEnchanting100Perk Auto
Perk Property _sycSkillRateHeavyArmor100Perk Auto
Perk Property _sycSkillRateIllusion100Perk Auto
Perk Property _sycSkillRateLightArmor100Perk Auto
Perk Property _sycSkillRateLockpicking100Perk Auto
Perk Property _sycSkillRateMarksman100Perk Auto
Perk Property _sycSkillRateOneHanded100Perk Auto
Perk Property _sycSkillRatePickpocket100Perk Auto
Perk Property _sycSkillRateRestoration100Perk Auto
Perk Property _sycSkillRateSmithing100Perk Auto
Perk Property _sycSkillRateSneak100Perk Auto
Perk Property _sycSkillRateSpeechcraft100Perk Auto
Perk Property _sycSkillRateTwoHanded100Perk Auto

;## Messages ##
; Enable CCO Message
Message Property _sycEnableCCOPromptMSG Auto
; Uninstall Messages
Message Property _sycCCOUninstallerActivatedByAccidentMSG Auto
Message Property _sycConfirmUninstallCCOMSG Auto
Message Property _sycCCOUninstallationCanceledMSG Auto
Message Property _sycCCOUninstallationCompleteMSG Auto
; Upgrade Messages
Message Property _sycUpgradeCCOMSG Auto
Message Property _sycUpgradeCCOOptionsMSG Auto
; CCO Book
Message Property _sycWriteInCCOBookPromptMSG Auto
Message Property _sycReviseCCOBookPromptMSG Auto
; Choose Class
Message Property _sycChooseClassMSG Auto
Message Property _sycCombatClassesMSG Auto
Message Property _sycMagicClassesMSG Auto
Message Property _sycStealthClassesMSG Auto
; Classes
Message Property _sycClassArcherMSG Auto
Message Property _sycClassBarbarianMSG Auto
Message Property _sycClassCrusaderMSG Auto
Message Property _sycClassKnightMSG Auto
Message Property _sycClassRogueMSG Auto
Message Property _sycClassScoutMSG Auto
Message Property _sycClassWarriorMSG Auto
Message Property _sycClassBattlemageMSG Auto
Message Property _sycClassHealerMSG Auto
Message Property _sycClassMageMSG Auto
Message Property _sycClassNightbladeMSG Auto
Message Property _sycClassSorcererMSG Auto
Message Property _sycClassSpellswordMSG Auto
Message Property _sycClassWitchhunterMSG Auto
Message Property _sycClassAcrobatMSG Auto
Message Property _sycClassAgentMSG Auto
Message Property _sycClassAssassinMSG Auto
Message Property _sycClassBardMSG Auto
Message Property _sycClassMonkMSG Auto
Message Property _sycClassPilgrimMSG Auto
Message Property _sycClassThiefMSG Auto
; Choose Specialization
Message Property _sycChooseSpecializationMSG Auto
Message Property _sycCombatSpecializationMSG Auto
Message Property _sycMagicSpecializationMSG Auto
Message Property _sycStealthSpecializationMSG Auto
; Choose Attribute
Message Property _sycChooseAttributeMSG Auto
; Choose Major Skills
Message Property _sycChooseMajorSkill1MSG Auto
Message Property _sycChooseMajorSkill2MSG Auto
Message Property _sycChooseMajorSkill3MSG Auto
Message Property _sycChooseMajorSkill4MSG Auto
Message Property _sycChooseMajorSkill5MSG Auto
Message Property _sycChooseMajorSkill6MSG Auto
; Skill Types
Message Property _sycCombatSkillsMSG Auto
Message Property _sycMagicSkillsMSG Auto
Message Property _sycStealthSkillsMSG Auto
; Combat Skills
Message Property _sycSkillArcheryMSG Auto
Message Property _sycSkillBlockMSG Auto
Message Property _sycSkillHeavyArmorMSG Auto
Message Property _sycSkillOneHandedMSG Auto
Message Property _sycSkillSmithingMSG Auto
Message Property _sycSkillTwoHandedMSG Auto
; Magic Skills
Message Property _sycSkillAlterationMSG Auto
Message Property _sycSkillConjurationMSG Auto
Message Property _sycSkillDestructionMSG Auto
Message Property _sycSkillEnchantingMSG Auto
Message Property _sycSkillIllusionMSG Auto
Message Property _sycSkillRestorationMSG Auto
; Stealth Skills
Message Property _sycSkillAlchemyMSG Auto
Message Property _sycSkillLightArmorMSG Auto
Message Property _sycSkillLockpickingMSG Auto
Message Property _sycSkillPickpocketMSG Auto
Message Property _sycSkillSneakMSG Auto
Message Property _sycSkillSpeechMSG Auto

; Choose Specialization
Message Property _sycChooseSpecializationDSPMSG Auto
Message Property _sycCombatSpecializationDSPMSG Auto
Message Property _sycMagicSpecializationDSPMSG Auto
Message Property _sycStealthSpecializationDSPMSG Auto
; Choose Major Skills
Message Property _sycChooseMajorSkill1DSPMSG Auto
Message Property _sycChooseMajorSkill2DSPMSG Auto
Message Property _sycChooseMajorSkill3DSPMSG Auto
Message Property _sycChooseMajorSkill4DSPMSG Auto
Message Property _sycChooseMajorSkill5DSPMSG Auto
Message Property _sycChooseMajorSkill6DSPMSG Auto

Spell Property KhajitSkillExpBuff Auto
Spell Property HighElfSkillExpBuff Auto
Spell Property ArgonianSkillExpBuff Auto
Spell Property WoodElfSkillExpBuff Auto
Spell Property BretonSkillExpBuff Auto
Spell Property DarkElfSkillExpBuff Auto
Spell Property ImperialSkillExpBuff Auto
Spell Property NordSkillExpBuff Auto
Spell Property OrcSkillExpBuff Auto
Spell Property RedguardSkillExpBuff Auto
Spell Property CombatSpecializationExpBuff Auto
Spell Property MagicSpecializationExpBuff Auto
Spell Property StealthSpecializationExpBuff Auto

;---------------------------------------------------------------------------------------------------
;### MAIN SCRIPT ###
;---------------------------------------------------------------------------------------------------

; Event OnInit()
	; This script is now started via _sycMaintenanceRefAliasScript calling the VersionControl()
; EndEvent


State WaitForShowRaceMenu
	;## Wait For ShowRaceMenu to Finish ##
	Event OnUpdate()
		;If IsJournalControlsEnabled() && IsActivateControlsEnabled() && IsFightingControlsEnabled() && !IsInMenuMode()	; In case using Alternate Start mods, check if player done picking race
		;	UnregisterForUpdate()
		;	GoToState("ResetVars")
		If MQ101.GetStageDone(75) && !IsInMenuMode()	; Check if player done picking race (Vanilla Only)
			UnregisterForUpdate()
			GoToState("ResetVars")
		EndIf
	EndEvent
EndState

State ResetVars
	Event OnBeginState()
		If bShowEnableCCOPrompt == True
			bShowEnableCCOPrompt = False
			EnableCCOPrompt()
			Return	; Return if CCO is disabled so no other code runs
		EndIf
		If bPlayOpenCCOMenuSound == True
			bPlayOpenCCOMenuSound = False
			_sycSFXOpenMenu.Play(PlayerRef)	; Play sound when Menu activates
			WaitMenuMode(1.95)	; Sync Menu with Sound Effect
		EndIf
		ResetBaseStats()
		ResetMenuChoices()
		GoToState("InitializeCCOMenu")
	EndEvent
EndState

State InitializeCCOMenu
	Event OnBeginState()
		ChooseClassMenu()
	EndEvent
EndState

State AssignClassStats
	Event OnBeginState()
		CloseCCOBook()	; Close book in case CCO Menu is activated from the book
		MAGMysticismSoulTrapCapture.Play(PlayerRef)	; Play sound to indicate completion
		AssignSpecialization()
		AssignFavoredAttribute()
		AssignMajorSkills()
		GoToState("ApplyAllStats")
	EndEvent
EndState

State ApplyAllStats
	Event OnBeginState()
		ApplySkillValues()
		ToggleModules()
		If bDiverseRaceAndGendersApplied == False
			ApplyAttributes()
		EndIf
		GoToState("StopQuest")
	EndEvent
EndState

State StopQuest
	Event OnBeginState()
		Stop()
	EndEvent
EndState

;---------------------------------------------------------------------------------------------------
;### FUNCTIONS ###
;---------------------------------------------------------------------------------------------------

;### Enable CCO Prompt Function ###
;---------------------------------------------------------------------------------------------------
; Shows the menu asking whether to enable CCO on current character
Function EnableCCOPrompt(Int aiButtonChoice1 = -1)
	aiButtonChoice1 = _sycEnableCCOPromptMSG.Show()
	If aiButtonChoice1 == 0	; Yes
		bPlayOpenCCOMenuSound = True
		GoToState("ResetVars")
	ElseIf aiButtonChoice1 == 1	; No
		bCCODisabledOnCharacter = True
		GoToState("StopQuest")
	EndIf
EndFunction


;### Open CCO Book Function ###
;---------------------------------------------------------------------------------------------------
; Triggered from the script attached to _sycCCOBook ("A New Beginning")
Function OpenCCOBook(Int aiButtonChoice1 = -1)
	If bCCODisabledOnCharacter == True
		aiButtonChoice1 = _sycWriteInCCOBookPromptMSG.Show()
		If aiButtonChoice1 == 0	; Write In
			bCCODisabledOnCharacter = False
			Notification("Writing...")
			CloseCCOBook()	; Close book, otherwise if you ShowRaceMenu the ChooseRaceMenu will not appear until book is closed
			bPlayOpenCCOMenuSound = True
			GoToState("ResetVars")	; Go straight to Race Menu
		ElseIf aiButtonChoice1 == 1	; Leave Blank
			CloseCCOBook()
			Return
		EndIf
	Else
		aiButtonChoice1 = _sycReviseCCOBookPromptMSG.Show()
		If aiButtonChoice1 == 0	; Revise
			Notification("Revising...")
			UninstallCCOCurrentVersion()	; Attributes and Skills need to be reset first
			CloseCCOBook()
			bShowEnableCCOPrompt = True
			bPlayOpenCCOMenuSound = True
			GoToState("ResetVars")	; Go straight to Race Menu
		ElseIf aiButtonChoice1 == 1	; Destroy
			CloseCCOBook()
			UninstallCCO()
		ElseIf aiButtonChoice1 == 2	; Close
			CloseCCOBook()
		EndIf
	EndIf
EndFunction


;### Open CCO Book Function ###
;---------------------------------------------------------------------------------------------------
;http://forums.bethsoft.com/topic/1373468-quick-questions-quick-answers-thread-4/page__view__findpost__p__21152768
Function CloseCCOBook()
	;Game.DisablePlayerControls(False, False, False, False, False, True) ; Momentarily disable other menus
	;PlayerRef.EquipItem(_sycCCOBook, True, True) ; Prevent unequip/reequip in favorites until the current menu is resolved
	;Wait(0.01) ; This ensures equipping the token from the favorites menu works
	;PlayerRef.UnequipItem(_sycCCOBook, False, True) ; Silently unequip item
	;Game.EnablePlayerControls(False, False, False, False, False, True) ; Undo DisablePlayerControls
EndFunction


;### Reset Hidden Properties ###
;---------------------------------------------------------------------------------------------------
; Sets/resets hidden properties for uninstallation only.
Function ResetHiddenProperties()
	fVersion = 0
	bCCODisabledOnCharacter = False
	bShowEnableCCOPrompt = False
	bPlayOpenCCOMenuSound = False
	bToggleModuleNotificationsOn = False
EndFunction


;### Reset Menu Choices Function ###
;---------------------------------------------------------------------------------------------------
; Sets/resets the CCO menu choices
Function ResetMenuChoices()
	;## Clear Menu Choices ##
	iBirthsign = -1
	iSpecialization = -1
	iAttribute = -1
	iMajorSkill1 = -1
	iMajorSkill2 = -1
	iMajorSkill3 = -1
	iMajorSkill4 = -1
	iMajorSkill5 = -1
	iMajorSkill6 = -1
EndFunction


;### Reset Base Stats (Mofidiers) Function ###
;---------------------------------------------------------------------------------------------------
; Sets/resets the base stats before they are modified
Function ResetBaseStats()
	ResetAttributeAndCarryWeightModifiers()
	ResetSkillValueModifiers()
	ResetSkillRates()
EndFunction


;### Reset Attribute Modifiers Function ###
;---------------------------------------------------------------------------------------------------
Function ResetAttributeAndCarryWeightModifiers()
	fHealthModifier = 0
	fMagickaModifier = 0
	fStaminaModifier = 0
	fCarryWeightModifier = 0
EndFunction


;### Reset Skill Value Modifiers ###
;---------------------------------------------------------------------------------------------------
Function ResetSkillValueModifiers()
	fAlchemySkillModifier = 0
	fAlterationSkillModifier = 0
	fBlockSkillModifier = 0
	fConjurationSkillModifier = 0
	fDestructionSkillModifier = 0
	fEnchantingSkillModifier = 0
	fHeavyArmorSkillModifier = 0
	fIllusionSkillModifier = 0
	fLightArmorSkillModifier = 0
	fLockpickingSkillModifier = 0
	fMarksmanSkillModifier = 0
	fOneHandedSkillModifier = 0
	fPickpocketSkillModifier = 0
	fRestorationSkillModifier = 0
	fSmithingSkillModifier = 0
	fSneakSkillModifier = 0
	fSpeechcraftSkillModifier = 0
	fTwoHandedSkillModifier = 0
EndFunction


;### Reset Skill Rate Modifiers ###
;---------------------------------------------------------------------------------------------------
Function ResetSkillRates()
	; Set all skill rates to 20% (5x more XP)
	fAlchemySkillRate = 20
	fAlterationSkillRate = 20
	fBlockSkillRate = 20
	fConjurationSkillRate = 20
	fDestructionSkillRate = 20
	fEnchantingSkillRate = 20
	fHeavyArmorSkillRate = 20
	fIllusionSkillRate = 20
	fLightArmorSkillRate = 20
	fLockpickingSkillRate = 20
	fMarksmanSkillRate = 20
	fOneHandedSkillRate = 20
	fPickpocketSkillRate = 20
	fRestorationSkillRate = 20
	fSmithingSkillRate = 20
	fSneakSkillRate = 20
	fSpeechcraftSkillRate = 20
	fTwoHandedSkillRate = 20
EndFunction


;### Choose Class Menu Function ###
;---------------------------------------------------------------------------------------------------
; This function shows the Choose Class Menu
Function ChooseClassMenu(Int aiMessageToDisplay = 0, Int aiButtonChoice1 = 0, Bool abMenu = True)
	; Set Default Menu Choices
	iSpecialization = -1
	iAttribute = -1
	iMajorSkill1 = -1
	iMajorSkill2 = -1
	iMajorSkill3 = -1
	iMajorSkill4 = -1
	iMajorSkill5 = -1
	iMajorSkill6 = -1
	While abMenu
		If aiButtonChoice1 == -1 ; Can prevent problems if recycling aiButtonChoice1

		;## [0] Choose Your Class ##
		ElseIf aiMessageToDisplay == 0
			aiButtonChoice1 = _sycChooseClassMSG.Show()
			If aiButtonChoice1 == 0	; Combat Classes
				aiMessageToDisplay = 1
			ElseIf aiButtonChoice1 == 1	; Magic Classes
				aiMessageToDisplay = 2
			ElseIf aiButtonChoice1 == 2	; Stealth Classes
				aiMessageToDisplay = 3
			ElseIf aiButtonChoice1 == 3	; Custom Class
				aiMessageToDisplay = 4
			EndIf

		;## [1] Combat Classes ##
		ElseIf aiMessageToDisplay == 1
			aiButtonChoice1 = _sycCombatClassesMSG.Show()
			If aiButtonChoice1 == 0 ; Archer
				aiButtonChoice1 = _sycClassArcherMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 3
					iMajorSkill3 = 4
					iMajorSkill4 = 11
					iMajorSkill5 = 13
					iMajorSkill6 = 16
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 1 ; Barbarian
				aiButtonChoice1 = _sycClassBarbarianMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 0
					iMajorSkill1 = 0
					iMajorSkill2 = 1
					iMajorSkill3 = 3
					iMajorSkill4 = 4
					iMajorSkill5 = 5
					iMajorSkill6 = 13
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 2 ; Crusader
				aiButtonChoice1 = _sycClassCrusaderMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 0
					iMajorSkill1 = 1
					iMajorSkill2 = 2
					iMajorSkill3 = 3
					iMajorSkill4 = 5
					iMajorSkill5 = 8
					iMajorSkill6 = 11
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 3 ; Knight
				aiButtonChoice1 = _sycClassKnightMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 0
					iMajorSkill1 = 1
					iMajorSkill2 = 2
					iMajorSkill3 = 3
					iMajorSkill4 = 5
					iMajorSkill5 = 10
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 4 ; Rogue
				aiButtonChoice1 = _sycClassRogueMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 2
					iMajorSkill1 = 1
					iMajorSkill2 = 3
					iMajorSkill3 = 10
					iMajorSkill4 = 12
					iMajorSkill5 = 13
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 5 ; Scout
				aiButtonChoice1 = _sycClassScoutMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 1
					iMajorSkill3 = 3
					iMajorSkill4 = 4
					iMajorSkill5 = 12
					iMajorSkill6 = 13
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 6 ; Warrior
				aiButtonChoice1 = _sycClassWarriorMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 0
					iAttribute = 0
					iMajorSkill1 = 0
					iMajorSkill2 = 1
					iMajorSkill3 = 2
					iMajorSkill4 = 3
					iMajorSkill5 = 4
					iMajorSkill6 = 5
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 7	; Back
				aiMessageToDisplay = 0
			EndIf
		;## [2] Magic Classes ##
		ElseIf aiMessageToDisplay == 2	; Magic Classes
			aiButtonChoice1 = _sycMagicClassesMSG.Show()
			If aiButtonChoice1 == 0 ; Battlemage
				aiButtonChoice1 = _sycClassBattlemageMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 1
					iMajorSkill1 = 3
					iMajorSkill2 = 6
					iMajorSkill3 = 7
					iMajorSkill4 = 8
					iMajorSkill5 = 9
					iMajorSkill6 = 12
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 1 ; Healer
				aiButtonChoice1 = _sycClassHealerMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 1
					iMajorSkill1 = 6
					iMajorSkill2 = 8
					iMajorSkill3 = 10
					iMajorSkill4 = 11
					iMajorSkill5 = 12
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 2 ; Mage
				aiButtonChoice1 = _sycClassMageMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 1
					iMajorSkill1 = 6
					iMajorSkill2 = 7
					iMajorSkill3 = 8
					iMajorSkill4 = 9
					iMajorSkill5 = 10
					iMajorSkill6 = 11
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 3 ; Nightblade
				aiButtonChoice1 = _sycClassNightbladeMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 1
					iMajorSkill1 = 3
					iMajorSkill2 = 6
					iMajorSkill3 = 8
					iMajorSkill4 = 11
					iMajorSkill5 = 13
					iMajorSkill6 = 16
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 4 ; Sorcerer
				aiButtonChoice1 = _sycClassSorcererMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 1
					iMajorSkill1 = 2
					iMajorSkill2 = 6
					iMajorSkill3 = 7
					iMajorSkill4 = 8
					iMajorSkill5 = 9
					iMajorSkill6 = 11
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 5 ; Spellsword
				aiButtonChoice1 = _sycClassSpellswordMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 0
					iMajorSkill1 = 2
					iMajorSkill2 = 3
					iMajorSkill3 = 6
					iMajorSkill4 = 8
					iMajorSkill5 = 10
					iMajorSkill6 = 11
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 6 ; Witchhunter
				aiButtonChoice1 = _sycClassWitchhunterMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 1
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 7
					iMajorSkill3 = 8
					iMajorSkill4 = 9
					iMajorSkill5 = 12
					iMajorSkill6 = 14
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 7	; Back
				aiMessageToDisplay = 0
			EndIf
		;## [3] Stealth Classes ##
		ElseIf aiMessageToDisplay == 3	; Stealth Classes
			aiButtonChoice1 = _sycStealthClassesMSG.Show()
			If aiButtonChoice1 == 0 ; Acrobat
				aiButtonChoice1 = _sycClassAcrobatMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 1
					iMajorSkill3 = 3
					iMajorSkill4 = 14
					iMajorSkill5 = 16
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 1 ; Agent
				aiButtonChoice1 = _sycClassAgentMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 10
					iMajorSkill3 = 14
					iMajorSkill4 = 15
					iMajorSkill5 = 16
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 2 ; Assassin
				aiButtonChoice1 = _sycClassAssassinMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 3
					iMajorSkill3 = 12
					iMajorSkill4 = 13
					iMajorSkill5 = 14
					iMajorSkill6 = 16
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 3 ; Bard
				aiButtonChoice1 = _sycClassBardMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 2
					iMajorSkill1 = 1
					iMajorSkill2 = 3
					iMajorSkill3 = 10
					iMajorSkill4 = 12
					iMajorSkill5 = 13
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 4 ; Monk
				aiButtonChoice1 = _sycClassMonkMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 1
					iMajorSkill3 = 6
					iMajorSkill4 = 11
					iMajorSkill5 = 14
					iMajorSkill6 = 16
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 5 ; Pilgrim
				aiButtonChoice1 = _sycClassPilgrimMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 0
					iMajorSkill1 = 1
					iMajorSkill2 = 4
					iMajorSkill3 = 5
					iMajorSkill4 = 13
					iMajorSkill5 = 14
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 6 ; Thief
				aiButtonChoice1 = _sycClassThiefMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 5
					iSpecialization = 2
					iAttribute = 2
					iMajorSkill1 = 0
					iMajorSkill2 = 13
					iMajorSkill3 = 14
					iMajorSkill4 = 15
					iMajorSkill5 = 16
					iMajorSkill6 = 17
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 7	; Back
				aiMessageToDisplay = 0
			EndIf
		;## [4] Create Custom Class ##
		ElseIf aiMessageToDisplay == 4	; Custom Class
			abMenu = False	; Stop While Loop and close menu
			CreateCustomClassMenu()

		;## [5] Close Menu (Standard Classes Only) ##
		ElseIf aiMessageToDisplay == 5
			abMenu = False	; Stop While Loop and close menu
			GoToState("AssignClassStats")
		EndIf
	EndWhile
EndFunction


;### Create Custom Class Menu Function ###
;---------------------------------------------------------------------------------------------------
; This function shows the Create Custom Class Creation Menu
Function CreateCustomClassMenu(Int aiMessageToDisplay = 0, Int aiButtonChoice1 = 0, Int aiButtonChoice2 = 0, Bool abMenu = True)
	; Set Default Menu Choices
	iSpecialization = -1
	iAttribute = -1
	iMajorSkill1 = -1
	iMajorSkill2 = -1
	iMajorSkill3 = -1
	iMajorSkill4 = -1
	iMajorSkill5 = -1
	iMajorSkill6 = -1
	While abMenu
		If aiButtonChoice1 == -1 ; Can prevent problems if recycling aiButtonChoice1 and aiButtonChoice2
		ElseIf aiButtonChoice2 == -1
		;## [0] Choose A Specialization ##
		ElseIf aiMessageToDisplay == 0
            aiButtonChoice1 = _sycChooseSpecializationDSPMSG.Show()
			iSpecialization = aiButtonChoice1	; Record Choice
			If aiButtonChoice1 == 0 ; Combat
                aiButtonChoice1 = _sycCombatSpecializationDSPMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 1
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 1 ; Magic
                aiButtonChoice1 = _sycMagicSpecializationDSPMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 1
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			ElseIf aiButtonChoice1 == 2 ; Stealth
                aiButtonChoice1 = _sycStealthSpecializationDSPMSG.Show()
				If aiButtonChoice1 == 0 ; Choose
					aiMessageToDisplay = 1
				ElseIf aiButtonChoice1 == 1 ; Back
					aiMessageToDisplay = 0
				EndIf
			;## Back to Class Menu ##
			ElseIf aiButtonChoice1 == 3 ; Back
				abMenu = False	; Stop While Loop and close menu
				ChooseClassMenu()
			EndIf
		;## [1] Choose A Favored Attribute ##
		ElseIf aiMessageToDisplay == 1
			aiButtonChoice1 = _sycChooseAttributeMSG.Show()
			iAttribute = aiButtonChoice1	; Record Choice
			If aiButtonChoice1 < 3	; Health, Magic, Stamina
				aiMessageToDisplay = 2
			ElseIf aiButtonChoice1 == 3 ; Back
				aiMessageToDisplay = 0
			EndIf
		;## [2-7] Choose Your Major Skills (6 Left) ##
		ElseIf aiMessageToDisplay <= 7
			; Show different message depending on how many skills left to pick
			If aiMessageToDisplay == 2
                aiButtonChoice1 = _sycChooseMajorSkill1DSPMSG.Show()
			ElseIf aiMessageToDisplay == 3
                aiButtonChoice1 = _sycChooseMajorSkill2DSPMSG.Show()
			ElseIf aiMessageToDisplay == 4
                aiButtonChoice1 = _sycChooseMajorSkill3DSPMSG.Show()
			ElseIf aiMessageToDisplay == 5
                aiButtonChoice1 = _sycChooseMajorSkill4DSPMSG.Show()
			ElseIf aiMessageToDisplay == 6
                aiButtonChoice1 = _sycChooseMajorSkill5DSPMSG.Show()
			ElseIf aiMessageToDisplay == 7
                aiButtonChoice1 = _sycChooseMajorSkill6DSPMSG.Show()
			EndIf
			;## Combat Skills ##
			If aiButtonChoice1 == 0	; Combat Skills
				aiButtonChoice1 = _sycCombatSkillsMSG.Show()
				If aiButtonChoice1 == 0 ; Archery
					aiButtonChoice2 = _sycSkillArcheryMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 1	; Block
					aiButtonChoice2 = _sycSkillBlockMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 2	; Heavy Armor
					aiButtonChoice2 = _sycSkillHeavyArmorMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 3	; One-handed
					aiButtonChoice2 = _sycSkillOneHandedMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 4	; Smithing
					aiButtonChoice2 = _sycSkillSmithingMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 5	; Two-handed
					aiButtonChoice2 = _sycSkillTwoHandedMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 6	; Back
				EndIf
			;## Magic Skills ##
			ElseIf aiButtonChoice1 == 1	; Magic Skills
				aiButtonChoice1 = _sycMagicSkillsMSG.Show()
				If aiButtonChoice1 == 0 ; Alteration
					aiButtonChoice2 = _sycSkillAlterationMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 6
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 1	; Conjuration
					aiButtonChoice2 = _sycSkillConjurationMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 6
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 2	; Destruction
					aiButtonChoice2 = _sycSkillDestructionMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 6
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 3	; Enchantment
					aiButtonChoice2 = _sycSkillEnchantingMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 6
						EndIf
						aiMessageToDisplay += 1
						ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 4	; Illusion
					aiButtonChoice2 = _sycSkillIllusionMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 6
						EndIf
						aiMessageToDisplay += 1
						ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 5	; Restoration
					aiButtonChoice2 = _sycSkillRestorationMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 6
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 6
						EndIf
						aiMessageToDisplay += 1
						ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 6	; Back
				EndIf
			;## Stealth Skills ##
			ElseIf aiButtonChoice1 == 2	; Stealth Skills
				aiButtonChoice1 = _sycStealthSkillsMSG.Show()
				If aiButtonChoice1 == 0 ; Alchemy
					aiButtonChoice2 = _sycSkillAlchemyMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 12
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 1	; Light Armor
					aiButtonChoice2 = _sycSkillLightArmorMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 12
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 2	; Lockpicking
					aiButtonChoice2 = _sycSkillLockpickingMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 12
						EndIf
						aiMessageToDisplay += 1
					ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 3	; Pickpocketing
					aiButtonChoice2 = _sycSkillPickpocketMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 12
						EndIf
						aiMessageToDisplay += 1
						ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 4	; Sneak
					aiButtonChoice2 = _sycSkillSneakMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 12
						EndIf
						aiMessageToDisplay += 1
						ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 5	; Speech
					aiButtonChoice2 = _sycSkillSpeechMSG.Show()
					If aiButtonChoice2 == 0 ; Choose
						; Store as the 1st, 2nd, 3rd, 4th, 5th, or 6th, Major Skill choice
						If aiMessageToDisplay == 2
							iMajorSkill1 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 3
							iMajorSkill2 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 4
							iMajorSkill3 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 5
							iMajorSkill4 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 6
							iMajorSkill5 = aiButtonChoice1 + 12
						ElseIf aiMessageToDisplay == 7
							iMajorSkill6 = aiButtonChoice1 + 12
						EndIf
						aiMessageToDisplay += 1
						ElseIf aiButtonChoice2 == 1 ; Back
					EndIf
				ElseIf aiButtonChoice1 == 6	; Back
				EndIf
			ElseIf aiButtonChoice1 == 3 ; Back
				aiMessageToDisplay -= 1
				; If going back, clear the last Major Skill selection
				If aiMessageToDisplay == 2
					iMajorSkill1 = -1
				ElseIf aiMessageToDisplay == 3
					iMajorSkill2 = -1
				ElseIf aiMessageToDisplay == 4
					iMajorSkill3 = -1
				ElseIf aiMessageToDisplay == 5
					iMajorSkill4 = -1
				ElseIf aiMessageToDisplay == 6
					iMajorSkill5 = -1
				ElseIf aiMessageToDisplay == 7
					iMajorSkill6 = -1
				EndIf
			EndIf

		;## [8] Close Menu ##
		ElseIf aiMessageToDisplay == 8
			abMenu = False	; Stop While Loop and close menu
			GoToState("AssignClassStats")
		EndIf
	EndWhile
EndFunction


;### Assign Specialization Function ###
;---------------------------------------------------------------------------------------------------
; Assign Specialization skills
Function AssignSpecialization()
EndFunction


;### Assign Favored Attribute Function ###
;---------------------------------------------------------------------------------------------------
; Assigns favored attribute bonus
Function AssignFavoredAttribute()
	If iAttribute == 0 ; Health
		fHealthModifier += 20
	ElseIf iAttribute == 1 ; Magicka
		fMagickaModifier += 20
	ElseIf iAttribute == 2 ; Stamina
		fStaminaModifier += 20
	EndIf
EndFunction


;### Assign Major Skills Function ###
;---------------------------------------------------------------------------------------------------
; Assign Major Skills skills
Function AssignMajorSkills()
	Int aiElement = 0
	Int[] arMajorSkills = New Int[6]	; Declare Major Skills Array that will be filled by aiMajorSkillX's
	arMajorSkills[0]= iMajorSkill1
	arMajorSkills[1]= iMajorSkill2
	arMajorSkills[2]= iMajorSkill3
	arMajorSkills[3]= iMajorSkill4
	arMajorSkills[4]= iMajorSkill5
	arMajorSkills[5]= iMajorSkill6
	aiElement = arMajorSkills.Length
	While aiElement > 0
		aiElement -= 1
		; Combat Skills
		If arMajorSkills[aiElement] == 0	; Archery
			fMarksmanSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 1	; Block
			fBlockSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 2	; Heavy Armor
			fHeavyArmorSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 3	; One-Handed
			fOneHandedSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 4	; Smithing
			fSmithingSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 5	; TwoHanded
			fTwoHandedSkillModifier += 5
		; Magic Skills
		ElseIf arMajorSkills[aiElement] == 6	; Alteration
			fAlterationSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 7	; Conjuration
			fConjurationSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 8	; Destruction
			fDestructionSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 9	; Enchanting
			fEnchantingSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 10	; Illusion
			fIllusionSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 11	; Restoration
			fRestorationSkillModifier += 5
		; Stealth Skills
		ElseIf arMajorSkills[aiElement] == 12	; Alchemy
			fAlchemySkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 13	; Light Armor
			fLightArmorSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 14	; Lockpicking
			fLockpickingSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 15	; Pickpocket
			fPickpocketSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 16	; Sneak
			fSneakSkillModifier += 5
		ElseIf arMajorSkills[aiElement] == 17	; Speech
			fSpeechcraftSkillModifier += 5
		EndIf
	EndWhile
EndFunction


;### Apply Attributes Function ###
;---------------------------------------------------------------------------------------------------
Function ApplyAttributes()
	;## Apply Attributes ##
	Float fTemp = PlayerRef.GetBaseAV("Health")
	PlayerRef.SetAV("Health", PlayerRef.GetBaseAV("Health") + fHealthModifier)
	PlayerRef.SetAV("Magicka", PlayerRef.GetBaseAV("Magicka") + fMagickaModifier)
	PlayerRef.SetAV("Stamina", PlayerRef.GetBaseAV("Stamina") + fStaminaModifier)
EndFunction


;### Apply Skill Values Function ###
;---------------------------------------------------------------------------------------------------
Function ApplySkillValues()
	; Sets all starting skills to level 1 before adding modifiers. Current skill level taken into account for existing characters.
	; Racial skill bonuses are derived from the editor for compatibility with mods that change racial skill bonuses
	Int iStartingSkillLevel = GetGameSettingInt("iAVDSkillStart")
	PlayerRef.SetAV("Alchemy", PlayerRef.GetBaseAV("Alchemy") - iStartingSkillLevel + fAlchemySkillModifier)
	PlayerRef.SetAV("Alteration", PlayerRef.GetBaseAV("Alteration") - iStartingSkillLevel + fAlterationSkillModifier)
	PlayerRef.SetAV("Block", PlayerRef.GetBaseAV("Block") - iStartingSkillLevel + fBlockSkillModifier)
	PlayerRef.SetAV("Conjuration", PlayerRef.GetBaseAV("Conjuration") - iStartingSkillLevel + fConjurationSkillModifier)
	PlayerRef.SetAV("Destruction", PlayerRef.GetBaseAV("Destruction") - iStartingSkillLevel + fDestructionSkillModifier)
	PlayerRef.SetAV("Enchanting", PlayerRef.GetBaseAV("Enchanting") - iStartingSkillLevel + fEnchantingSkillModifier)
	PlayerRef.SetAV("HeavyArmor", PlayerRef.GetBaseAV("HeavyArmor") - iStartingSkillLevel + fHeavyArmorSkillModifier)
	PlayerRef.SetAV("Illusion", PlayerRef.GetBaseAV("Illusion") - iStartingSkillLevel + fIllusionSkillModifier)
	PlayerRef.SetAV("LightArmor", PlayerRef.GetBaseAV("LightArmor") - iStartingSkillLevel + fLightArmorSkillModifier)
	PlayerRef.SetAV("Lockpicking", PlayerRef.GetBaseAV("Lockpicking") - iStartingSkillLevel + fLockpickingSkillModifier)
	PlayerRef.SetAV("Marksman", PlayerRef.GetBaseAV("Marksman") - iStartingSkillLevel + fMarksmanSkillModifier)
	PlayerRef.SetAV("OneHanded", PlayerRef.GetBaseAV("OneHanded") - iStartingSkillLevel + fOneHandedSkillModifier)
	PlayerRef.SetAV("Pickpocket", PlayerRef.GetBaseAV("Pickpocket") - iStartingSkillLevel + fPickpocketSkillModifier)
	PlayerRef.SetAV("Restoration", PlayerRef.GetBaseAV("Restoration") - iStartingSkillLevel + fRestorationSkillModifier)
	PlayerRef.SetAV("Smithing", PlayerRef.GetBaseAV("Smithing") - iStartingSkillLevel + fSmithingSkillModifier)
	PlayerRef.SetAV("Sneak", PlayerRef.GetBaseAV("Sneak") - iStartingSkillLevel + fSneakSkillModifier)
	PlayerRef.SetAV("Speechcraft", PlayerRef.GetBaseAV("Speechcraft") - iStartingSkillLevel + fSpeechcraftSkillModifier)
	PlayerRef.SetAV("TwoHanded", PlayerRef.GetBaseAV("TwoHanded") - iStartingSkillLevel + fTwoHandedSkillModifier)
EndFunction


;---------------------------------------------------------------------------------------------------
;### UPGRADE/UNINSTALL FUNCTIONS ###
;---------------------------------------------------------------------------------------------------

;### Uninstall CCO Function ###
;---------------------------------------------------------------------------------------------------
Function UninstallCCO(Int aiButtonChoice1 = -1)
	If bCCODisabledOnCharacter == True	; Don't run uninstaller if CCO is disabled on character
		; Do Nothing
	Else
		; Check whether any CCO menu choices have been selected
		If (iSpecialization + iAttribute + iMajorSkill1 + iMajorSkill2 + iMajorSkill3 + iMajorSkill4 + iMajorSkill5 + iMajorSkill6) <= 0
			_sycCCOUninstallerActivatedByAccidentMSG.Show()
			VersionControl()
		Else	; Choices made
			aiButtonChoice1 = _sycConfirmUninstallCCOMSG.Show()
			If aiButtonChoice1 == 0	; Yes
				Notification("Character Creation Overhaul is uninstalling. Please wait...")
				If fVersion <= 1.20
					UninstallCCOV120()
				ElseIf fVersion <= 1.32
					UninstallCCOCurrentVersion()
				Else
					MessageBox("ERROR: CCO Version Not Recognized.")
				EndIf
				;## Clear All Variables ##
				; Clear all variables incase user re-installs CCO later
				ResetBaseStats()
				ResetMenuChoices()
				ResetHiddenProperties()
				_sycCCOUninstallationCompleteMSG.Show()
				UnregisterForUpdate()
				Stop()
			ElseIf aiButtonChoice1 == 1	; No
				_sycCCOUninstallationCanceledMSG.Show()
				VersionControl()
			EndIf
		EndIf
	EndIf
EndFunction


;### Uninstall CCO v1.0.0 to v1.2.0 Function ###
;---------------------------------------------------------------------------------------------------
Function UninstallCCOV120()
	;## Unapply Modules ##
	DisableDynamicSkillProgressionV120()	; Deprecated
	;## Re-assign All Stats ##
	; Re-assign stats so they can be properly unapplied
	ResetBaseStats()
	AssignRaceStatsV120()	; Deprecated
	AssignSpecialization()
	AssignFavoredAttribute()
	AssignMajorSkills()
	;## Unapply All Stats ##
	UnapplyAttributes()
	UnapplyCarryWeightV120()	; Deprecated
	UnapplySkillValues()
	ResetBaseStats()	; Reset stats after unapplying them
EndFunction

;### Uninstall CCO v1.3.0 Function ###
;---------------------------------------------------------------------------------------------------
Function UninstallCCOCurrentVersion()
	;## Unapply Modules ##
	UnapplyModules()
	;## Re-assign All Stats ##
	; Re-assign stats so they can be properly unapplied
	ResetBaseStats()
	AssignSpecialization()
	AssignFavoredAttribute()
	AssignMajorSkills()
	;## Unapply All Stats ##
	UnapplyAttributes()
	UnapplySkillValues()
	RemoveItems()
EndFunction


;### Unapply Attributes Function ###
;---------------------------------------------------------------------------------------------------
Function UnapplyAttributes()
	PlayerRef.SetAV("Health", PlayerRef.GetBaseAV("Health") - fHealthModifier)
	PlayerRef.SetAV("Magicka", PlayerRef.GetBaseAV("Magicka") - fMagickaModifier)
	PlayerRef.SetAV("Stamina", PlayerRef.GetBaseAV("Stamina") - fStaminaModifier)
EndFunction


;### Unapply Skill Values Function ###
;---------------------------------------------------------------------------------------------------
Function UnapplySkillValues()
	Int iStartingSkillLevel = GetGameSettingInt("iAVDSkillStart")
	PlayerRef.SetAV("Alchemy", PlayerRef.GetBaseAV("Alchemy") + iStartingSkillLevel - fAlchemySkillModifier)
	PlayerRef.SetAV("Alteration", PlayerRef.GetBaseAV("Alteration") + iStartingSkillLevel - fAlterationSkillModifier)
	PlayerRef.SetAV("Block", PlayerRef.GetBaseAV("Block") + iStartingSkillLevel - fBlockSkillModifier)
	PlayerRef.SetAV("Conjuration", PlayerRef.GetBaseAV("Conjuration") + iStartingSkillLevel - fConjurationSkillModifier)
	PlayerRef.SetAV("Destruction", PlayerRef.GetBaseAV("Destruction") + iStartingSkillLevel - fDestructionSkillModifier)
	PlayerRef.SetAV("Enchanting", PlayerRef.GetBaseAV("Enchanting") + iStartingSkillLevel - fEnchantingSkillModifier)
	PlayerRef.SetAV("HeavyArmor", PlayerRef.GetBaseAV("HeavyArmor") + iStartingSkillLevel - fHeavyArmorSkillModifier)
	PlayerRef.SetAV("Illusion", PlayerRef.GetBaseAV("Illusion") + iStartingSkillLevel - fIllusionSkillModifier)
	PlayerRef.SetAV("LightArmor", PlayerRef.GetBaseAV("LightArmor") + iStartingSkillLevel - fLightArmorSkillModifier)
	PlayerRef.SetAV("Lockpicking", PlayerRef.GetBaseAV("Lockpicking") + iStartingSkillLevel - fLockpickingSkillModifier)
	PlayerRef.SetAV("Marksman", PlayerRef.GetBaseAV("Marksman") + iStartingSkillLevel - fMarksmanSkillModifier)
	PlayerRef.SetAV("OneHanded", PlayerRef.GetBaseAV("OneHanded") + iStartingSkillLevel - fOneHandedSkillModifier)
	PlayerRef.SetAV("Pickpocket", PlayerRef.GetBaseAV("Pickpocket") + iStartingSkillLevel - fPickpocketSkillModifier)
	PlayerRef.SetAV("Restoration", PlayerRef.GetBaseAV("Restoration") + iStartingSkillLevel - fRestorationSkillModifier)
	PlayerRef.SetAV("Smithing", PlayerRef.GetBaseAV("Smithing") + iStartingSkillLevel - fSmithingSkillModifier)
	PlayerRef.SetAV("Sneak", PlayerRef.GetBaseAV("Sneak") + iStartingSkillLevel - fSneakSkillModifier)
	PlayerRef.SetAV("Speechcraft", PlayerRef.GetBaseAV("Speechcraft") + iStartingSkillLevel - fSpeechcraftSkillModifier)
	PlayerRef.SetAV("TwoHanded", PlayerRef.GetBaseAV("TwoHanded") + iStartingSkillLevel - fTwoHandedSkillModifier)
EndFunction


;### Unapply Modules Function ###
;---------------------------------------------------------------------------------------------------
; Used by the Uninstaller to unapply changes from optional CCO modules.
Function UnapplyModules()
	DisableDynamicSkillProgression()
EndFunction


;### Remove Items Function ###
;---------------------------------------------------------------------------------------------------
Function RemoveItems(Int aiCount = 0)
	aiCount = PlayerRef.GetItemCount(_sycCCOBook)
	PlayerRef.RemoveItem(_sycCCOBook, aiCount, True)
EndFunction


;---------------------------------------------------------------------------------------------------
;### VERSION CONTROL FUNCTIONS ###
;---------------------------------------------------------------------------------------------------

;### Version Control Function ###
;---------------------------------------------------------------------------------------------------
; Upgrade CCO from previous versions
Function VersionControl(Int aiButtonChoice1 = -1)
	fLatestVersion = 1.32	;! Set Latest Version
	If bCCODisabledOnCharacter == True	; Don't run if CCO is disabled on character
		; Do Nothing
	Else
		; Check whether any CCO menu choices have been selected
		;## First Time Using CCO ##
		If (iSpecialization + iAttribute + iMajorSkill1 + iMajorSkill2 + iMajorSkill3 + iMajorSkill4 + iMajorSkill5 + iMajorSkill6) <= 0
			bShowEnableCCOPrompt = True
			bPlayOpenCCOMenuSound = True
			bToggleModuleNotificationsOn = True	; Only show notifications OnPlayerLoad
			RegisterForUpdate(1)	; Check for Race Menu every every 1 seconds
			GoToState("WaitForShowRaceMenu")
		;## Not First Run ##
		Else	; Choices Made
			If fVersion <= 1.10
				UpgradeCCOFromV110()
			ElseIf fVersion == 1.20
				UpgradeCCOFromV120()
			ElseIf fVersion == 1.30	; 1.3.0 does not need to be upgraded to 1.3.2
				bToggleModuleNotificationsOn = True	; Only show notifications OnPlayerLoad
				ToggleModules()	; Run every OnPlayerLoadGame except during first run and upgrades
			;## Version Is Up To Date ##
			ElseIf fVersion == fLatestVersion
				bToggleModuleNotificationsOn = True	; Only show notifications OnPlayerLoad
				ToggleModules()	; Run every OnPlayerLoadGame except during first run and upgrades
			Else
				MessageBox("ERROR: CCO Version Not Recognized.")
			EndIf
		EndIf
		fVersion = fLatestVersion
	EndIf
EndFunction


;### Upgrade CCO from v1.1.0 Function ###
;---------------------------------------------------------------------------------------------------
; Player must re-select birthsign and class when upgrading from v1.1.0
Function UpgradeCCOFromV110()
	_sycUpgradeCCOMSG.Show(fLatestVersion)
	Notification("Character Creation Overhaul is upgrading. Please wait...")
	UninstallCCOV120()
	;## Wait For ShowRaceMenu ##
	; Once all CCO stats are unapplied, open the CCO menu again
	bShowEnableCCOPrompt = True
	bPlayOpenCCOMenuSound = True
	bToggleModuleNotificationsOn = True
	RegisterForUpdate(1)
	GoToState("WaitForShowRaceMenu")
EndFunction


;### Upgrade CCO from v1.2.0 Function ###
;---------------------------------------------------------------------------------------------------
Function UpgradeCCOFromV120(Int aiButtonChoice1 = -1)
	aiButtonChoice1 = _sycUpgradeCCOOptionsMSG.Show(fLatestVersion)
	Notification("Character Creation Overhaul is upgrading. Please wait...")
	UninstallCCOV120()
	If aiButtonChoice1 == 0	; Keep Choices
		GoToState("AssignClassStats")	; Skip the ResetVars state to keep choices
	ElseIf aiButtonChoice1 == 1	; Respecialize
		;## Wait For ShowRaceMenu ##
		; Once all CCO stats are unapplied, open the CCO menu again
		bShowEnableCCOPrompt = True
		bPlayOpenCCOMenuSound = True
		bToggleModuleNotificationsOn = True
		RegisterForUpdate(1)
		GoToState("WaitForShowRaceMenu")
	EndIf
EndFunction


;---------------------------------------------------------------------------------------------------
;### MODULE FUNCTIONS ###
;---------------------------------------------------------------------------------------------------

;### Toggle Modules Function ###
;---------------------------------------------------------------------------------------------------
; Ativate/deactivate optional CCO modules by checking whether the relevant .esp is loaded
Function ToggleModules()
	;## Dynamic Skill Rate Progression ##
    EnableDynamicSkillProgression()
	bToggleModuleNotificationsOn = False	; Stop showing notifications after OnPlayerLoad
EndFunction


;### Enable Dynamic Skill Progression Function ###
;---------------------------------------------------------------------------------------------------
; Adds skill rate spells based on menu choices
Function EnableDynamicSkillProgression()
	If bDynamicSkillProgressionApplied == False	; Only enable if disabled
		bDynamicSkillProgressionApplied = True
		If bToggleModuleNotificationsOn == True
			Notification("Enabling Dynamic Skill Progression...")
		EndIf

		;## Reset Skill Rates ##
		ResetSkillRates()

		;## Assign Race Skill Rates ##
		If PlayerRef.GetRace() == ArgonianRace || PlayerRef.GetRace() == ArgonianRaceVampire
			fAlterationSkillRate += 10
			fLightArmorSkillRate += 15
			fLockpickingSkillRate += 15
			fPickpocketSkillRate += 10
			fRestorationSkillRate += 10
			fSneakSkillRate += 10
			PlayerRef.AddSpell(ArgonianSkillExpBuff)
		ElseIf PlayerRef.GetRace() == BretonRace || PlayerRef.GetRace() == BretonRaceVampire
			fAlchemySkillRate += 10
			fAlterationSkillRate += 10
			fConjurationSkillRate += 20
			fIllusionSkillRate += 10
			fRestorationSkillRate += 10
			fSpeechcraftSkillRate += 10
			PlayerRef.AddSpell(BretonSkillExpBuff)
		ElseIf PlayerRef.GetRace() == DarkElfRace || PlayerRef.GetRace() == DarkElfRaceVampire
			fOneHandedSkillRate += 15
			fAlterationSkillRate += 10
			fDestructionSkillRate += 15
			fIllusionSkillRate += 10
			fLightArmorSkillRate += 10
			fSneakSkillRate += 10
			PlayerRef.AddSpell(DarkElfSkillExpBuff)
		ElseIf PlayerRef.GetRace() == HighElfRace || PlayerRef.GetRace() == HighElfRaceVampire
			fAlterationSkillRate += 10
			fConjurationSkillRate += 10
			fDestructionSkillRate += 15
			fEnchantingSkillRate += 10
			fIllusionSkillRate += 15
			fRestorationSkillRate += 10
			PlayerRef.AddSpell(HighElfSkillExpBuff)
		ElseIf PlayerRef.GetRace() == ImperialRace || PlayerRef.GetRace() == ImperialRaceVampire
			fBlockSkillRate += 10
			fDestructionSkillRate += 10
			fSpeechcraftSkillRate += 15
			fHeavyArmorSkillRate += 10
			fOneHandedSkillRate += 10
			fRestorationSkillRate += 15
			PlayerRef.AddSpell(ImperialSkillExpBuff)
		ElseIf PlayerRef.GetRace() == KhajiitRace || PlayerRef.GetRace() == KhajiitRaceVampire
			fAlchemySkillRate += 10
			fMarksmanSkillRate += 10
			fLockpickingSkillRate += 10
			fOneHandedSkillRate += 10
			fPickpocketSkillRate += 10
			fSneakSkillRate += 20
			PlayerRef.AddSpell(KhajitSkillExpBuff)
		ElseIf PlayerRef.GetRace() == NordRace || PlayerRef.GetRace() == NordRaceVampire
			fBlockSkillRate += 10
			fLightArmorSkillRate += 10
			fOneHandedSkillRate += 10
			fSmithingSkillRate += 15
			fHeavyArmorSkillRate += 10
			fTwoHandedSkillRate += 15
			PlayerRef.AddSpell(NordSkillExpBuff)
		ElseIf PlayerRef.GetRace() == OrcRace || PlayerRef.GetRace() == OrcRaceVampire
			fBlockSkillRate += 10
			fLightArmorSkillRate += 10
			fHeavyArmorSkillRate += 15
			fOneHandedSkillRate += 10
			fSmithingSkillRate += 15
			fTwoHandedSkillRate += 10
			PlayerRef.AddSpell(OrcSkillExpBuff)
		ElseIf PlayerRef.GetRace() == RedguardRace || PlayerRef.GetRace() == RedguardRaceVampire
			fAlterationSkillRate += 10
			fBlockSkillRate += 10
			fDestructionSkillRate += 10
			fMarksmanSkillRate += 10
			fOneHandedSkillRate += 20
			fSmithingSkillRate += 10
			PlayerRef.AddSpell(RedguardSkillExpBuff)
		ElseIf PlayerRef.GetRace() == WoodElfRace || PlayerRef.GetRace() == WoodElfRaceVampire
			fAlchemySkillRate += 10
			fLightArmorSkillRate += 10
			fMarksmanSkillRate += 20
			fLockpickingSkillRate += 10
			fPickpocketSkillRate += 10
			fSneakSkillRate += 10
			PlayerRef.AddSpell(WoodElfSkillExpBuff)
		Else
			; Custom Race
		Endif

		;## Assign Specialization Skill Rates ##
		If iSpecialization == 0 ; Combat
			fBlockSkillRate += 5
			fHeavyArmorSkillRate += 5
			fMarksmanSkillRate += 5
			fOneHandedSkillRate += 5
			fSmithingSkillRate += 5
			fTwoHandedSkillRate += 5
			PlayerRef.AddSpell(CombatSpecializationExpBuff)
		Elseif iSpecialization == 1 ; Magic
			fAlterationSkillRate += 5
			fConjurationSkillRate += 5
			fDestructionSkillRate += 5
			fEnchantingSkillRate += 5
			fIllusionSkillRate += 5
			fRestorationSkillRate += 5
			PlayerRef.AddSpell(MagicSpecializationExpBuff)
		ElseIf iSpecialization == 2 ; Stealth
			fAlchemySkillRate += 5
			fLightArmorSkillRate += 5
			fLockpickingSkillRate += 5
			fPickpocketSkillRate += 5
			fSneakSkillRate += 5
			fSpeechcraftSkillRate += 5
			PlayerRef.AddSpell(StealthSpecializationExpBuff)
		Endif

		;## Assign Major Skill Rates ##
		Int aiElement = 0
		Int[] arMajorSkills = New Int[6]	; Declare Major Skills Array that will be filled by aiMajorSkillX's
		arMajorSkills[0]= iMajorSkill1
		arMajorSkills[1]= iMajorSkill2
		arMajorSkills[2]= iMajorSkill3
		arMajorSkills[3]= iMajorSkill4
		arMajorSkills[4]= iMajorSkill5
		arMajorSkills[5]= iMajorSkill6
		aiElement = arMajorSkills.Length
		While aiElement > 0
			aiElement -= 1
			; Combat Skills
			If arMajorSkills[aiElement] == 0	; Archery
				fMarksmanSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 1	; Block
				fBlockSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 2	; Heavy Armor
				fHeavyArmorSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 3	; One-Handed
				fOneHandedSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 4	; Smithing
				fSmithingSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 5	; TwoHanded
				fTwoHandedSkillRate += 80
			; Magic Skills
			ElseIf arMajorSkills[aiElement] == 6	; Alteration
				fAlterationSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 7	; Conjuration
				fConjurationSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 8	; Destruction
				fDestructionSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 9	; Enchanting
				fEnchantingSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 10	; Illusion
				fIllusionSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 11	; Restoration
				fRestorationSkillRate += 80
			; Stealth Skills
			ElseIf arMajorSkills[aiElement] == 12	; Alchemy
				fAlchemySkillRate += 80
			ElseIf arMajorSkills[aiElement] == 13	; Light Armor
				fLightArmorSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 14	; Lockpicking
				fLockpickingSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 15	; Pickpocket
				fPickpocketSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 16	; Sneak
				fSneakSkillRate += 80
			ElseIf arMajorSkills[aiElement] == 17	; Speech
				fSpeechcraftSkillRate += 80
			EndIf
		EndWhile

		;## Apply Skill Rates ##
		; Alchemy
		If fAlchemySkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateAlchemy100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateAlchemy", fAlchemySkillRate / 100.0)
		; Alterations
		If fAlterationSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateAlteration100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateAlteration", fAlterationSkillRate / 100.0)
		; Block
		If fBlockSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateBlock100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateBlock", fBlockSkillRate / 100.0)
		; Conjuration
		If fConjurationSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateConjuration100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateConjuration", fConjurationSkillRate / 100.0)
		; Destruction
		If fDestructionSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateDestruction100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateDestruction", fDestructionSkillRate / 100.0)
		; Enchanting
		If fEnchantingSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateEnchanting100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateEnchanting", fEnchantingSkillRate / 100.0)
		; Heavy Armor
		If fHeavyArmorSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateHeavyArmor100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateHeavyArmor", fHeavyArmorSkillRate / 100.0)
		; Illusion
		If fIllusionSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateIllusion100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateIllusion", fIllusionSkillRate / 100.0)
		; Light Armor
		If fLightArmorSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateLightArmor100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateLightArmor", fLightArmorSkillRate / 100.0)
		; Lockpicking
		If fLockpickingSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateLockpicking100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateLockpicking", fLockpickingSkillRate / 100.0)
		; Archery
		If fMarksmanSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateMarksman100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateMarksman", fMarksmanSkillRate / 100.0)
		; One-Handed
		If fOneHandedSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateOneHanded100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateOneHanded", fOneHandedSkillRate / 100.0)
		; Pickpocket
		If fPickpocketSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRatePickpocket100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRatePickpocket", fPickpocketSkillRate / 100.0)
		; Restoration
		If fRestorationSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateRestoration100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateRestoration", fRestorationSkillRate / 100.0)
		; Smithing
		If fSmithingSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateSmithing100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateSmithing", fSmithingSkillRate / 100.0)
		; Sneak
		If fSneakSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateSneak100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateSneak", fSneakSkillRate / 100.0)
		; Speech
		If fSpeechcraftSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateSpeechcraft100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateSpeechcraft", fSpeechcraftSkillRate / 100.0)
		; Two-Handed
		If fTwoHandedSkillRate >= 100
			PlayerRef.AddPerk(_sycSkillRateTwoHanded100Perk)
		EndIf
		StorageUtil.SetFloatValue(none, "expRateTwoHanded", fTwoHandedSkillRate / 100.0)

	EndIf
EndFunction


;### Disable Dynamic Skill Progression Function ###
;---------------------------------------------------------------------------------------------------
Function DisableDynamicSkillProgression()
	If bDynamicSkillProgressionApplied == True	; Only disable if enabled
		bDynamicSkillProgressionApplied = False
		If bToggleModuleNotificationsOn == True
			Notification("Disabling Dynamic Skill Progression...")
		EndIf

		;## Reset Skill Rates ##
		ResetSkillRates()

		;## Remove Skill Rate Perks ##
		; +5%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy105Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration105Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock105Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration105Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction105Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting105Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor105Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion105Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor105Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking105Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman105Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded105Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket105Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration105Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing105Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak105Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft105Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded105Perk)
		; +10%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy110Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration110Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock110Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration110Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction110Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting110Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor110Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion110Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor110Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking110Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman110Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded110Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket110Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration110Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing110Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak110Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft110Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded110Perk)
		; +15%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy115Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration115Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock115Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration115Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction115Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting115Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor115Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion115Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor115Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking115Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman115Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded115Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket115Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration115Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing115Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak115Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft115Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded115Perk)
		; +20%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy120Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration120Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock120Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration120Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction120Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting120Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor120Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion120Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor120Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking120Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman120Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded120Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket120Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration120Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing120Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak120Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft120Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded120Perk)
		; +25%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy125Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration125Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock125Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration125Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction125Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting125Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor125Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion125Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor125Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking125Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman125Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded125Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket125Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration125Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing125Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak125Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft125Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded125Perk)
		; 5%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy005Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration005Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock005Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration005Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction005Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting005Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor005Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion005Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor005Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking005Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman005Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded005Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket005Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration005Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing005Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak005Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft005Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded005Perk)
		; 10%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy010Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration010Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock010Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration010Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction010Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting010Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor010Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion010Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor010Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking010Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman010Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded010Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket010Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration010Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing010Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak010Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft010Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded010Perk)
		; 15%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy015Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration015Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock015Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration015Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction015Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting015Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor015Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion015Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor015Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking015Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman015Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded015Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket015Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration015Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing015Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak015Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft015Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded015Perk)
		; 20%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy020Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration020Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock020Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration020Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction020Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting020Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor020Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion020Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor020Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking020Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman020Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded020Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket020Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration020Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing020Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak020Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft020Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded020Perk)
		; 25%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy025Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration025Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock025Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration025Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction025Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting025Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor025Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion025Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor025Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking025Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman025Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded025Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket025Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration025Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing025Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak025Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft025Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded025Perk)
		; 30%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy030Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration030Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock030Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration030Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction030Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting030Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor030Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion030Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor030Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking030Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman030Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded030Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket030Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration030Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing030Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak030Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft030Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded030Perk)
		; 100%
		PlayerRef.RemovePerk(_sycSkillRateAlchemy100Perk)
		PlayerRef.RemovePerk(_sycSkillRateAlteration100Perk)
		PlayerRef.RemovePerk(_sycSkillRateBlock100Perk)
		PlayerRef.RemovePerk(_sycSkillRateConjuration100Perk)
		PlayerRef.RemovePerk(_sycSkillRateDestruction100Perk)
		PlayerRef.RemovePerk(_sycSkillRateEnchanting100Perk)
		PlayerRef.RemovePerk(_sycSkillRateHeavyArmor100Perk)
		PlayerRef.RemovePerk(_sycSkillRateIllusion100Perk)
		PlayerRef.RemovePerk(_sycSkillRateLightArmor100Perk)
		PlayerRef.RemovePerk(_sycSkillRateLockpicking100Perk)
		PlayerRef.RemovePerk(_sycSkillRateMarksman100Perk)
		PlayerRef.RemovePerk(_sycSkillRateOneHanded100Perk)
		PlayerRef.RemovePerk(_sycSkillRatePickpocket100Perk)
		PlayerRef.RemovePerk(_sycSkillRateRestoration100Perk)
		PlayerRef.RemovePerk(_sycSkillRateSmithing100Perk)
		PlayerRef.RemovePerk(_sycSkillRateSneak100Perk)
		PlayerRef.RemovePerk(_sycSkillRateSpeechcraft100Perk)
		PlayerRef.RemovePerk(_sycSkillRateTwoHanded100Perk)
	EndIf
EndFunction


;---------------------------------------------------------------------------------------------------
;### DEPRECATED FUNCTIONS ###
;---------------------------------------------------------------------------------------------------

;### [DEPRECATED] Assign Race Stats Function ###
;---------------------------------------------------------------------------------------------------
; This function assigns Racial Attributes, Encumbrance, and Skill Rates
; Depreciated after v1.3.0
Function AssignRaceStatsV120()
EndFunction


;### [DEPRECATED] Unapply Carry Weight Function ###
;---------------------------------------------------------------------------------------------------
Function UnapplyCarryWeightV120()
EndFunction


;### [DEPRECATED] Disable Dynamic Skill Progression Function ###
;---------------------------------------------------------------------------------------------------
Function DisableDynamicSkillProgressionV120()
EndFunction

;---------------------------------------------------------------------------------------------------
;### NOTES ###
;---------------------------------------------------------------------------------------------------

; To Do
