#!/usr/bin/env python3

import argparse
import sys
import os
import lib.pythonfsb5.fsb5 as fsb5 # LZ: this script is called from the parent directory
import lib.pythonfsb5.fsb5.vorbis as vorbis

def write_to_file(filepath, contents):
    with open(filepath, 'wb') as f:
        written = f.write(contents)
    return filepath

def read_samples(fsb):
    for sample in fsb.samples:
        try:
            yield fsb.rebuild_sample(sample)
        except ValueError as e:
            print("FAILED to extract file")

def handle_file(rawData, output):
    index = 0
    while rawData:
        fsb = fsb5.load(rawData)

        rawData = rawData[fsb.raw_size:]
        for sample_data in read_samples(fsb):
            outpath = write_to_file(output, sample_data)

        index += 1

def main():
    pass

if __name__ == '__main__':
	main()
