/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.windowLoad;

import java.awt.Color;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JWindow;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.windowLoad.WindowDragListener;

public class WindowLoad {
    private static final int MAX_LOADING_LENGTH = 20;
    private boolean isLoading;
    private boolean suppressInvokable;
    private JLabelHTML label;
    private JWindow window;
    private JFrame frame;
    private final String labelText = Resources.initialized() ? Resources.__("mainProcessing", new Object[0]) : "";
    private final int labelMinLength = this.labelText.length();

    public WindowLoad() {
        this.setWindow();
        this.setLabel();
        this.setDummyFrame();
    }

    public void addKeyListener(KeyListener listener) {
        this.window.addKeyListener(listener);
    }

    public void start(String textOverride, final WindowLoadInvokable invokable) {
        this.frame.setVisible(true);
        this.frame.setLocationRelativeTo(null);
        this.frame.setAlwaysOnTop(true);
        Prompt.setMessageComponent(this.frame);
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
        this.window.toFront();
        this.window.setAlwaysOnTop(true);
        final String overrideText = textOverride != null ? textOverride : this.labelText;
        this.label.setText(overrideText);
        this.isLoading = true;
        this.suppressInvokable = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (WindowLoad.this.isLoading) {
                    if (invokable != null && !WindowLoad.this.suppressInvokable) {
                        WindowLoad.this.label.setText(invokable.getText());
                    } else {
                        int length = WindowLoad.this.label.getTextNoTags().length() - WindowLoad.this.labelMinLength;
                        if (length < 20) {
                            WindowLoad.this.label.setText(String.valueOf(WindowLoad.this.label.getTextNoTags()) + ". ");
                        } else {
                            WindowLoad.this.label.setText(overrideText);
                        }
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    public void stop() {
        this.isLoading = false;
        this.window.setVisible(false);
        this.frame.setVisible(false);
    }

    public void suppressInvokable(boolean suppress) {
        this.suppressInvokable = suppress;
    }

    private void setWindow() {
        this.window = new JWindow(new JFrame(""){

            @Override
            public boolean isShowing() {
                return true;
            }
        });
        this.window.setFocusable(true);
        this.window.setFocusableWindowState(true);
        this.window.setLayout(null);
        this.window.getContentPane().setBackground(new Color(240, 236, 224));
        this.window.setSize(180, 35);
        this.window.getRootPane().setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, new Color(25, 25, 25)));
        WindowDragListener listener = new WindowDragListener(this.window);
        this.window.addMouseListener(listener);
        this.window.addMouseMotionListener(listener);
    }

    private void setLabel() {
        this.label = new JLabelHTML(this.labelText, -1);
        this.label.setHorizontalAlignment(2);
        this.label.setBounds(3, 6, 170, 30);
        this.window.add(this.label);
    }

    private void setDummyFrame() {
        this.frame = new JFrame();
        this.frame.setUndecorated(true);
    }

    public static interface WindowLoadInvokable {
        public String getText();
    }
}

