/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.windowLoad;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JWindow;

public class WindowDragListener
extends MouseAdapter {
    private int lastX;
    private int lastY;
    private final JWindow window;

    protected WindowDragListener(JWindow window) {
        this.window = window;
        this.lastX = -1;
        this.lastY = -1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int deltaX = e.getX() - this.lastX;
        int deltaY = e.getY() - this.lastY;
        this.window.setLocation(this.window.getLocation().x + deltaX, this.window.getLocation().y + deltaY);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastX = -1;
        this.lastY = -1;
    }
}

