/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.textPane.contentAssist;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.textPane.AbstractMarkupDocument;

public class LabelContentSelect {
    private static final String COLOR_UNSELECT = "<u><font color='blue'>";
    private static final String COLOR_SELECT = "<u><font color='green'>";
    private static final String COLOR_END = "</font></u>";
    public final JLabel label = new JLabel();
    private String text;

    public LabelContentSelect(String text, AbstractMarkupDocument parent) {
        this.label.setCursor(new Cursor(12));
        this.label.setFocusable(true);
        this.setListeners(parent);
        this.setInputMaps();
        this.setActionMaps(parent);
        this.setText(text);
    }

    public void setText(String text) {
        this.text = text;
        this.label.setText(HTML.wrap(COLOR_UNSELECT + text + COLOR_END));
    }

    public String getText() {
        return this.text;
    }

    private void setListeners(final AbstractMarkupDocument parent) {
        this.label.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                LabelContentSelect.this.label.setText(HTML.wrap(LabelContentSelect.COLOR_SELECT + LabelContentSelect.this.text + LabelContentSelect.COLOR_END));
            }

            @Override
            public void focusLost(FocusEvent e) {
                LabelContentSelect.this.label.setText(HTML.wrap(LabelContentSelect.COLOR_UNSELECT + LabelContentSelect.this.text + LabelContentSelect.COLOR_END));
            }
        });
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                parent.chooseSuggestion(LabelContentSelect.this.getText());
            }
        });
    }

    private void setInputMaps() {
        InputMap inputMap = this.label.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "selectLabel");
        this.label.setInputMap(0, inputMap);
    }

    private void setActionMaps(final AbstractMarkupDocument parent) {
        ActionMap actionMap = this.label.getActionMap();
        actionMap.put("selectLabel", new AbstractAction(){
            private static final long serialVersionUID = -5149378187203760846L;

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.chooseSuggestion(LabelContentSelect.this.getText());
            }
        });
        this.label.setActionMap(actionMap);
    }
}

