/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.textPane.contentAssist;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import net.javamon.dev.utils.textPane.AbstractMarkupDocument;
import net.javamon.dev.utils.textPane.contentAssist.AbstractPanelContentAssist;

public class FrameContentAssist {
    private static final Border BORDER_FOCUSED = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, new Color(235, 186, 130)), BorderFactory.createLoweredBevelBorder());
    private static final Border BORDER_UNFOCUSED = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, new Color(235, 235, 235)), BorderFactory.createLoweredBevelBorder());
    private final JFrame frame = new JFrame();
    private final AbstractPanelContentAssist panelContentAssist;
    private final JScrollPane scrollPane;

    public FrameContentAssist(AbstractMarkupDocument parent, AbstractPanelContentAssist panelContentAssist, int width, int height) {
        this.frame.setSize(new Dimension(width, height));
        this.frame.setUndecorated(true);
        this.setFocus(false);
        this.frame.setFocusable(true);
        this.panelContentAssist = panelContentAssist;
        this.scrollPane = new JScrollPane(panelContentAssist.panel);
        this.frame.add(this.scrollPane);
        this.setListeners();
        this.setInputMaps();
        this.setActionMaps(parent);
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void show() {
        this.frame.setFocusableWindowState(false);
        this.frame.setVisible(true);
        this.frame.toFront();
        this.frame.setAlwaysOnTop(true);
        this.frame.setFocusableWindowState(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public void focus() {
        this.setFocus(true);
        this.panelContentAssist.requestFocus();
    }

    public void setLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    public boolean updateView(String token) {
        boolean containsEntries = this.panelContentAssist.updateView(token);
        this.scrollPane.setViewportView(this.panelContentAssist.panel);
        return containsEntries;
    }

    private void setFocus(boolean focus) {
        if (focus) {
            this.frame.getRootPane().setBorder(BORDER_FOCUSED);
            this.frame.setOpacity(1.0f);
        } else {
            this.frame.getRootPane().setBorder(BORDER_UNFOCUSED);
            this.frame.setOpacity(0.75f);
        }
    }

    private void setListeners() {
        this.frame.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FrameContentAssist.this.setFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FrameContentAssist.this.setFocus(false);
            }
        });
    }

    private void setInputMaps() {
        InputMap inputMap = this.frame.getRootPane().getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(32, 128), "showEditorSuggestionsContentAssist");
        this.frame.getRootPane().setInputMap(0, inputMap);
        inputMap = this.frame.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeWindow");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "closeWindow");
        inputMap.put(KeyStroke.getKeyStroke(32, 128), "closeWindow");
        this.frame.getRootPane().setInputMap(2, inputMap);
    }

    private void setActionMaps(final AbstractMarkupDocument parent) {
        ActionMap actionMap = this.frame.getRootPane().getActionMap();
        actionMap.put("showEditorSuggestionsContentAssist", new AbstractAction(){
            private static final long serialVersionUID = 5570945477793652138L;

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.hideContentAssist();
            }
        });
        actionMap.put("closeWindow", new AbstractAction(){
            private static final long serialVersionUID = -500762139041149084L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameContentAssist.this.setFocus(false);
                parent.requestFocus();
            }
        });
        this.frame.getRootPane().setActionMap(actionMap);
    }
}

