/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.textPane.contentAssist;

import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.dictionary.AbstractDictionary;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.textPane.contentAssist.AbstractEntry;

public abstract class AbstractPanelContentAssist
extends AbstractPanel {
    private static final int MAX_ENTRIES = 20;
    private JLabelHTML description = this.setDescription();
    private AbstractEntry[] entries;
    private int entryHeight;

    protected AbstractPanelContentAssist() {
        super("mainContentAssistBdr");
        if (this.description != null) {
            this.layout("West", this.description, 5, "West", this.panel);
            this.layout("North", this.description, 5, "North", this.panel);
            this.layout("East", this.description, -5, "East", this.panel);
            this.add(this.description);
        }
        this.setEntries();
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void validate() {
    }

    protected abstract JLabelHTML setDescription();

    protected abstract AbstractEntry create();

    protected abstract boolean update(AbstractEntry var1, int var2);

    protected abstract AbstractDictionary.SearchResult find(String var1);

    protected void requestFocus() {
        if (this.entries[0].isVisible()) {
            this.entries[0].label.label.requestFocus();
        } else {
            this.panel.requestFocus();
        }
    }

    protected boolean updateView(String token) {
        int i;
        int descHeight = this.description == null ? 0 : this.description.getPreferredSize().height;
        AbstractDictionary.SearchResult result = null;
        if (token.length() > 0) {
            result = this.find(token);
        }
        boolean disabled = result == null || !result.found();
        int numFound = 0;
        int numEntries = 0;
        if (!disabled) {
            numFound = Math.min(result.end() - result.start() + 1, this.entries.length);
            i = 0;
            while (i < numFound) {
                if (!disabled && this.update(this.entries[i], result.start() + i)) {
                    this.entries[i].setVisible(true);
                    ++numEntries;
                } else {
                    disabled = true;
                    this.entries[i].setVisible(false);
                }
                ++i;
            }
        }
        i = numFound;
        while (i < this.entries.length) {
            this.entries[i].setVisible(false);
            ++i;
        }
        this.setPreferredSize(this.panel.getPreferredSize().width, this.borderHeight() + descHeight + 5 + numEntries * this.entryHeight + (numEntries - 1) * 5);
        return numEntries > 0 || this.description != null;
    }

    private void setEntries() {
        this.entries = new AbstractEntry[20];
        int i = 0;
        while (i < 20) {
            this.entries[i] = this.create();
            if (i == 0) {
                if (this.description == null) {
                    this.layout("North", this.entries[i].panel, 5, "North", this.panel);
                } else {
                    this.layout("North", this.entries[i].panel, 5, "South", this.description);
                }
            } else {
                this.layout("North", this.entries[i].panel, 5, "South", this.entries[i - 1].panel);
            }
            this.layout("West", this.entries[i].panel, 5, "West", this.panel);
            this.layout("East", this.entries[i].panel, -5, "East", this.panel);
            this.add(this.entries[i].panel);
            ++i;
        }
        this.entryHeight = this.entries[0].panel.getPreferredSize().height;
    }
}

