/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.textPane;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.javamon.dev.utils.layout.Validate;

public class UndoListener
implements UndoableEditListener,
DocumentListener {
    private static final int VELOCITY_NONE = 0;
    private static final int VELOCITY_FORWARD = 1;
    private static final int VELOCITY_BACKWARD = 2;
    private ListenerCompoundEdit compoundEdit;
    private int lastOffset;
    private int lastLength;
    private int lastVelocity;
    private final UndoManager manager;
    private final JTextComponent component;

    public UndoListener(JTextComponent component, int limit) {
        this.component = component;
        this.manager = new UndoManager();
        this.manager.setLimit(limit);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        int newLength;
        int modLength;
        if (!Validate.isEnabled()) {
            this.compoundEdit = null;
            this.manager.discardAllEdits();
        }
        UndoableEdit edit = e.getEdit();
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(edit);
            this.lastLength = this.component.getDocument().getLength();
            return;
        }
        if (this.isChange(edit)) {
            this.compoundEdit.addEdit(edit);
            return;
        }
        int newOffset = this.component.getCaretPosition();
        int modOffset = newOffset - this.lastOffset;
        if (this.isIncremental(modOffset, modLength = (newLength = this.component.getDocument().getLength()) - this.lastLength) && this.isMomentum(modOffset, modLength) && !this.isBreak(newOffset)) {
            this.compoundEdit.addEdit(edit);
            this.lastOffset = newOffset;
            this.lastLength = newLength;
            this.updateVelocity(modOffset);
        } else {
            this.compoundEdit.end();
            this.compoundEdit = this.startCompoundEdit(edit);
        }
    }

    @Override
    public void insertUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int offset = Math.min(e.getOffset() + e.getLength(), UndoListener.this.component.getDocument().getLength());
                UndoListener.this.component.setCaretPosition(offset);
            }
        });
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.component.setCaretPosition(e.getOffset());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void undo() {
        this.component.getDocument().addDocumentListener(this);
        try {
            this.manager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
        this.component.getDocument().removeDocumentListener(this);
    }

    public void redo() {
        this.component.getDocument().addDocumentListener(this);
        try {
            this.manager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
        this.component.getDocument().removeDocumentListener(this);
    }

    private ListenerCompoundEdit startCompoundEdit(UndoableEdit edit) {
        this.lastOffset = this.component.getCaretPosition();
        this.lastLength = this.component.getDocument().getLength();
        this.lastVelocity = 0;
        this.compoundEdit = new ListenerCompoundEdit();
        this.compoundEdit.addEdit(edit);
        this.manager.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    private void updateVelocity(int modOffset) {
        if (this.lastVelocity == 0) {
            this.lastVelocity = modOffset > 0 ? 1 : 2;
        }
    }

    private boolean isChange(UndoableEdit edit) {
        return edit instanceof AbstractDocument.DefaultDocumentEvent && ((AbstractDocument.DefaultDocumentEvent)edit).getType() == DocumentEvent.EventType.CHANGE;
    }

    private boolean isIncremental(int modOffset, int modLength) {
        return Math.abs(modOffset) == 1 && Math.abs(modLength) == 1;
    }

    private boolean isMomentum(int modOffset, int modLength) {
        return this.lastVelocity == 0 || modOffset < 0 && modLength < 0 && this.lastVelocity == 2 || modOffset > 0 && modLength > 0 && this.lastVelocity == 1;
    }

    private boolean isBreak(int newOffset) {
        String currChar = null;
        if (this.lastVelocity == 1 && newOffset - 1 > 0) {
            try {
                currChar = this.component.getText(newOffset - 1, 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return currChar != null && (currChar.equals("\n") || currChar.equals("\t") || currChar.equals("\r"));
    }

    private class ListenerCompoundEdit
    extends CompoundEdit {
        private static final long serialVersionUID = 6612402546730830350L;

        private ListenerCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (UndoListener.this.compoundEdit != null) {
                UndoListener.this.compoundEdit.end();
            }
            super.undo();
            UndoListener.this.compoundEdit = null;
        }
    }

    public static class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 198357634621098777L;
        protected final UndoListener undoListener;

        public RedoAction(UndoListener undoListener) {
            this.undoListener = undoListener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.undoListener.redo();
        }
    }

    public static class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 198357634621098777L;
        protected final UndoListener undoListener;

        public UndoAction(UndoListener undoListener) {
            this.undoListener = undoListener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.undoListener.undo();
        }
    }
}

