/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.textPane;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import net.javamon.dev.utils.textPane.AbstractMarkupDocument;
import net.javamon.dev.utils.textPane.CopyTextAction;
import net.javamon.dev.utils.textPane.CutTextAction;
import net.javamon.dev.utils.textPane.EditorSuggestionAction;
import net.javamon.dev.utils.textPane.MarkupDefault;
import net.javamon.dev.utils.textPane.PasteTextAction;
import net.javamon.dev.utils.textPane.TextCaretListener;
import net.javamon.dev.utils.textPane.UndoListener;

public class JTextPaneMarkup
extends JTextPane {
    public static final int MARKUP_NONE = 0;
    private static final long serialVersionUID = 2152022449069519016L;
    private final UndoListener undoListener;
    private final boolean wrap;
    private final int style;
    private final boolean allowNewline;
    private final boolean allowTab;

    public JTextPaneMarkup(int style, boolean wrap, String text, int rows, int columns, boolean allowNewline, boolean allowTab) {
        super(JTextPaneMarkup.getStyle(style));
        this.wrap = wrap;
        this.style = style;
        this.allowNewline = allowNewline;
        this.allowTab = allowTab;
        this.undoListener = new UndoListener(this, 50);
        this.getDocument().addUndoableEditListener(this.undoListener);
        this.getStyle().setParent(this);
        if (text != null) {
            this.setText(text);
        }
        Dimension d = new JTextArea("", 1, 1).getPreferredSize();
        this.setPreferredSize(new Dimension(d.width * rows, d.height * columns));
        this.setInputMaps();
        this.setActionMaps();
        this.addCaretListener(new TextCaretListener(this));
    }

    @Override
    public void replaceSelection(String content) {
        super.replaceSelection(this.replace(content));
    }

    @Override
    public String getText() {
        return this.replace(super.getText());
    }

    @Override
    public void setText(String t) {
        super.setText(this.replace(t));
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.wrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.wrap) {
            return super.getPreferredSize();
        }
        return this.getUI().getPreferredSize(this);
    }

    protected AbstractMarkupDocument getStyle() {
        return (MarkupDefault)this.getStyledDocument();
    }

    private String replace(String string) {
        if (string == null) {
            return string;
        }
        if (!this.allowNewline) {
            string = string.replaceAll("\\n", "").replaceAll("\\r", "");
        }
        if (!this.allowTab) {
            string = string.replaceAll("\\t", "").replaceAll("\\t", "");
        }
        return string;
    }

    private void setInputMaps() {
        InputMap inputMap = this.getInputMap();
        if (!this.allowNewline) {
            inputMap.remove(KeyStroke.getKeyStroke('\n'));
            inputMap.remove(KeyStroke.getKeyStroke('\r'));
        }
        if (!this.allowTab) {
            inputMap.remove(KeyStroke.getKeyStroke('\t'));
        }
        int shortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        inputMap.put(KeyStroke.getKeyStroke(32, shortcutKey), "showSuggestions");
        inputMap.put(KeyStroke.getKeyStroke(67, shortcutKey), "copyText");
        inputMap.put(KeyStroke.getKeyStroke(88, shortcutKey), "cutText");
        inputMap.put(KeyStroke.getKeyStroke(86, shortcutKey), "pasteText");
        inputMap.put(KeyStroke.getKeyStroke(90, shortcutKey), "undo");
        inputMap.put(KeyStroke.getKeyStroke(89, shortcutKey), "redo");
        this.setInputMap(0, inputMap);
    }

    private void setActionMaps() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("showSuggestions", new EditorSuggestionAction(this));
        actionMap.put("copyText", new CopyTextAction(this));
        actionMap.put("cutText", new CutTextAction(this));
        actionMap.put("pasteText", new PasteTextAction(this));
        actionMap.put("undo", new UndoListener.UndoAction(this.undoListener));
        actionMap.put("redo", new UndoListener.RedoAction(this.undoListener));
        this.setActionMap(actionMap);
    }

    private static DefaultStyledDocument getStyle(int style) {
        return new MarkupDefault();
    }
}

