/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.textPane;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import net.javamon.dev.utils.textPane.JTextPaneMarkup;
import net.javamon.dev.utils.textPane.contentAssist.FrameContentAssist;

public abstract class AbstractMarkupDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = -2494547526465711341L;
    private static final int CONTENT_ASSIST_PAD = 5;
    protected JTextPaneMarkup parent;
    protected int tokenStart;
    protected String currToken;
    private final FrameContentAssist contentAssist = this.createContentAssist();

    protected AbstractMarkupDocument() {
        this.resetToken();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
        this.parse();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.parse();
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offset, length, text, attrs);
        this.parse();
    }

    protected abstract FrameContentAssist createContentAssist();

    protected abstract String getSuggestion(String var1);

    protected abstract String getToken(int var1, char var2, boolean var3, boolean var4) throws BadLocationException;

    protected abstract void parse() throws BadLocationException;

    public void requestFocus() {
        this.parent.requestFocus();
    }

    public void chooseSuggestion(String choice) {
        if (this.contentAssist == null || !this.contentAssist.isVisible() || this.currToken.length() == 0) {
            return;
        }
        try {
            String input = this.getSuggestion(choice);
            String before = this.getText(0, this.tokenStart);
            String after = this.getText(this.tokenStart + this.currToken.length(), this.getLength() - this.tokenStart - this.currToken.length());
            this.parent.setText(String.valueOf(before) + input + after);
            this.resetToken();
            this.toggleContentAssist();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void hideContentAssist() {
        if (this.contentAssist == null || !this.contentAssist.isVisible()) {
            return;
        }
        this.contentAssist.hide();
    }

    protected void resetToken() {
        this.currToken = "";
        this.tokenStart = -1;
    }

    protected void setParent(final JTextPaneMarkup parent) {
        if (this.parent == null) {
            this.parent = parent;
            if (this.contentAssist != null) {
                parent.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        try {
                            boolean newline;
                            int caret = parent.getCaretPosition();
                            char key = e.getKeyChar();
                            boolean backspace = key == '\b';
                            boolean bl = newline = key == '\n' || key == '\r';
                            if (AbstractMarkupDocument.this.contentAssist.isVisible() && key == '\t') {
                                AbstractMarkupDocument.this.contentAssist.focus();
                                return;
                            }
                            String token = AbstractMarkupDocument.this.getToken(caret, key, backspace, newline);
                            if (token.length() > 0 && !AbstractMarkupDocument.this.contentAssist.isVisible()) {
                                AbstractMarkupDocument.this.contentAssist.show();
                            }
                            AbstractMarkupDocument.this.updateContentAssist(token, false, backspace || newline);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                parent.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                        AbstractMarkupDocument.this.resetToken();
                        AbstractMarkupDocument.this.contentAssist.hide();
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }
                });
            }
        }
    }

    protected void updateContentAssist(String token, boolean locOnly, boolean cancel) throws BadLocationException {
        if (this.contentAssist == null || !this.contentAssist.isVisible()) {
            return;
        }
        int caret = this.parent.getCaretPosition();
        Rectangle r = this.parent.modelToView(caret);
        Point parentLoc = this.parent.getLocationOnScreen();
        this.contentAssist.setLocation(r.x + parentLoc.x + 5, r.y + parentLoc.y + 5);
        if (!(locOnly || this.contentAssist.updateView(token) || token.length() <= 0 && !cancel)) {
            this.hideContentAssist();
        }
    }

    protected void toggleContentAssist() throws BadLocationException {
        if (this.contentAssist == null) {
            return;
        }
        if (this.contentAssist.isVisible()) {
            this.hideContentAssist();
            this.resetToken();
        } else {
            this.contentAssist.show();
            this.updateContentAssist("", false, false);
        }
    }
}

