/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.popup;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.javamon.dev.ImageCache;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.popup.AbstractPanelPopup;

public class FramePopup {
    private final JFrame frame;
    private final AbstractPanelPopup panel;
    private final JScrollPane scrollPane;

    public FramePopup(AbstractPanelPopup panel, JPanel ancestorPanel, String titleKey, int width, int height, Object ... args) {
        this.frame = args == null || args.length == 0 ? new JFrame(Resources.__(titleKey, new Object[0])) : new JFrame(Resources.__(titleKey, args));
        this.frame.setIconImage(ImageCache.get(Resources.getAppImage("icon")).get());
        this.frame.setDefaultCloseOperation(1);
        this.frame.setMinimumSize(new Dimension(width, height));
        this.frame.setResizable(false);
        this.panel = panel;
        panel.setParentFrame(this);
        this.scrollPane = new JScrollPane(panel.panel);
        this.frame.add(this.scrollPane);
        ancestorPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                FramePopup.this.hide();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void show() {
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public void setEnabled(boolean enabled) {
        this.panel.setEnabled(enabled);
    }

    public void validate() {
        this.panel.validate();
    }

    public void updateView(ImageCache.BufferedImageData ... data) {
        this.panel.updateView(data);
        this.scrollPane.setViewportView(this.panel.panel);
    }
}

