/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.layout;

import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import javax.swing.JTextField;
import net.javamon.dev.utils.JScrollPaneText;
import net.javamon.dev.utils.JTextAreaRestricted;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;

public final class Validate {
    private static boolean isEnabled = true;

    private Validate() {
        throw new AssertionError();
    }

    public static void enable() {
        isEnabled = true;
    }

    public static void disable() {
        isEnabled = false;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void textConstrainPOT(JTextField field) {
        String text = field.getText();
        int value = 2;
        try {
            value = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        value = Math.max(2, value);
        if (value > 1 && (value & -value) == value) {
            return;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        ++value;
        field.setText(String.valueOf(value >>= 1));
    }

    public static void textConstrainLength(JTextField field, int numChars) {
        String text = field.getText();
        if (text.length() > numChars && numChars > 0) {
            field.setText(text.substring(0, numChars));
        }
    }

    public static void textConstrainLength(JScrollPaneText scrollText, int numChars) {
        String text = scrollText.getText();
        if (text.length() > numChars && numChars > 0) {
            scrollText.setText(text.substring(0, numChars));
        }
    }

    public static void textConstrainLength(JTextAreaRestricted textArea, int numChars) {
        String text = textArea.getText();
        if (text.length() > numChars && numChars > 0) {
            textArea.setText(text.substring(0, numChars));
        }
    }

    public static void textConstrainInt(JTextField field, int lower, int upper) {
        int value;
        String text = field.getText();
        try {
            value = Integer.parseInt(text);
            value = Math.min(upper, Math.max(value, lower));
        }
        catch (NumberFormatException e) {
            value = lower;
        }
        field.setText(String.valueOf(value));
    }

    public static void textConstrainInt(JTextField field, int bound, boolean upper) {
        int value;
        String text = field.getText();
        try {
            value = Integer.parseInt(text);
            value = upper ? Math.min(bound, value) : Math.max(bound, value);
        }
        catch (NumberFormatException e) {
            value = upper ? 0 : bound;
        }
        field.setText(String.valueOf(value));
    }

    public static void textConstrainFloat(JTextField field, float lower, float upper) {
        float value;
        String text = field.getText();
        try {
            value = Float.parseFloat(text);
            value = Math.min(upper, Math.max(value, lower));
        }
        catch (NumberFormatException e) {
            value = lower;
        }
        field.setText(String.valueOf(value));
    }

    public static void textConstrainFloat(JTextField field, float bound, boolean upper) {
        float value;
        String text = field.getText();
        try {
            value = Float.parseFloat(text);
            value = upper ? Math.min(bound, value) : Math.max(bound, value);
        }
        catch (NumberFormatException e) {
            value = upper ? 0.0f : bound;
        }
        field.setText(String.valueOf(value));
    }

    public static void textConstrainPath(JTextField field, boolean noSpaces) {
        String text = field.getText();
        if (text.length() == 0) {
            return;
        }
        try {
            Paths.get(text, new String[0]);
        }
        catch (InvalidPathException e) {
            field.setText("");
        }
        if (noSpaces) {
            field.setText(text.replace(" ", ""));
        }
    }

    public static void textFormatInt(JTextField field, int digits) {
        int value;
        String text = field.getText();
        try {
            value = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            value = 0;
        }
        int numPad = digits - String.valueOf(value).length();
        if (numPad > 0) {
            field.setText(String.format("%0" + numPad + "d%d", 0, value));
        } else {
            field.setText(String.valueOf(value));
        }
    }

    public static void textFormatFloat(JTextField field, int digitsAfter) {
        float value;
        String text = field.getText();
        try {
            value = Float.parseFloat(text);
        }
        catch (NumberFormatException e) {
            value = 0.0f;
        }
        field.setText(String.format("%." + digitsAfter + "f", Float.valueOf(value)));
    }

    public static void textFormatColor(JTextField field, boolean allowAlpha) {
        Validate.textFormatHex(field, allowAlpha ? 4 : 3);
    }

    public static void textFormatHex(JTextField field, int bytes) {
        String text = field.getText();
        int requiredLength = bytes * 2;
        while (text.length() < requiredLength) {
            text = String.valueOf(text) + "0";
        }
        if (text.length() > requiredLength) {
            text = text.substring(0, requiredLength);
        }
        int i = 0;
        while (i < bytes) {
            try {
                Integer.parseInt(text.substring(i, i + 2), 16);
            }
            catch (NumberFormatException e) {
                text = String.valueOf(text.substring(0, i)) + "00" + text.substring(i + 2);
            }
            i += 2;
        }
        field.setText(text.toUpperCase());
    }

    public static boolean textSum(JTextField[] fields, int fieldMax, int max, boolean requireMax) {
        int sum = 0;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isEnabled()) {
                int value;
                try {
                    value = Integer.parseInt(fields[i].getText());
                }
                catch (NumberFormatException e) {
                    value = 0;
                }
                if (value > fieldMax) {
                    value = fieldMax;
                }
                if (value < 0) {
                    value = 0;
                }
                if (sum + value > max) {
                    value = max - sum;
                }
                fields[i].setText(String.valueOf(value));
                sum += value;
            }
            ++i;
        }
        int remainder = max - sum;
        if (remainder != 0 && requireMax) {
            int i2 = fields.length - 1;
            while (i2 >= 0) {
                if (fields[i2].isEnabled()) {
                    int value = Integer.parseInt(fields[i2].getText());
                    if (value + remainder <= fieldMax) {
                        fields[i2].setText(String.valueOf(value + remainder));
                        remainder -= value;
                        break;
                    }
                    fields[i2].setText(String.valueOf(fieldMax));
                    remainder -= fieldMax - value;
                }
                --i2;
            }
        }
        return remainder == 0;
    }

    public static void textNumericOrder(JTextField[] fields, int bound, boolean forceStartBound, boolean strict, boolean ascending) {
        if (forceStartBound) {
            fields[0].setText(String.valueOf(bound));
        }
        try {
            Integer.parseInt(fields[0].getText());
        }
        catch (NumberFormatException e) {
            fields[0].setText(String.valueOf(bound));
        }
        int curr = 0;
        int i = 1;
        while (i < fields.length) {
            int previous = Integer.parseInt(fields[i - 1].getText());
            try {
                curr = Integer.parseInt(fields[i].getText());
            }
            catch (NumberFormatException e) {
                curr = ascending ? previous - 1 : previous + 1;
            }
            if (ascending) {
                if (strict && curr <= previous) {
                    fields[i].setText(String.valueOf(previous + 1));
                } else if (!strict && curr < previous) {
                    fields[i].setText(String.valueOf(previous));
                }
            } else if (strict && curr >= previous) {
                fields[i].setText(String.valueOf(previous - 1));
            } else if (!strict && curr > previous) {
                fields[i].setText(String.valueOf(previous));
            }
            ++i;
        }
    }

    public static void textNumericOrder(JTextField[] fields, int min, int max, boolean strict, boolean ascending) {
        int previous;
        if (max <= min || fields.length > max - min + 1 && strict) {
            return;
        }
        int i = 0;
        while (i < fields.length) {
            try {
                Integer.parseInt(fields[i].getText());
            }
            catch (NumberFormatException e) {
                if (ascending) {
                    fields[i].setText(String.valueOf(min));
                }
                fields[i].setText(String.valueOf(max));
            }
            ++i;
        }
        int curr = 0;
        int i2 = 1;
        while (i2 < fields.length) {
            previous = Integer.parseInt(fields[i2 - 1].getText());
            curr = Integer.parseInt(fields[i2].getText());
            if (ascending) {
                if (curr <= previous && strict) {
                    fields[i2].setText(String.valueOf(previous + 1));
                } else if (curr < previous) {
                    fields[i2].setText(String.valueOf(previous));
                }
            } else if (curr >= previous && strict) {
                fields[i2].setText(String.valueOf(previous - 1));
            } else if (curr > previous) {
                fields[i2].setText(String.valueOf(previous));
            }
            ++i2;
        }
        i2 = fields.length - 1;
        while (i2 >= 0) {
            curr = Integer.parseInt(fields[i2].getText());
            if (ascending && curr > max) {
                fields[i2].setText(String.valueOf(max));
            } else if (!ascending && curr < min) {
                fields[i2].setText(String.valueOf(min));
            }
            if (i2 < fields.length - 1) {
                previous = Integer.parseInt(fields[i2 + 1].getText());
                curr = Integer.parseInt(fields[i2].getText());
                if (ascending) {
                    if (curr >= previous && strict) {
                        fields[i2].setText(String.valueOf(previous - 1));
                    } else if (curr > previous) {
                        fields[i2].setText(String.valueOf(previous));
                    }
                } else if (curr <= previous && strict) {
                    fields[i2].setText(String.valueOf(previous + 1));
                } else if (curr < previous) {
                    fields[i2].setText(String.valueOf(previous));
                }
            }
            --i2;
        }
    }

    public static void boxRestrictIndices(ExtendableJComboBox<String> box, int defaultIndex, int ... illegalIndices) {
        if (illegalIndices == null || illegalIndices.length == 0 || defaultIndex > box.getItemCount()) {
            return;
        }
        int i = 0;
        while (i < illegalIndices.length) {
            if (defaultIndex == illegalIndices[i]) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < illegalIndices.length) {
            if (box.getSelectedIndex() == illegalIndices[i]) {
                box.setSelectedIndex(defaultIndex);
                return;
            }
            ++i;
        }
    }
}

