/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.layout;

import java.awt.Component;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.AbstractSpringLayout;

public class SpringTableLayout
extends AbstractSpringLayout {
    private int columns;
    private int rows;
    private int cellWidth;
    private int cellHeight;
    private int edgePad;
    private int labelPad;
    private int cellPad;
    private int labelWidth;
    private int labelHeight;
    private Component anchorLeft;
    private Component anchorTop;

    protected SpringTableLayout(AbstractPanel panel) {
        super(panel);
    }

    @Override
    protected void place(Component c) {
    }

    @Override
    public void end() {
        super.end();
        this.columns = -1;
        this.rows = -1;
        this.cellWidth = -1;
        this.cellHeight = -1;
        this.edgePad = -1;
        this.labelPad = -1;
        this.cellPad = -1;
        this.labelWidth = -1;
        this.labelHeight = -1;
        this.anchorLeft = null;
        this.anchorTop = null;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void place(Component c, int column, int row) {
        if (!this.layout) {
            System.err.println("cannot layout component; start() was not yet called");
            return;
        }
        if (column < 0 || row < 0 || column >= this.columns || row >= this.rows) {
            System.err.println("component coordinates (" + column + ", " + row + ") are invalid; " + "must fall between (0, 0) and (" + this.columns + ", " + this.rows + ")");
            return;
        }
        if (c == null) {
            return;
        }
        int left = this.edgePad + this.labelWidth + this.labelPad + column * this.cellWidth + column * this.cellPad;
        int top = this.edgePad + this.labelHeight + this.labelPad + row * this.cellHeight + row * this.cellPad;
        this.constrainTop(c, this.anchorTop, top);
        this.constrainLeft(c, this.anchorLeft, left);
        this.panel.add(c);
    }

    public void start(int columns, int rows, int cellWidth, int cellHeight, int edgePad, int labelPad, int cellPad, Component[] labelsX, Component[] labelsY, Component anchorLeft, Component anchorTop) {
        if (labelsX != null && labelsX.length != columns) {
            System.err.println("cannot start layout; number of labels " + labelsX.length + " does not match requested column count " + columns);
            return;
        }
        if (labelsY != null && labelsY.length != columns) {
            System.err.println("cannot start layout; number of labels " + labelsY.length + " does not match requested row count " + rows);
            return;
        }
        this.start();
        this.columns = columns;
        this.rows = rows;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.edgePad = edgePad;
        this.labelPad = labelPad;
        this.cellPad = cellPad;
        this.labelWidth = this.getLabelDimension(labelsY, true);
        this.labelHeight = this.getLabelDimension(labelsX, false);
        this.anchorLeft = anchorLeft;
        this.anchorTop = anchorTop;
        this.preferredWidth = edgePad + this.labelWidth + labelPad + columns * cellWidth + (columns - 1) * cellPad;
        this.preferredHeight = edgePad + this.labelHeight + labelPad + rows * cellHeight + (rows - 1) * cellPad;
        this.placeLabelsX(labelsX);
        this.placeLabelsY(labelsY);
    }

    private int getLabelDimension(Component[] components, boolean getWidth) {
        if (components == null) {
            return 0;
        }
        int max = 0;
        int i = 0;
        while (i < components.length) {
            int curr = getWidth ? components[i].getPreferredSize().width : components[i].getPreferredSize().height;
            max = Math.max(max, curr);
            ++i;
        }
        return max;
    }

    private void placeLabelsX(Component[] labels) {
        if (labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.length) {
            int left = this.edgePad + this.labelWidth + this.labelPad + i * this.cellWidth + i * this.cellPad;
            int top = this.edgePad + this.labelHeight;
            if (this.anchorTop == this.panel.panel) {
                this.panel.layout("South", labels[i], top, "North", this.anchorTop);
            } else if (this.anchorTop != null) {
                this.panel.layout("South", labels[i], top, "South", this.anchorTop);
            }
            this.constrainLeft(labels[i], this.anchorLeft, left);
            this.panel.add(labels[i]);
            ++i;
        }
    }

    private void placeLabelsY(Component[] labels) {
        if (labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.length) {
            int left = this.edgePad + this.labelWidth;
            int top = this.edgePad + this.labelHeight + this.labelPad + i * this.cellHeight + i * this.cellPad;
            this.constrainTop(labels[i], this.anchorTop, top);
            if (this.anchorLeft == this.panel.panel) {
                this.panel.layout("East", labels[i], left, "West", this.anchorTop);
            } else if (this.anchorTop != null) {
                this.panel.layout("East", labels[i], left, "East", this.anchorTop);
            }
            this.panel.add(labels[i]);
            ++i;
        }
    }
}

