/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.layout;

import java.awt.Component;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.AbstractSpringLayout;

public class SpringGridLayout
extends AbstractSpringLayout {
    private boolean modeRow;
    private int width;
    private int height;
    private int index;
    private int pad;
    private int currWidth = 0;
    private int currHeight = 0;
    private Component anchorLeft;
    private Component anchorTop;
    private Component previous;
    private Component previousRow;
    private int[] prevColumnRow;
    private int prevColumnRowIndex;

    protected SpringGridLayout(AbstractPanel panel) {
        super(panel);
    }

    @Override
    public void place(Component c) {
        if (!this.layout) {
            System.err.println("cannot layout component; start() was not yet called");
            return;
        }
        if (c == null) {
            System.err.println("cannot layout a null component");
            return;
        }
        this.constrainLeft(c, this.previous, this.pad);
        this.constrainTop(c, this.previousRow, this.pad);
        this.updateBounds(c.getPreferredSize().width, c.getPreferredSize().height);
        ++this.index;
        if (this.modeRow) {
            this.previous = c;
            if (this.index % this.width == 0) {
                this.previous = this.anchorLeft;
                this.previousRow = c;
            }
        } else {
            this.previousRow = c;
            if (this.index % this.height == 0) {
                this.previous = c;
                this.previousRow = this.anchorTop;
            }
        }
        this.panel.add(c);
    }

    @Override
    public void end() {
        super.end();
        this.width = -1;
        this.height = -1;
        this.pad = -1;
        this.index = -1;
        this.anchorLeft = null;
        this.anchorTop = null;
        this.previous = null;
        this.previousRow = null;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void start(int gridWidth, int gridHeight, int gridPad, Component anchorLeft, Component anchorTop) {
        this.start();
        this.width = gridWidth;
        this.height = gridHeight;
        this.pad = gridPad;
        this.modeRow = gridWidth > 0;
        this.index = 0;
        this.anchorLeft = anchorLeft;
        this.anchorTop = anchorTop;
        this.previous = anchorLeft;
        this.previousRow = anchorTop;
        this.currWidth = 0;
        this.currHeight = 0;
        this.prevColumnRow = this.modeRow ? new int[gridWidth] : new int[gridHeight];
        this.prevColumnRowIndex = 0;
    }

    public void next() {
        if (!this.layout) {
            System.err.println("cannot call next(); start() was not yet called");
            return;
        }
        if (this.modeRow) {
            this.previousRow = this.previous;
            this.previous = this.anchorLeft;
        } else {
            this.previous = this.previousRow;
            this.previousRow = this.anchorTop;
        }
    }

    private void updateBounds(int cWidth, int cHeight) {
        if (this.modeRow) {
            this.currWidth = this.anchorLeft == this.previous ? this.pad * 2 + cWidth : (this.currWidth += this.pad + cWidth);
            this.preferredWidth = Math.max(this.preferredWidth, this.currWidth);
            if (this.anchorTop == this.previousRow) {
                this.prevColumnRow[this.prevColumnRowIndex] = this.pad * 2 + cHeight;
            } else {
                int n = this.prevColumnRowIndex;
                this.prevColumnRow[n] = this.prevColumnRow[n] + (this.pad + cHeight);
            }
            this.currHeight = this.maxColumnRow();
            this.prevColumnRowIndex = (this.prevColumnRowIndex + 1) % this.width;
            this.preferredHeight = Math.max(this.preferredHeight, this.currHeight);
        } else {
            if (this.anchorLeft == this.previous) {
                this.prevColumnRow[this.prevColumnRowIndex] = this.pad * 2 + cWidth;
            } else {
                int n = this.prevColumnRowIndex;
                this.prevColumnRow[n] = this.prevColumnRow[n] + (this.pad + cWidth);
            }
            this.currWidth = this.maxColumnRow();
            this.prevColumnRowIndex = (this.prevColumnRowIndex + 1) % this.height;
            this.preferredWidth = Math.max(this.preferredWidth, this.currWidth);
            this.currHeight = this.anchorTop == this.previousRow ? this.pad * 2 + cHeight : (this.currHeight += this.pad + cHeight);
            this.preferredHeight = Math.max(this.preferredHeight, this.currHeight);
        }
    }

    private int maxColumnRow() {
        int max = 0;
        int i = 0;
        while (i < this.prevColumnRow.length) {
            max = Math.max(max, this.prevColumnRow[i]);
            ++i;
        }
        return max;
    }
}

