/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.layout;

import java.awt.Component;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.AbstractSpringLayout;

public class SpringColumnLayout
extends AbstractSpringLayout {
    private boolean justified;
    private int padTop;
    private int padEdge;
    private int padRow;
    private int padTab;
    private Component anchorLeft;
    private Component anchorTop;
    private Component anchorRight;
    private Component previousRow;

    protected SpringColumnLayout(AbstractPanel panel) {
        super(panel);
    }

    @Override
    protected void place(Component c) {
    }

    @Override
    public void end() {
        super.end();
        this.justified = false;
        this.padTop = -1;
        this.padEdge = -1;
        this.padRow = -1;
        this.padTab = -1;
        this.anchorLeft = null;
        this.anchorTop = null;
        this.anchorRight = null;
        this.previousRow = null;
    }

    @Override
    public int getPreferredWidth() {
        if (!this.justified) {
            return this.preferredWidth;
        }
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void place(Component left, Component right) {
        if (!this.layout) {
            System.err.println("cannot layout component; start() was not yet called");
            return;
        }
        if (!this.justified && left == null) {
            System.err.println("left component cannot be null unless a justified layout is used");
            return;
        }
        int leftWidth = 0;
        int leftHeight = 0;
        if (left != null) {
            this.constrainLeft(left, this.anchorLeft, this.padEdge);
            if (this.previousRow == this.anchorTop) {
                this.constrainTop(left, this.anchorTop, this.padTop);
            } else {
                this.panel.layout("North", left, this.padRow, "South", this.previousRow);
            }
            leftWidth = left.getPreferredSize().width;
            leftHeight = left.getPreferredSize().height;
            this.panel.add(left);
        }
        int rightWidth = 0;
        int rightHeight = 0;
        if (right != null) {
            if (this.justified) {
                this.constrainRight(right, this.anchorRight, this.padEdge);
            } else {
                this.panel.layout("West", right, this.padTab, "East", left);
            }
            if (this.previousRow == this.anchorTop) {
                this.constrainTop(right, this.anchorTop, this.padTop);
            } else {
                this.panel.layout("North", right, this.padRow, "South", this.previousRow);
            }
            rightWidth = right.getPreferredSize().width;
            rightHeight = right.getPreferredSize().height;
            this.panel.add(right);
        }
        if (!this.justified) {
            this.preferredWidth = Math.max(this.preferredWidth, this.padEdge * 2 + leftWidth + this.padTab + rightWidth);
        }
        if (this.preferredHeight == 0) {
            this.preferredHeight = this.padRow;
        }
        this.preferredHeight += this.padRow + Math.max(leftHeight, rightHeight);
        if (right != null) {
            this.previousRow = right;
        } else if (left != null) {
            this.previousRow = left;
        }
    }

    public void start(int padTop, int padEdge, int padRow, int padTab, Component anchorLeft, Component anchorTop) {
        this.start();
        this.padTop = padTop;
        this.padEdge = padEdge;
        this.padRow = padRow;
        this.padTab = padTab;
        this.anchorLeft = anchorLeft;
        this.anchorTop = anchorTop;
        this.previousRow = anchorTop;
    }

    public void start(int padTop, int padEdge, int padRow, Component anchorLeft, Component anchorTop, Component anchorRight) {
        this.start();
        this.justified = true;
        this.padTop = padTop;
        this.padEdge = padEdge;
        this.padRow = padRow;
        this.anchorLeft = anchorLeft;
        this.anchorTop = anchorTop;
        this.anchorRight = anchorRight;
        this.previousRow = anchorTop;
    }
}

