/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.layout;

import java.awt.Component;
import net.javamon.dev.utils.layout.AbstractPanel;

public abstract class AbstractSpringLayout {
    protected boolean layout;
    protected AbstractPanel panel;
    protected int preferredWidth;
    protected int preferredHeight;

    protected AbstractSpringLayout(AbstractPanel panel) {
        this.panel = panel;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.end();
    }

    protected abstract void place(Component var1);

    protected abstract int getPreferredWidth();

    protected abstract int getPreferredHeight();

    protected void start() {
        this.end();
        this.layout = true;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
    }

    protected void end() {
        this.layout = false;
    }

    protected void constrainAll(Component c, Component top, Component right, Component bottom, Component left, int padTop, int padRight, int padBottom, int padLeft) {
        this.constrainTop(c, top, padTop);
        this.constrainRight(c, right, padRight);
        this.constrainBottom(c, bottom, padBottom);
        this.constrainLeft(c, left, padLeft);
    }

    protected void constrainTop(Component c, Component top, int pad) {
        if (c == null) {
            return;
        }
        if (top == this.panel.panel) {
            this.panel.layout("North", c, pad, "North", top);
        } else if (top != null) {
            this.panel.layout("North", c, pad, "South", top);
        }
    }

    protected void constrainRight(Component c, Component right, int pad) {
        if (c == null) {
            return;
        }
        if (right == this.panel.panel) {
            this.panel.layout("East", c, -pad, "East", right);
        } else if (right != null) {
            this.panel.layout("East", c, -pad, "West", right);
        }
    }

    protected void constrainBottom(Component c, Component bottom, int pad) {
        if (c == null) {
            return;
        }
        if (bottom == this.panel.panel) {
            this.panel.layout("South", c, -pad, "South", bottom);
        } else if (bottom != null) {
            this.panel.layout("South", c, -pad, "North", bottom);
        }
    }

    protected void constrainLeft(Component c, Component left, int pad) {
        if (c == null) {
            return;
        }
        if (left == this.panel.panel) {
            this.panel.layout("West", c, pad, "West", left);
        } else if (left != null) {
            this.panel.layout("West", c, pad, "East", left);
        }
    }
}

