/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import net.javamon.dev.IO;
import net.javamon.dev.ImageCache;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.JScrollList;
import net.javamon.dev.utils.JScrollPaneText;
import net.javamon.dev.utils.PanelColor;
import net.javamon.dev.utils.PanelImage;
import net.javamon.dev.utils.RotatedLabel;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.SpringColumnLayout;
import net.javamon.dev.utils.layout.SpringGridLayout;
import net.javamon.dev.utils.layout.SpringTableLayout;
import net.javamon.dev.utils.textPane.JTextPaneMarkup;

public abstract class AbstractPanel {
    protected static final String NORTH = "North";
    protected static final String EAST = "East";
    protected static final String SOUTH = "South";
    protected static final String WEST = "West";
    protected static final int CENTER = 0;
    protected static final int LEFT = 2;
    protected static final int RIGHT = 4;
    protected static final int TOP = 1;
    protected static final int BOTTOM = 3;
    public final JPanel panel = new JPanel();
    protected final SpringGridLayout layoutGrid;
    protected final SpringColumnLayout layoutColumn;
    protected final SpringTableLayout layoutTable;
    private ButtonGroup tempButtonGroup;
    private final SpringLayout layout = new SpringLayout();

    protected AbstractPanel() {
        this(null, -1, -1, new Object[0]);
    }

    protected AbstractPanel(String title) {
        this(title, -1, -1, new Object[0]);
    }

    protected AbstractPanel(int preferredWidth, int preferredHeight) {
        this(null, preferredWidth, preferredHeight, new Object[0]);
    }

    protected AbstractPanel(String title, int preferredWidth, int preferredHeight, Object ... args) {
        this.panel.setLayout(this.layout);
        this.layoutGrid = new SpringGridLayout(this);
        this.layoutColumn = new SpringColumnLayout(this);
        this.layoutTable = new SpringTableLayout(this);
        if (title != null) {
            title = args == null || args.length == 0 ? HTML.wrap(Resources.__(title, new Object[0])) : HTML.wrap(Resources.__(title, args));
            this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        }
        if (preferredWidth > 0 && preferredHeight > 0) {
            this.setPreferredSize(preferredWidth, preferredHeight);
        }
    }

    public abstract void setEnabled(boolean var1);

    public abstract void validate();

    public void setVisible(boolean visible) {
        this.panel.setVisible(visible);
    }

    public boolean isVisible() {
        return this.panel.isVisible();
    }

    public Dimension getPreferredSize() {
        return this.panel.getPreferredSize();
    }

    public void setPreferredSize(int width, int height) {
        this.panel.setPreferredSize(new Dimension(width, height));
    }

    protected int top() {
        return this.panel.getInsets().top;
    }

    protected int right() {
        return this.panel.getInsets().right;
    }

    protected int bottom() {
        return this.panel.getInsets().bottom;
    }

    protected int left() {
        return this.panel.getInsets().left;
    }

    protected int borderWidth() {
        Border b = this.panel.getBorder();
        if (b != null) {
            return b.getBorderInsets((Component)this.panel).left + b.getBorderInsets((Component)this.panel).right;
        }
        return 0;
    }

    protected int borderHeight() {
        Border b = this.panel.getBorder();
        if (b != null) {
            return b.getBorderInsets((Component)this.panel).top + b.getBorderInsets((Component)this.panel).bottom;
        }
        return 0;
    }

    protected BufferedImage scaleImage(BufferedImage image, int width, int height) {
        if (image == null) {
            return null;
        }
        int oldWidth = image.getWidth();
        int oldHeight = image.getHeight();
        if (width <= 0 || height <= 0 || width == oldWidth || height == oldHeight || oldWidth == 0 || oldHeight == 0) {
            return image;
        }
        AffineTransform scale = new AffineTransform();
        scale.scale((float)width / (float)oldWidth, (float)height / (float)oldHeight);
        AffineTransformOp operator = new AffineTransformOp(scale, 1);
        BufferedImage scaled = new BufferedImage(width, height, image.getType());
        return operator.filter(image, scaled);
    }

    protected void colorImage(BufferedImage src, BufferedImage dest, float red, float green, float blue, float alpha) {
        if (src.getWidth() != dest.getWidth() || src.getHeight() != dest.getHeight()) {
            return;
        }
        int x = 0;
        while (x < dest.getWidth()) {
            int y = 0;
            while (y < dest.getHeight()) {
                int color = src.getRGB(x, y);
                int r = (color & 0xFF0000) >> 16;
                int g = (color & 0xFF00) >> 8;
                int b = color & 0xFF;
                int a = (color & 0xFF000000) >>> 24;
                r = (int)((float)r * red / 255.0f);
                g = (int)((float)g * green / 255.0f);
                b = (int)((float)b * blue / 255.0f);
                a = (int)((float)a * alpha / 255.0f);
                color = a << 24 | r << 16 | g << 8 | b;
                dest.setRGB(x, y, color);
                ++y;
            }
            ++x;
        }
    }

    protected BufferedImage copyImage(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        boolean isAlphaPremultiplied = colorModel.isAlphaPremultiplied();
        WritableRaster raster = image.copyData(image.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(colorModel, raster, isAlphaPremultiplied, null);
    }

    protected void add(Component c) {
        this.panel.add(c);
    }

    protected JLabelHTML createLabel(String textKey, String tooltipKey) {
        return this.createLabel(textKey, tooltipKey, -1);
    }

    protected JLabelHTML createLabel(String textKey, String tooltipKey, int width) {
        JLabelHTML label = textKey == null ? new JLabelHTML(width) : new JLabelHTML(Resources.__(textKey, new Object[0]), width);
        label.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return label;
    }

    protected RotatedLabel createRotatedLabel(String textKey, String tooltipKey, int rotation) {
        RotatedLabel label = new RotatedLabel(rotation);
        if (textKey != null) {
            label.setText(HTML.wrap(Resources.__(textKey, new Object[0])));
        }
        label.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return label;
    }

    protected JTextField createTextField(String textKey, int width, String tooltipKey) {
        JTextField textField = new JTextField(width);
        textField.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        if (textKey != null) {
            textField.setText(Resources.__(textKey, new Object[0]));
        }
        return textField;
    }

    protected JButton createButton(String textKey, String tooltipKey, int width, int height) {
        JButton button = textKey == null ? new JButton() : new JButton(Resources.__(textKey, new Object[0]));
        button.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        if (width > 0 && height > 0) {
            button.setPreferredSize(new Dimension(width, height));
        }
        return button;
    }

    protected JCheckBox createCheckBox(String tooltipKey, boolean selected) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(selected);
        checkBox.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return checkBox;
    }

    protected PanelImage createImageFromData(ImageCache.BufferedImageData imageData, String tooltipKey, int width, int height) {
        PanelImage panel = new PanelImage(imageData);
        panel.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        if (width > 0 && height > 0) {
            panel.setPreferredSize(new Dimension(width, height));
        }
        return panel;
    }

    protected PanelImage createImage(BufferedImage image, String tooltipKey, int width, int height) {
        PanelImage panel = new PanelImage(image);
        panel.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        if (width > 0 && height > 0) {
            panel.setPreferredSize(new Dimension(width, height));
        }
        return panel;
    }

    protected ExtendableJComboBox<String> createComboBox(String tooltipKey, String ... items) {
        return this.createComboBox(-1, tooltipKey, items);
    }

    protected ExtendableJComboBox<String> createComboBox(int width, String tooltipKey, String ... items) {
        ExtendableJComboBox<String> box = new ExtendableJComboBox<String>();
        if (width > 0) {
            box.setPreferredSize(new Dimension(width, 25));
        }
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                box.addItem(HTML.wrap(items[i]));
                ++i;
            }
        }
        box.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return box;
    }

    protected JTextPane createHTMLPane(String textKey, String tooltipKey) {
        JTextPane toReturn = new JTextPane();
        toReturn.setContentType("text/html");
        toReturn.putClientProperty("JEditorPane.honorDisplayProperties", true);
        toReturn.setOpaque(false);
        toReturn.setBorder(null);
        toReturn.setMargin(new Insets(5, 5, 5, 5));
        toReturn.setEditable(false);
        toReturn.setText(HTML.wrap(Resources.__(textKey, new Object[0])));
        toReturn.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return toReturn;
    }

    protected JTextPaneMarkup createTextPane(int style, boolean wrap, String textKey, String tooltipKey, int rows, int columns, boolean allowNewline, boolean allowTab) {
        JTextPaneMarkup textPane = new JTextPaneMarkup(style, wrap, Resources.__(textKey, new Object[0]), rows, columns, allowNewline, allowTab);
        textPane.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return textPane;
    }

    protected JScrollPaneText createScrollText(int style, String textKey, String tooltipKey, int rows, int columns, boolean allowNewline, boolean allowTab, boolean scrollH, boolean scrollV) {
        return this.createScrollText(style, textKey, tooltipKey, rows, columns, allowNewline, allowTab, scrollH, scrollV, -1, -1);
    }

    protected JScrollPaneText createScrollText(int style, String textKey, String tooltipKey, int rows, int columns, boolean allowNewline, boolean allowTab, boolean scrollH, boolean scrollV, int width, int height) {
        JTextPaneMarkup textPane = this.createTextPane(style, !scrollH, textKey, tooltipKey, rows, columns, allowNewline, allowTab);
        JScrollPaneText scrollPane = new JScrollPaneText(textPane, scrollH, scrollV);
        scrollPane.setToolTipText(textPane.getToolTipText());
        if (width > 0 && height > 0) {
            scrollPane.setPreferredSize(new Dimension(width, height));
        }
        return scrollPane;
    }

    protected PanelColor createColorPanel(int red, int green, int blue, int alpha, int width, int height, int borderWidth, String tooltipKey) {
        return this.createColorPanel(new Color(red, green, blue, alpha), width, height, borderWidth, tooltipKey);
    }

    protected PanelColor createColorPanel(Color color, int width, int height, int borderWidth, String tooltipKey) {
        PanelColor panel = new PanelColor(color, width, height, borderWidth);
        panel.panel.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        return panel;
    }

    protected JRadioButton createRadioButton(String textKey, String tooltipKey, int width, int height, boolean addToGroup) {
        JRadioButton button = new JRadioButton();
        if (textKey != null) {
            button.setText(HTML.wrap(Resources.__(textKey, new Object[0])));
        }
        button.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        if (width > 0 && height > 0) {
            button.setPreferredSize(new Dimension(width, height));
        }
        if (addToGroup) {
            this.addButtonToGroup(button);
        }
        return button;
    }

    protected JScrollList createList(String tooltipKey, int selectionMode, int wrapMode, int width, int height, String[] entryTooltips, String ... entries) {
        JScrollList list = new JScrollList(selectionMode, wrapMode, width, height);
        list.list().setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        if (entries != null && entries.length > 0) {
            list.updateView(entryTooltips, entries);
        }
        return list;
    }

    protected void startButtonGroup() {
        if (this.tempButtonGroup == null) {
            this.tempButtonGroup = new ButtonGroup();
        } else {
            System.err.println("cannot start button group; endButtonGroup() has not yet been called for the previous group");
        }
    }

    protected void addButtonToGroup(AbstractButton button) {
        if (this.tempButtonGroup != null) {
            this.tempButtonGroup.add(button);
        } else {
            System.err.println("cannot add button to group; startButtonGroup() has not yet been called");
        }
    }

    protected void endButtonGroup() {
        if (this.tempButtonGroup != null) {
            this.tempButtonGroup = null;
        } else {
            System.err.println("cannot end button group; startButtonGroup() has not yet been called");
        }
    }

    protected void denormalizeBytes(int[] values, JTextField[] fields) {
        if (values.length != fields.length) {
            System.err.println("cannot denormalize values with length " + values.length + "; number of fields " + fields.length + " does not match");
            return;
        }
        int i = 0;
        while (i < fields.length) {
            if (i == 0) {
                fields[i].setText(String.valueOf(values[i]));
            } else {
                fields[i].setText(String.valueOf(IO.byteDenormalize(values[i], values[i - 1])));
            }
            ++i;
        }
    }

    protected int[] normalizeBytes(JTextField[] fields) {
        int[] toNormalize = new int[fields.length];
        int i = 0;
        while (i < fields.length) {
            toNormalize[i] = Integer.parseInt(fields[i].getText());
            ++i;
        }
        return IO.byteNormalize(toNormalize);
    }

    protected void align(JLabel label, int horizontal, int vertical) {
        label.setHorizontalAlignment(horizontal);
        label.setVerticalAlignment(vertical);
    }

    protected boolean setZ(Component c, int index) {
        int correctBound = Math.max(0, Math.min(this.panel.getComponentCount(), index));
        this.panel.setComponentZOrder(c, correctBound);
        return correctBound == index;
    }

    protected void focusPanelOnClick() {
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbstractPanel.this.panel.requestFocusInWindow();
            }
        });
    }

    protected void layout(String e1, Component c1, int pad, String e2, Component c2) {
        this.layout.putConstraint(e1, c1, pad, e2, c2);
    }

    protected void layoutFill(Component c, int pad, Component top, Component right, Component bottom, Component left) {
        if (top == this.panel) {
            this.layout(NORTH, c, pad, NORTH, top);
        } else {
            this.layout(NORTH, c, pad, SOUTH, top);
        }
        if (right == this.panel) {
            this.layout(EAST, c, -pad, EAST, right);
        } else {
            this.layout(EAST, c, -pad, WEST, right);
        }
        if (bottom == this.panel) {
            this.layout(SOUTH, c, -pad, SOUTH, bottom);
        } else {
            this.layout(SOUTH, c, -pad, NORTH, bottom);
        }
        if (left == this.panel) {
            this.layout(WEST, c, pad, WEST, left);
        } else {
            this.layout(WEST, c, pad, EAST, left);
        }
    }
}

