/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.fileUsage.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.fileUsage.AbstractFileProcessor;
import net.javamon.dev.utils.fileUsage.panels.PanelMain;

public class RunReportListener
implements ActionListener {
    private static final int MAX_SEARCH_LENGTH = 5;
    private boolean isSearching;
    private String searchString;
    private String baseString;
    private final PanelMain parent;
    private final AbstractFileProcessor processor;

    protected RunReportListener(PanelMain parent, AbstractFileProcessor processor) {
        this.parent = parent;
        this.processor = processor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.parent.setEnabled(false);
        this.isSearching = true;
        this.baseString = Resources.__("mainReportWorking", new Object[0]);
        this.searchString = "";
        this.processor.clear(false);
        this.parent.generate.setText(HTML.wrap(this.baseString));
        this.parent.generate.repaint();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (RunReportListener.this.isSearching) {
                    int length = RunReportListener.this.searchString.length();
                    if (length < 5) {
                        RunReportListener runReportListener = RunReportListener.this;
                        runReportListener.searchString = String.valueOf(runReportListener.searchString) + ".";
                    } else {
                        RunReportListener.this.searchString = "";
                    }
                    ((RunReportListener)RunReportListener.this).parent.generate.setText(HTML.wrap(String.valueOf(RunReportListener.this.baseString) + RunReportListener.this.searchString));
                    ((RunReportListener)RunReportListener.this).parent.generate.repaint();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (RunReportListener.this.isSearching) continue;
                    ((RunReportListener)RunReportListener.this).parent.generate.setText(HTML.wrap(Resources.__("mainReportGenerate", new Object[0])));
                    ((RunReportListener)RunReportListener.this).parent.generate.repaint();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                RunReportListener.this.search(RunReportListener.this.processor.getRoot());
                RunReportListener.this.parent.updateView(RunReportListener.this.processor.getFormatted());
                RunReportListener.this.parent.setEnabled(true);
                RunReportListener.this.isSearching = false;
            }
        }).start();
    }

    private void search(File currFile) {
        if (this.processor.isSearchableFile(currFile)) {
            try {
                this.processor.process(currFile);
            }
            catch (Exception exception) {}
        } else if (currFile.isDirectory()) {
            File[] fileArray = currFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.search(f);
                ++n2;
            }
        }
    }
}

