/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.fileUsage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.javamon.dev.NaturalOrder;
import net.javamon.dev.Resources;

public class UsageMap {
    public static final int NATURAL_ORDER = 0;
    public static final int LARGEST_FIRST = 1;
    public static final int SMALLEST_FIRST = 2;
    private HashMap<String, Usage> map = new HashMap();
    private final boolean allowMulti;
    private final int sortMode;

    protected UsageMap(boolean allowMulti, int sortMode) {
        this.allowMulti = allowMulti;
        this.sortMode = sortMode;
    }

    public Usage addEntry(String prefix, String editorID) {
        if (this.map.get(editorID) != null) {
            return null;
        }
        String displayName = editorID;
        if (displayName.startsWith(prefix)) {
            displayName = displayName.substring(prefix.length());
        }
        return this.map.put(editorID, new Usage(prefix, this.allowMulti, this.sortMode));
    }

    public Usage removeEntry(String editorID) {
        return this.map.remove(editorID);
    }

    public void addFile(String editorID, String prefix, String file) {
        Usage usage = this.map.get(editorID);
        if (usage == null) {
            usage = this.addEntry(editorID, prefix);
        }
        usage.add(file);
    }

    public void clearMap() {
        this.map.clear();
    }

    public void clearAndSet(String prefix, String ... newEntries) {
        this.clearMap();
        int i = 0;
        while (i < newEntries.length) {
            this.addEntry(newEntries[i], prefix);
            ++i;
        }
    }

    public void clearUsage() {
        for (Map.Entry<String, Usage> entry : this.map.entrySet()) {
            entry.getValue().clear();
        }
    }

    public String getFormatted() {
        Set<Map.Entry<String, Usage>> entries = this.map.entrySet();
        ArrayList<Map.Entry<String, Usage>> list = new ArrayList<Map.Entry<String, Usage>>(entries);
        list.sort(Map.Entry.comparingByValue(new UsageComparator()));
        StringBuilder formatted = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            formatted.append(Resources.__("mainReportEntryHeader", list.get(i).getValue().getFormatted()));
            ++i;
        }
        return formatted.toString();
    }

    private class Usage
    implements Comparable<Usage> {
        private HashSet<String> files = new HashSet(2);
        private boolean error;
        private final String entry;
        private final boolean allowMulti;
        private final int sortMode;

        private Usage(String entry, boolean allowMulti, int sortMode) {
            this.entry = entry;
            this.allowMulti = allowMulti;
            this.sortMode = sortMode;
        }

        @Override
        public int compareTo(Usage o) {
            if (this.files.size() == o.files.size() || this.sortMode == 0) {
                return NaturalOrder.compare(this.entry, o.entry);
            }
            if (this.files.size() > o.files.size()) {
                int n = -1;
            }
            int order = 1;
            if (this.sortMode == 2) {
                order *= -1;
            }
            return order;
        }

        private void add(String file) {
            boolean duplicate;
            boolean bl = duplicate = !this.files.add(file);
            if ((this.files.size() > 1 || duplicate) && !this.allowMulti) {
                this.error = true;
            }
        }

        private void clear() {
            this.files.clear();
            this.error = false;
        }

        private String getFormatted() {
            if (this.files.size() == 0) {
                return Resources.__("mainReportEntryNone", this.entry);
            }
            String formatted = this.error ? Resources.__("mainReportEntryError", this.entry) : Resources.__("mainReportEntry", this.entry);
            for (String file : this.files) {
                formatted = String.valueOf(formatted) + Resources.__("mainReportEntryFile", file);
            }
            return formatted;
        }
    }

    private static class UsageComparator
    implements Comparator<Usage> {
        private UsageComparator() {
        }

        @Override
        public int compare(Usage o1, Usage o2) {
            return o1.compareTo(o2);
        }
    }
}

