/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.fileUsage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.javamon.dev.AbstractSubFrame;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.ButtonHideShow;
import net.javamon.dev.utils.fileUsage.AbstractFileProcessor;
import net.javamon.dev.utils.fileUsage.UsageMap;
import net.javamon.dev.utils.fileUsage.panels.PanelMain;

public class FrameUsage
extends AbstractSubFrame {
    private UsageMap map;
    private PanelMain panelMain;
    private AbstractFileProcessor processor;

    public FrameUsage(String titleKey, boolean allowMulti, int sortMode, String root, Pattern pattern, String ... extensions) {
        this(titleKey, null, allowMulti, sortMode);
        this.processor = new LineProcessor(root, this.map, pattern, extensions);
        this.setFrame(allowMulti);
    }

    public FrameUsage(String titleKey, AbstractFileProcessor processor, boolean allowMulti, int sortMode) {
        super(titleKey, 600, 600, new Object[0]);
        this.frame.setVisible(false);
        super.pack();
        this.map = new UsageMap(allowMulti, sortMode);
        this.processor = processor;
        if (processor != null) {
            this.setFrame(allowMulti);
        }
    }

    @Override
    public PanelMain main() {
        return this.panelMain;
    }

    @Override
    public void setFrame() {
    }

    public UsageMap getMap() {
        return this.map;
    }

    private void setFrame(boolean allowMulti) {
        this.panelMain = new PanelMain(this.processor, allowMulti);
        this.frame.add(this.panelMain.panel);
        new ButtonHideShow(this.panelMain.hide, this.frame, null, true);
    }

    private static class LineProcessor
    extends AbstractFileProcessor {
        protected final Pattern pattern;

        private LineProcessor(String root, UsageMap map, Pattern pattern, String ... extensions) {
            super(root, map, extensions);
            this.pattern = pattern;
        }

        @Override
        public void process(File file) throws Exception {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String next = reader.readLine();
            while (next != null) {
                Matcher matcher = this.pattern.matcher(next);
                while (matcher.find()) {
                    String editorID = matcher.group();
                    this.map.addEntry(editorID, Resources.trimFullPath(file.getAbsolutePath()));
                }
                next = reader.readLine();
            }
            reader.close();
        }
    }
}

