/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.fileUsage;

import java.io.File;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.fileUsage.UsageMap;

public abstract class AbstractFileProcessor {
    protected final UsageMap map;
    private final String root;
    private final String[] extensions;

    protected AbstractFileProcessor(String root, UsageMap map, String ... extensions) {
        this.map = map;
        this.root = root;
        this.extensions = extensions;
    }

    public abstract void process(File var1) throws Exception;

    public File getRoot() {
        return Resources.getRelativePath(this.root);
    }

    public void clear(boolean clearMap) {
        if (clearMap) {
            this.map.clearMap();
        } else {
            this.map.clearUsage();
        }
    }

    public String getFormatted() {
        return this.map.getFormatted();
    }

    public boolean isSearchableFile(File currFile) {
        if (!currFile.isFile()) {
            return false;
        }
        if (this.extensions == null || this.extensions.length == 0) {
            return true;
        }
        String name = currFile.getName();
        int i = 0;
        while (i < this.extensions.length) {
            if (name.endsWith(this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

