/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.dictionary;

import java.util.ArrayList;
import java.util.Comparator;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.dictionary.DictionaryEntry;

public abstract class AbstractDictionary {
    private ArrayList<ValidateAbstractDictionary> parents = new ArrayList();
    private ArrayList<DictionaryEntry> entries = new ArrayList();
    private final Comparator<DictionaryEntry> comparator = new Comparator<DictionaryEntry>(){

        @Override
        public int compare(DictionaryEntry o1, DictionaryEntry o2) {
            return o2.entry.compareTo(o1.entry);
        }
    };
    private SearchResult result = new SearchResult();

    protected AbstractDictionary() {
    }

    public synchronized int size() {
        return this.entries.size();
    }

    public synchronized DictionaryEntry getByIndex(int index) {
        if (index < 0 || index >= this.entries.size()) {
            return null;
        }
        return this.entries.get(index);
    }

    protected synchronized void merge(AbstractDictionary other) {
        int i = 0;
        while (i < other.entries.size()) {
            this.entries.add(this.entries.get(i));
            ++i;
        }
        this.sort();
        this.notifyParents();
    }

    protected synchronized void fromAll(AbstractDictionary ... dictionaries) {
        this.clear();
        int i = 0;
        while (i < dictionaries.length) {
            int j = 0;
            while (j < dictionaries[i].entries.size()) {
                this.entries.add(dictionaries[i].entries.get(j));
                ++j;
            }
            ++i;
        }
        this.sort();
        this.notifyParents();
    }

    protected synchronized void fromAll(ValidateAbstractDictionary ... dictionaries) {
        this.clear();
        int i = 0;
        while (i < dictionaries.length) {
            int j = 0;
            while (j < dictionaries[i].dictionary.entries.size()) {
                this.entries.add(dictionaries[i].dictionary.entries.get(j));
                ++j;
            }
            dictionaries[i].changed = false;
            ++i;
        }
        this.sort();
        this.notifyParents();
    }

    protected synchronized void add(int mode, String entry, String tooltipKey, Object ... args) {
        this.entries.add(new DictionaryEntry(mode, entry, HTML.wrap(Resources.__(tooltipKey, args))));
        this.result.clear();
        this.notifyParents();
    }

    protected synchronized boolean remove(String entry) {
        this.find(entry);
        if (this.result.end != -1 && this.result.start == this.result.end) {
            this.entries.remove(this.result.start);
            this.result.clear();
            this.notifyParents();
            return true;
        }
        return false;
    }

    protected synchronized void clear() {
        this.entries.clear();
        this.result.clear();
        this.notifyParents();
    }

    protected synchronized void sort() {
        this.entries.sort(this.comparator);
        this.result.clear();
    }

    protected synchronized SearchResult find(String entry) {
        int index = this.result.searchResult != null && this.result.searchResult.startsWith(entry) ? this.result.searchResultIndex : this.find(entry, 0, this.entries.size() - 1);
        if (index != -1) {
            this.result.searchResult = this.entries.get((int)index).entry;
            this.result.searchResultIndex = index;
            this.result.start = this.findBound(entry, index, 1, 0, 0, false);
            this.result.end = this.findBound(entry, index, 1, 0, 0, true);
        } else {
            this.result.clear();
        }
        return this.result;
    }

    private synchronized int find(String entry, int min, int max) {
        if (max < min) {
            return -1;
        }
        int middle = (max - min) / 2 + min;
        int comparison = this.compareByCharacters(this.entries.get((int)middle).entry, entry);
        if (comparison > 0) {
            return this.find(entry, min, middle - 1);
        }
        if (comparison < 0) {
            return this.find(entry, middle + 1, max);
        }
        return middle;
    }

    private synchronized int findBound(String entry, int start, int jump, int min, int max, boolean up) {
        int edge;
        int toCheck;
        if (up) {
            toCheck = Math.min(this.entries.size() - 1, start + jump);
            edge = Math.min(this.entries.size() - 1, toCheck + 1);
        } else {
            toCheck = Math.max(0, start - jump);
            edge = Math.max(0, toCheck - 1);
        }
        int comparison = this.compareByCharacters(this.entries.get((int)toCheck).entry, entry);
        int n = comparison = up ? comparison : -comparison;
        if (jump == 1 && comparison != 0) {
            return start;
        }
        if (comparison > 0) {
            int middle = (jump - min) / 2 + min;
            return this.findBound(entry, start, middle, min, max, up);
        }
        if (comparison < 0) {
            int middle = (max - jump) / 2 + jump;
            return this.findBound(entry, start, middle, jump, max, up);
        }
        if (edge == toCheck || this.compareByCharacters(this.entries.get((int)edge).entry, entry) != 0) {
            return toCheck;
        }
        return this.findBound(entry, start, jump * 2, jump, jump * 2, up);
    }

    private synchronized int compareByCharacters(String s1, String s2) {
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        int n = c2.length < c1.length ? c2.length : c1.length;
        int i = 0;
        while (i < n) {
            int diff = Character.toUpperCase(c2[i]) - Character.toUpperCase(c1[i]);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        if (c1.length < c2.length) {
            return 1;
        }
        return 0;
    }

    private synchronized void addParent(ValidateAbstractDictionary parent) {
        this.parents.add(parent);
    }

    private synchronized void notifyParents() {
        for (ValidateAbstractDictionary parent : this.parents) {
            parent.changed = true;
        }
    }

    public static class SearchResult {
        private String searchResult;
        private int searchResultIndex;
        private int start;
        private int end;

        public boolean found() {
            return this.start != -1 && this.end != -1;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        protected void clear() {
            this.searchResult = null;
            this.searchResultIndex = -1;
            this.start = -1;
            this.end = -1;
        }
    }

    protected static class ValidateAbstractDictionary {
        protected AbstractDictionary dictionary;
        protected boolean changed;

        protected ValidateAbstractDictionary(AbstractDictionary dictionary) {
            this.dictionary = dictionary;
            dictionary.addParent(this);
            this.changed = true;
        }
    }
}

