/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.dataList;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.AbstractActionListener;
import net.javamon.dev.utils.layout.AbstractPanel;

public abstract class AbstractPanelEntry
extends AbstractPanel {
    public final ExtendableJComboBox<String> list = this.setBox();
    protected AbstractDataEntry[] entries;
    protected AbstractDataEntry currEntry;
    public final JButton reset;
    private int currIndex;

    protected AbstractPanelEntry(int numItems) {
        this(numItems, null, -1, -1, new Object[0]);
    }

    protected AbstractPanelEntry(int numItems, String title) {
        this(numItems, title, -1, -1, new Object[0]);
    }

    protected AbstractPanelEntry(int numItems, int preferredWidth, int preferredHeight) {
        this(numItems, null, preferredWidth, preferredHeight, new Object[0]);
    }

    protected AbstractPanelEntry(int numItems, String title, int preferredWidth, int preferredHeight, Object ... args) {
        super(title, preferredWidth, preferredHeight, args);
        if (this.list != null) {
            this.layout("North", this.list, 5, "North", this.panel);
            this.layout("West", this.list, 5, "West", this.panel);
            this.list.addActionListener(new SelectListener(this, true));
            this.add(this.list);
        }
        this.entries = new AbstractDataEntry[numItems];
        int i = 0;
        while (i < numItems) {
            this.entries[i] = this.createEntry(i);
            ++i;
        }
        this.currEntry = this.createEntry(-1);
        this.layoutFill(this.currEntry.panel, 5, this.panel, this.panel, this.panel, this.list);
        this.add(this.currEntry.panel);
        this.reset = this.setReset();
        if (this.reset != null) {
            this.layout("South", this.reset, -5, "South", this.panel);
            this.layout("West", this.reset, 5, "West", this.panel);
            this.reset.addActionListener(new SelectListener(this, false));
            this.add(this.reset);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
        this.currEntry.setEnabled(enabled);
        this.reset.setEnabled(enabled);
    }

    @Override
    public void validate() {
        this.currIndex = this.list.getSelectedIndex();
        this.currEntry.validate();
    }

    public abstract AbstractDataEntry getEntry(int var1, boolean var2);

    public abstract AbstractDataEntry getCurrEntry();

    protected abstract ExtendableJComboBox<String> setBox();

    protected abstract AbstractDataEntry createEntry(int var1);

    protected abstract JButton setReset();

    public int getNumEntries() {
        return this.entries.length;
    }

    public void load(int index, boolean saveFirst) {
        if (saveFirst) {
            this.save();
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
        }
        this.currIndex = index;
        this.currEntry.copyFrom(this.entries[index]);
    }

    protected void save() {
        this.entries[this.currIndex].copyFrom(this.currEntry);
    }

    protected static abstract class AbstractDataEntry
    extends AbstractPanel {
        protected AbstractDataEntry() {
        }

        protected AbstractDataEntry(String title) {
            super(title);
        }

        protected AbstractDataEntry(int preferredWidth, int preferredHeight) {
            super(preferredWidth, preferredHeight);
        }

        protected AbstractDataEntry(String title, int preferredWidth, int preferredHeight, Object ... args) {
            super(title, preferredWidth, preferredHeight, args);
        }

        protected abstract void copyFrom(AbstractDataEntry var1);
    }

    public static class SelectListener
    extends AbstractActionListener {
        private final AbstractPanelEntry parent;
        private final boolean saveFirst;

        public SelectListener(AbstractPanelEntry parent, boolean saveFirst) {
            this.parent = parent;
            this.saveFirst = saveFirst;
        }

        @Override
        public void performAction(ActionEvent e) {
            this.parent.load(this.parent.list.getSelectedIndex(), this.saveFirst);
            this.parent.validate();
        }
    }
}

