/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import java.util.regex.Pattern;
import net.javamon.dev.utils.commandParser.option.Option;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class OptionBuilder<T> {
    private static final Pattern VALID_LONG = Pattern.compile("[a-zA-Z_0-9]+");
    private static final Pattern VALID_SHORT = Pattern.compile("[a-zA-Z]");
    private boolean required;
    private boolean hasArgument;
    private T defaultArgument;
    private String tokenShort;
    private String tokenLong;
    private String description;
    private final OptionType<T> type;

    public OptionBuilder(OptionType<T> type) {
        this.type = type;
    }

    public OptionBuilder(OptionType<T> type, boolean required) {
        this(type);
        this.required = required;
    }

    public OptionBuilder(OptionType<T> type, boolean required, boolean hasArgument) {
        this(type, required);
        this.hasArgument = hasArgument;
    }

    public OptionBuilder(OptionType<T> type, boolean required, boolean hasArgument, String tokenShort) {
        this(type, required, hasArgument);
        this.tokenShort(tokenShort);
    }

    public OptionBuilder(OptionType<T> type, boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        this(type, required, hasArgument, tokenShort);
        this.tokenLong(tokenLong);
    }

    public Option<T> build() {
        try {
            if (!this.hasArgument) {
                this.type.coerce(true);
            }
            return new Option<T>(this.type, this.required, this.hasArgument, this.defaultArgument, this.tokenShort, this.tokenLong, this.description);
        }
        catch (ClassCastException e) {
            if (!this.hasArgument) {
                throw new RuntimeException("options without flags must be of type Boolean");
            }
            e.printStackTrace();
            throw new RuntimeException("illegal/mismatched option type");
        }
    }

    public OptionBuilder<T> required(boolean required) {
        this.required = required;
        return this;
    }

    public OptionBuilder<T> hasArgument(boolean hasArgument) {
        this.hasArgument = hasArgument;
        return this;
    }

    public OptionBuilder<T> defaultArgument(T defaultArgument) {
        this.defaultArgument = defaultArgument;
        return this;
    }

    public OptionBuilder<T> tokenShort(String tokenShort) {
        if (tokenShort == null) {
            return this;
        }
        if (tokenShort.length() > 1) {
            throw new RuntimeException("'" + tokenShort + "' is too long; short-form tokens can only be a single character");
        }
        if (!VALID_SHORT.matcher(tokenShort).matches()) {
            throw new RuntimeException("illegal format for '" + tokenShort + "'; only alphabet characters are permitted");
        }
        this.tokenShort = tokenShort;
        return this;
    }

    public OptionBuilder<T> tokenLong(String tokenLong) {
        if (tokenLong == null) {
            return this;
        }
        if (tokenLong.length() < 2) {
            throw new RuntimeException("'" + tokenLong + "' is too short; long-form tokens must be at least two characters");
        }
        if (!VALID_LONG.matcher(tokenLong).matches()) {
            throw new RuntimeException("illegal format for '" + tokenLong + "'; only alphanumeric characters are permitted");
        }
        this.tokenLong = tokenLong;
        return this;
    }

    public OptionBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public static class BadClassException
    extends RuntimeException {
        private static final long serialVersionUID = 2111165827403087654L;
        public final Class<?> clazz;

        private BadClassException(Class<?> clazz) {
            super("class '" + clazz + "' does not have a primitive OptionType; " + "use a custom OptionType class instead");
            this.clazz = clazz;
        }
    }
}

