/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionType;

public class Option<T> {
    private T argument;
    private final OptionType<T> type;
    private final boolean required;
    private final boolean hasArgument;
    private final T defaultArgument;
    private final String tokenShort;
    private final String tokenLong;
    private final String description;

    protected Option(OptionType<T> type, boolean required, boolean hasArgument, T defaultArgument, String tokenShort, String tokenLong, String description) {
        boolean tokenShortEmpty;
        boolean bl = tokenShortEmpty = tokenShort == null || tokenShort.length() == 0;
        if (tokenLong == null && tokenShortEmpty || tokenLong.length() == 0 && tokenShortEmpty) {
            throw new RuntimeException("cannot create option without a token");
        }
        if (required && !hasArgument) {
            throw new RuntimeException("binary option flags cannot be made required");
        }
        if (defaultArgument != null && !hasArgument) {
            throw new RuntimeException("cannot add a default argument to a no-argument option");
        }
        if (defaultArgument != null && required) {
            throw new RuntimeException("required options cannot have default arguments");
        }
        this.type = type;
        this.required = required;
        this.hasArgument = hasArgument;
        this.defaultArgument = defaultArgument;
        this.tokenShort = tokenShort;
        this.tokenLong = tokenLong;
        this.description = description;
    }

    public static String strip(String token) {
        if (token.startsWith("--")) {
            return token.substring(2);
        }
        if (token.startsWith("-")) {
            return token.substring(1);
        }
        return null;
    }

    public static String stripArg(String token) {
        int index;
        if (token.startsWith("--") && (index = token.indexOf("=")) != -1 && index < token.length() - 1) {
            return token.substring(index + 1);
        }
        return null;
    }

    public static boolean wasShort(String token, String stripped) {
        return token != null && stripped != null && token.length() - stripped.length() == 1;
    }

    public String getHelp(String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent);
        if (this.tokenShort != null) {
            builder.append("-" + this.tokenShort);
            if (this.tokenLong != null) {
                builder.append(", ");
            }
        }
        if (this.tokenLong != null) {
            builder.append("--" + this.tokenLong);
        }
        if (this.description != null && this.description.length() > 0) {
            String[] tokens = this.description.split("\n");
            StringBuilder tokenBuilder = new StringBuilder();
            tokenBuilder.append(String.format("%-30s%s", builder.toString(), tokens[0]));
            tokenBuilder.append("\n");
            int i = 1;
            while (i < tokens.length) {
                tokenBuilder.append(String.format("%-30s%s", "", tokens[i]));
                tokenBuilder.append("\n");
                ++i;
            }
            return tokenBuilder.toString();
        }
        return builder.toString();
    }

    public String getTokens() {
        StringBuilder builder = new StringBuilder();
        if (this.tokenShort != null) {
            builder.append("-" + this.tokenShort);
            if (this.tokenLong != null) {
                builder.append(", ");
            }
        }
        if (this.tokenLong != null) {
            builder.append("--" + this.tokenLong);
        }
        if (this.hasArgument) {
            builder.append(" <arg>");
        }
        return builder.toString();
    }

    public OptionType<T> getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean hasArgument() {
        return this.hasArgument;
    }

    public boolean hasDefaultArgument() {
        return this.defaultArgument != null;
    }

    public String getTokenShort() {
        return this.tokenShort;
    }

    public String getTokenLong() {
        return this.tokenLong;
    }

    public T getArgument() {
        if (this.argument == null && this.hasArgument) {
            return this.defaultArgument;
        }
        return this.argument;
    }

    public T getArgumentNoDefault() {
        return this.argument;
    }

    public void clearArgument() {
        this.argument = null;
    }

    public void setArgument(String argument) throws OptionType.BadTypeException {
        this.argument = this.type.convert(argument);
    }
}

